/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.operators;

import eu.stamp_project.mutationtest.descartes.operators.MutationOperator;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;
import org.pitest.reloc.asm.commons.Method;

public class EmptyArrayMutationOperator
extends MutationOperator {
    private static final int[] type2opcode = new int[]{0, 4, 5, 8, 9, 10, 6, 11, 7};

    @Override
    public boolean canMutate(Method method) {
        return method.getReturnType().getSort() == 9;
    }

    @Override
    public void generateCode(Method method, MethodVisitor mv) {
        Type arrayType = method.getReturnType();
        Type elementType = arrayType.getElementType();
        mv.visitInsn(3);
        if (arrayType.getDimensions() > 1) {
            for (int i = 1; i < arrayType.getDimensions(); ++i) {
                mv.visitInsn(3);
            }
            mv.visitMultiANewArrayInsn(arrayType.getDescriptor(), arrayType.getDimensions());
        } else if (elementType.getSort() == 10) {
            mv.visitTypeInsn(189, elementType.getInternalName());
        } else {
            mv.visitIntInsn(188, type2opcode[elementType.getSort()]);
        }
        mv.visitInsn(176);
    }

    @Override
    public String getID() {
        return "empty";
    }

    @Override
    public String getDescription() {
        return "Method body replaced by instructions that returns an empty array of the corresponding type";
    }
}

