/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.bodyanalysis;

import java.util.NoSuchElementException;
import org.pitest.classinfo.ClassName;
import org.pitest.reloc.asm.commons.Method;

public class LineCounter {
    private final ClassName className;
    private final Method method;
    private int firstLine;
    private int lastLine;

    public LineCounter(ClassName className, Method method) {
        this.className = className;
        this.method = method;
        this.reset();
    }

    public void reset() {
        this.firstLine = Integer.MAX_VALUE;
        this.lastLine = Integer.MIN_VALUE;
    }

    public void registerLine(int line) {
        this.firstLine = Math.min(this.firstLine, line);
        this.lastLine = Math.max(this.lastLine, line);
    }

    public boolean empty() {
        return this.firstLine > this.lastLine;
    }

    public int getCount() {
        if (this.empty()) {
            return 0;
        }
        return this.lastLine - this.firstLine + 1;
    }

    public int getFirstLine() {
        this.ensureNotEmpty();
        return this.firstLine;
    }

    public int getLastLine() {
        this.ensureNotEmpty();
        return this.lastLine;
    }

    private void ensureNotEmpty() {
        if (this.empty()) {
            throw new NoSuchElementException("Attempt to grab a line from an empty interval in: " + this.className.asJavaName() + " at " + this.method.getName() + " with " + this.method.getDescriptor());
        }
    }
}

