/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.tmq;

import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.tmq.Deserializer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;

public class ReferenceDeserializer<V>
implements Deserializer<V> {
    private Param[] params;

    @Override
    public void configure(Map<?, ?> configs) {
        Object encodingValue = configs.get("value.deserializer.encoding");
        if (encodingValue instanceof String) {
            TaosGlobalConfig.setCharset(((String)encodingValue).trim());
        }
    }

    @Override
    public V deserialize(ResultSet data) throws InstantiationException, IllegalAccessException, IntrospectionException, SQLException, InvocationTargetException {
        Class<V> clazz = this.getGenericType();
        V t = clazz.newInstance();
        if (this.params == null) {
            ArrayList<Param> lists = new ArrayList<Param>();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
                String name = property.getName();
                if ("class".equals(name)) continue;
                Method method = property.getWriteMethod();
                Param param = new Param();
                param.name = name;
                param.method = method;
                param.clazz = method.getParameterTypes()[0];
                lists.add(param);
            }
            this.params = lists.toArray(new Param[0]);
        }
        for (Param param : this.params) {
            if (param.clazz.isAssignableFrom(String.class)) {
                param.method.invoke(t, data.getString(param.name));
                continue;
            }
            if (param.clazz.isAssignableFrom(Integer.class) || param.clazz.isAssignableFrom(Integer.TYPE)) {
                param.method.invoke(t, data.getInt(param.name));
                continue;
            }
            if (param.clazz.isAssignableFrom(Short.class) || param.clazz.isAssignableFrom(Short.TYPE)) {
                param.method.invoke(t, data.getShort(param.name));
                continue;
            }
            if (param.clazz.isAssignableFrom(Byte.class) || param.clazz.isAssignableFrom(Byte.TYPE)) {
                param.method.invoke(t, data.getByte(param.name));
                continue;
            }
            if (param.clazz.isAssignableFrom(Character.class) || param.clazz.isAssignableFrom(Character.TYPE)) {
                param.method.invoke(t, Character.valueOf((char)data.getByte(param.name)));
                continue;
            }
            if (param.clazz.isAssignableFrom(Float.class) || param.clazz.isAssignableFrom(Float.TYPE)) {
                param.method.invoke(t, Float.valueOf(data.getFloat(param.name)));
                continue;
            }
            if (param.clazz.isAssignableFrom(Double.class) || param.clazz.isAssignableFrom(Double.TYPE)) {
                param.method.invoke(t, data.getDouble(param.name));
                continue;
            }
            if (param.clazz.isAssignableFrom(Long.class) || param.clazz.isAssignableFrom(Long.TYPE)) {
                param.method.invoke(t, data.getLong(param.name));
                continue;
            }
            if (param.clazz.isAssignableFrom(Boolean.class) || param.clazz.isAssignableFrom(Boolean.TYPE)) {
                param.method.invoke(t, data.getBoolean(param.name));
                continue;
            }
            if (param.clazz.isAssignableFrom(Timestamp.class)) {
                param.method.invoke(t, data.getTimestamp(param.name));
                continue;
            }
            if (!param.clazz.isAssignableFrom(Byte[].class) && !param.clazz.isAssignableFrom(byte[].class)) continue;
            param.method.invoke(t, new Object[]{data.getBytes(param.name)});
        }
        return t;
    }

    private Class<V> getGenericType() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        throw new RuntimeException();
    }

    private static class Param {
        String name;
        Method method;
        Class<?> clazz;

        private Param() {
        }
    }
}

