/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.AbstractStatement;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.utils.HttpClientPoolUtil;
import com.taosdata.jdbc.utils.SqlSyntaxValidator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RestfulStatement
extends AbstractStatement {
    private boolean closed;
    private String database;
    private final RestfulConnection conn;
    private static final String ROW_NAME = "affected_rows";
    private volatile RestfulResultSet resultSet;

    public RestfulStatement(RestfulConnection conn, String database) {
        this.conn = conn;
        this.database = database;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql);
        return this.affectedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Class<RestfulStatement> clazz = RestfulStatement.class;
        synchronized (RestfulStatement.class) {
            if (!this.isClosed()) {
                this.closed = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        boolean result = true;
        String response = HttpClientPoolUtil.execute(this.getUrl(), sql, this.conn.getAuth());
        JSONObject jsonObject = null;
        try {
            jsonObject = JSON.parseObject((String)response);
        }
        catch (JSONException e) {
            throw new JSONException(String.format("execute sql: %s, response: %s, can not cast to JSONObject.", sql, response), (Throwable)e);
        }
        if (null == jsonObject) {
            throw TSDBError.createSQLException(9040, "sql: " + sql);
        }
        if (jsonObject.getIntValue("code") != 0) {
            throw TSDBError.createSQLException(jsonObject.getInteger("code"), "sql: " + sql + ", desc: " + jsonObject.getString("desc"));
        }
        if (SqlSyntaxValidator.isUseSql(sql)) {
            this.database = sql.trim().replace("use", "").trim();
            this.conn.setCatalog(this.database);
            this.conn.setClientInfo("dbname", this.database);
            result = false;
        } else {
            JSONArray head = jsonObject.getJSONArray("column_meta");
            if (null == head) {
                throw TSDBError.createSQLException(jsonObject.getInteger("code"), "sql: " + sql + ", desc: " + jsonObject.getString("desc") + ", head meta is null.");
            }
            Integer rows = jsonObject.getInteger("rows");
            if (head.size() == 1 && ROW_NAME.equals(head.getJSONArray(0).getString(0)) && rows == 1) {
                this.resultSet = null;
                this.affectedRows = this.getAffectedRows(jsonObject);
                return false;
            }
            this.resultSet = new RestfulResultSet(this.database, this, jsonObject);
            this.affectedRows = -1;
        }
        return result;
    }

    private String getUrl() throws SQLException {
        String url;
        String dbname = this.conn.getClientInfo("dbname");
        String protocol = "http";
        if (this.conn.isUseSsl()) {
            protocol = "https";
        }
        dbname = dbname == null || dbname.trim().isEmpty() ? "" : "/" + dbname.toLowerCase();
        if (this.conn.getToken() != null && !"".equals(this.conn.getToken().trim())) {
            String port = null != this.conn.getPort() ? ":" + this.conn.getPort() : "";
            String tz = null == this.conn.getTz() || "".equals(this.conn.getTz().trim()) ? "" : "&tz=" + this.conn.getTz().trim();
            url = protocol + "://" + this.conn.getHost() + port + "/rest/sql" + dbname + "?token=" + this.conn.getToken() + tz;
        } else {
            String tz = null == this.conn.getTz() || "".equals(this.conn.getTz().trim()) ? "" : "?tz=" + this.conn.getTz().trim();
            String port = null != this.conn.getPort() ? ":" + this.conn.getPort() : "6041";
            url = protocol + "://" + this.conn.getHost() + port + "/rest/sql" + dbname + tz;
        }
        return url;
    }

    private int getAffectedRows(JSONObject jsonObject) throws SQLException {
        JSONArray head = jsonObject.getJSONArray("column_meta");
        if (head.size() != 1 || !ROW_NAME.equals(head.getJSONArray(0).getString(0))) {
            throw TSDBError.createSQLException(8963, "invalid variable: [" + head.toJSONString() + "]");
        }
        JSONArray data = jsonObject.getJSONArray("data");
        if (data != null) {
            return data.getJSONArray(0).getInteger(0);
        }
        throw TSDBError.createSQLException(8963, "invalid variable: [" + jsonObject.toJSONString() + "]");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.affectedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.conn;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

