/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.transport.netty;

import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerBuilder;
import com.netflix.ribbon.transport.netty.DynamicPropertyBasedPoolStrategy;
import com.netflix.ribbon.transport.netty.LoadBalancingRxClient;
import io.reactivex.netty.client.CompositePoolLimitDeterminationStrategy;
import io.reactivex.netty.client.MaxConnectionsBasedStrategy;
import io.reactivex.netty.client.PoolLimitDeterminationStrategy;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import java.util.concurrent.ScheduledExecutorService;

public abstract class LoadBalancingRxClientWithPoolOptions<I, O, T extends RxClient<I, O>>
extends LoadBalancingRxClient<I, O, T> {
    protected CompositePoolLimitDeterminationStrategy poolStrategy;
    protected MaxConnectionsBasedStrategy globalStrategy;
    protected int idleConnectionEvictionMills;
    protected ScheduledExecutorService poolCleanerScheduler;
    protected boolean poolEnabled = true;

    public LoadBalancingRxClientWithPoolOptions(IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<O, I> pipelineConfigurator, ScheduledExecutorService poolCleanerScheduler) {
        this((ILoadBalancer)LoadBalancerBuilder.newBuilder().withClientConfig(config).buildDynamicServerListLoadBalancer(), config, retryHandler, pipelineConfigurator, poolCleanerScheduler);
    }

    public LoadBalancingRxClientWithPoolOptions(ILoadBalancer lb, IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<O, I> pipelineConfigurator, ScheduledExecutorService poolCleanerScheduler) {
        super(lb, config, retryHandler, pipelineConfigurator);
        this.poolEnabled = (Boolean)config.get(CommonClientConfigKey.EnableConnectionPool, (Object)DefaultClientConfigImpl.DEFAULT_ENABLE_CONNECTION_POOL);
        if (this.poolEnabled) {
            this.poolCleanerScheduler = poolCleanerScheduler;
            int maxTotalConnections = (Integer)config.get(IClientConfigKey.Keys.MaxTotalConnections, (Object)DefaultClientConfigImpl.DEFAULT_MAX_TOTAL_CONNECTIONS);
            int maxConnections = (Integer)config.get(IClientConfigKey.Keys.MaxConnectionsPerHost, (Object)DefaultClientConfigImpl.DEFAULT_MAX_CONNECTIONS_PER_HOST);
            DynamicPropertyBasedPoolStrategy perHostStrategy = new DynamicPropertyBasedPoolStrategy(maxConnections, config.getClientName() + "." + config.getNameSpace() + "." + CommonClientConfigKey.MaxConnectionsPerHost);
            this.globalStrategy = new DynamicPropertyBasedPoolStrategy(maxTotalConnections, config.getClientName() + "." + config.getNameSpace() + "." + CommonClientConfigKey.MaxTotalConnections);
            this.poolStrategy = new CompositePoolLimitDeterminationStrategy(new PoolLimitDeterminationStrategy[]{perHostStrategy, this.globalStrategy});
            this.idleConnectionEvictionMills = (Integer)config.get(IClientConfigKey.Keys.ConnIdleEvictTimeMilliSeconds, (Object)DefaultClientConfigImpl.DEFAULT_CONNECTIONIDLE_TIME_IN_MSECS);
        }
    }

    protected final PoolLimitDeterminationStrategy getPoolStrategy() {
        return this.globalStrategy;
    }

    protected int getConnectionIdleTimeoutMillis() {
        return this.idleConnectionEvictionMills;
    }

    protected boolean isPoolEnabled() {
        return this.poolEnabled;
    }

    @Override
    public int getMaxConcurrentRequests() {
        if (this.poolEnabled) {
            return this.globalStrategy.getMaxConnections();
        }
        return super.getMaxConcurrentRequests();
    }
}

