/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.event.config;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.context.event.DeferredApplicationEventPublisher;
import com.alibaba.nacos.spring.context.event.config.DelegatingEventPublishingListener;
import com.alibaba.nacos.spring.context.event.config.NacosConfigEvent;
import com.alibaba.nacos.spring.context.event.config.NacosConfigListenerRegisteredEvent;
import com.alibaba.nacos.spring.context.event.config.NacosConfigPublishedEvent;
import com.alibaba.nacos.spring.context.event.config.NacosConfigRemovedEvent;
import com.alibaba.nacos.spring.context.event.config.NacosConfigTimeoutEvent;
import com.alibaba.nacos.spring.metadata.NacosServiceMetaData;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;

public class EventPublishingConfigService
implements ConfigService,
NacosServiceMetaData {
    private final ConfigService configService;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Executor executor;
    private final Properties properties;

    public EventPublishingConfigService(ConfigService configService, Properties properties, ConfigurableApplicationContext context, Executor executor) {
        this.configService = configService;
        this.properties = properties;
        this.applicationEventPublisher = new DeferredApplicationEventPublisher(context);
        this.executor = executor;
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws NacosException {
        try {
            return this.configService.getConfig(dataId, group, timeoutMs);
        }
        catch (NacosException e) {
            if (500 == e.getErrCode()) {
                this.publishEvent(new NacosConfigTimeoutEvent(this.configService, dataId, group, timeoutMs, e.getErrMsg()));
            }
            throw e;
        }
    }

    public void addListener(String dataId, String group, Listener listener) throws NacosException {
        DelegatingEventPublishingListener listenerAdapter = new DelegatingEventPublishingListener(this.configService, dataId, group, this.applicationEventPublisher, this.executor, listener);
        this.configService.addListener(dataId, group, (Listener)listenerAdapter);
        this.publishEvent(new NacosConfigListenerRegisteredEvent(this.configService, dataId, group, listener, true));
    }

    public boolean publishConfig(String dataId, String group, String content) throws NacosException {
        boolean published = this.configService.publishConfig(dataId, group, content);
        this.publishEvent(new NacosConfigPublishedEvent(this.configService, dataId, group, content, published));
        return published;
    }

    public boolean removeConfig(String dataId, String group) throws NacosException {
        boolean removed = this.configService.removeConfig(dataId, group);
        this.publishEvent(new NacosConfigRemovedEvent(this.configService, dataId, group, removed));
        return removed;
    }

    public void removeListener(String dataId, String group, Listener listener) {
        this.configService.removeListener(dataId, group, listener);
        this.publishEvent(new NacosConfigListenerRegisteredEvent(this.configService, dataId, group, listener, false));
    }

    public String getServerStatus() {
        return this.configService.getServerStatus();
    }

    private void publishEvent(NacosConfigEvent nacosConfigEvent) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)nacosConfigEvent);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }
}

