/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor.attr;

import java.util.Collections;
import java.util.Map;
import org.springframework.web.servlet.support.BindStatus;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.AttributeNameProcessorMatcher;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.spring4.util.FieldUtils;
import org.thymeleaf.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpringFieldAttrProcessor
extends AbstractAttrProcessor {
    public static final int ATTR_PRECEDENCE = 1200;
    public static final String ATTR_NAME = "field";
    protected static final String INPUT_TAG_NAME = "input";
    protected static final String SELECT_TAG_NAME = "select";
    protected static final String OPTION_TAG_NAME = "option";
    protected static final String TEXTAREA_TAG_NAME = "textarea";
    protected static final String INPUT_TYPE_ATTR_NAME = "type";

    protected AbstractSpringFieldAttrProcessor(String attributeName, String hostTagName) {
        this(attributeName, hostTagName, null);
    }

    protected AbstractSpringFieldAttrProcessor(String attributeName, String hostTagName, String hostFilterAttributeName, String hostFilterAttributeValue) {
        super((IAttributeNameProcessorMatcher)new AttributeNameProcessorMatcher(attributeName, hostTagName, hostFilterAttributeName, hostFilterAttributeValue));
    }

    protected AbstractSpringFieldAttrProcessor(String attributeName, String hostTagName, Map<String, String> hostTagAttributes) {
        super((IAttributeNameProcessorMatcher)new AttributeNameProcessorMatcher(attributeName, hostTagName, hostTagAttributes));
    }

    public int getPrecedence() {
        return 1200;
    }

    public final ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        BindStatus bindStatus = FieldUtils.getBindStatus(arguments.getConfiguration(), (IProcessingContext)arguments, attributeValue);
        Map<String, BindStatus> localVariables = Collections.singletonMap("springFieldBindStatus", bindStatus);
        return this.doProcess(arguments, element, attributeName, attributeValue, bindStatus, localVariables);
    }

    protected abstract ProcessorResult doProcess(Arguments var1, Element var2, String var3, String var4, BindStatus var5, Map<String, Object> var6);

    protected String computeId(Arguments arguments, Element element, String name, boolean sequence) {
        String id = element.getAttributeValue("id");
        if (!StringUtils.isEmptyOrWhitespace((String)id)) {
            return org.springframework.util.StringUtils.hasText((String)id) ? id : null;
        }
        id = FieldUtils.idFromName(name);
        if (sequence) {
            Integer count = arguments.getAndIncrementIDSeq(id);
            return id + count.toString();
        }
        return id;
    }
}

