/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.ScriptedField;
import org.springframework.data.elasticsearch.core.AbstractResultMapper;
import org.springframework.data.elasticsearch.core.DefaultEntityMapper;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.aggregation.impl.AggregatedPageImpl;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultResultMapper
extends AbstractResultMapper {
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    private final ConversionService conversionService = new DefaultConversionService();

    public DefaultResultMapper() {
        this((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext());
    }

    public DefaultResultMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this(mappingContext, DefaultResultMapper.initEntityMapper(mappingContext));
    }

    public DefaultResultMapper(EntityMapper entityMapper) {
        this((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext(), entityMapper);
    }

    public DefaultResultMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, @Nullable EntityMapper entityMapper) {
        super(entityMapper != null ? entityMapper : DefaultResultMapper.initEntityMapper(mappingContext));
        this.mappingContext = mappingContext;
    }

    private static EntityMapper initEntityMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        return new DefaultEntityMapper(mappingContext);
    }

    @Override
    public <T> AggregatedPage<T> mapResults(SearchResponse response, Class<T> clazz, Pageable pageable) {
        long totalHits = response.getHits().getTotalHits();
        float maxScore = response.getHits().getMaxScore();
        ArrayList<Object> results = new ArrayList<Object>();
        for (SearchHit hit : response.getHits()) {
            if (hit == null) continue;
            Object result = null;
            String hitSourceAsString = hit.getSourceAsString();
            result = !StringUtils.isEmpty((Object)hitSourceAsString) ? (Object)this.mapEntity(hitSourceAsString, clazz) : (Object)this.mapEntity(hit.getFields().values(), clazz);
            this.setPersistentEntityId(result, hit.getId(), clazz);
            this.setPersistentEntityVersion(result, hit.getVersion(), clazz);
            this.setPersistentEntityScore(result, hit.getScore(), clazz);
            this.populateScriptFields(result, hit);
            results.add(result);
        }
        return new AggregatedPageImpl(results, pageable, totalHits, response.getAggregations(), response.getScrollId(), maxScore);
    }

    private <T> void populateScriptFields(T result, SearchHit hit) {
        if (hit.getFields() != null && !hit.getFields().isEmpty() && result != null) {
            for (Field field : result.getClass().getDeclaredFields()) {
                ScriptedField scriptedField = field.getAnnotation(ScriptedField.class);
                if (scriptedField == null) continue;
                String name = scriptedField.name().isEmpty() ? field.getName() : scriptedField.name();
                DocumentField searchHitField = (DocumentField)hit.getFields().get(name);
                if (searchHitField == null) continue;
                field.setAccessible(true);
                try {
                    field.set(result, searchHitField.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new ElasticsearchException("failed to set scripted field: " + name + " with value: " + searchHitField.getValue(), e);
                }
                catch (IllegalAccessException e) {
                    throw new ElasticsearchException("failed to access scripted field: " + name, e);
                }
            }
        }
    }

    private <T> T mapEntity(Collection<DocumentField> values, Class<T> clazz) {
        return this.mapEntity(this.buildJSONFromFields(values), clazz);
    }

    private String buildJSONFromFields(Collection<DocumentField> values) {
        JsonFactory nodeFactory = new JsonFactory();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            JsonGenerator generator = nodeFactory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
            generator.writeStartObject();
            for (DocumentField value : values) {
                if (value.getValues().size() > 1) {
                    generator.writeArrayFieldStart(value.getName());
                    for (Object val : value.getValues()) {
                        generator.writeObject(val);
                    }
                    generator.writeEndArray();
                    continue;
                }
                generator.writeObjectField(value.getName(), value.getValue());
            }
            generator.writeEndObject();
            generator.flush();
            return new String(stream.toByteArray(), Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public <T> T mapResult(GetResponse response, Class<T> clazz) {
        T result = this.mapEntity(response.getSourceAsString(), clazz);
        if (result != null) {
            this.setPersistentEntityId(result, response.getId(), clazz);
            this.setPersistentEntityVersion(result, response.getVersion(), clazz);
        }
        return result;
    }

    @Override
    public <T> List<T> mapResults(MultiGetResponse responses, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        for (MultiGetItemResponse response : responses.getResponses()) {
            if (response.isFailed() || !response.getResponse().isExists()) continue;
            T result = this.mapEntity(response.getResponse().getSourceAsString(), clazz);
            this.setPersistentEntityId(result, response.getResponse().getId(), clazz);
            this.setPersistentEntityVersion(result, response.getResponse().getVersion(), clazz);
            list.add(result);
        }
        return list;
    }

    private <T> void setPersistentEntityId(T result, String id, Class<T> clazz) {
        if (clazz.isAnnotationPresent(Document.class)) {
            ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz);
            ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
            ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(persistentEntity.getPropertyAccessor(result), this.conversionService);
            if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
                accessor.setProperty((PersistentProperty)idProperty, (Object)id);
            }
        }
    }

    private <T> void setPersistentEntityVersion(T result, long version, Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity;
        ElasticsearchPersistentProperty versionProperty;
        if (clazz.isAnnotationPresent(Document.class) && (versionProperty = (persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(clazz)).getVersionProperty()) != null && versionProperty.getType().isAssignableFrom(Long.class)) {
            Assert.isTrue((version != -1L ? 1 : 0) != 0, (String)"Version in response is -1");
            persistentEntity.getPropertyAccessor(result).setProperty((PersistentProperty)versionProperty, (Object)version);
        }
    }

    private <T> void setPersistentEntityScore(T result, float score, Class<T> clazz) {
        if (clazz.isAnnotationPresent(Document.class)) {
            ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz);
            if (!entity.hasScoreProperty()) {
                return;
            }
            entity.getPropertyAccessor(result).setProperty((PersistentProperty)entity.getScoreProperty(), (Object)Float.valueOf(score));
        }
    }
}

