/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.util.Assert;

public class ImagePlatform {
    private final String os;
    private final @Nullable String architecture;
    private final @Nullable String variant;

    ImagePlatform(String os, @Nullable String architecture, @Nullable String variant) {
        Assert.hasText((String)os, (String)"'os' must not be empty");
        this.os = os;
        this.architecture = architecture;
        this.variant = variant;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImagePlatform other = (ImagePlatform)obj;
        return Objects.equals(this.architecture, other.architecture) && Objects.equals(this.os, other.os) && Objects.equals(this.variant, other.variant);
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.os, this.variant);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.os);
        if (this.architecture != null) {
            builder.append("/").append(this.architecture);
        }
        if (this.variant != null) {
            builder.append("/").append(this.variant);
        }
        return builder.toString();
    }

    public static ImagePlatform of(String value) {
        Assert.hasText((String)value, (String)"'value' must not be empty");
        String[] split = value.split("/+");
        return switch (split.length) {
            case 1 -> new ImagePlatform(split[0], null, null);
            case 2 -> new ImagePlatform(split[0], split[1], null);
            case 3 -> new ImagePlatform(split[0], split[1], split[2]);
            default -> throw new IllegalArgumentException("'value' [" + value + "] must be in the form 'os[/architecture[/variant]]'");
        };
    }

    public static ImagePlatform from(Image image) {
        return new ImagePlatform(image.getOs(), image.getArchitecture(), image.getVariant());
    }
}

