/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageConfig;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class BuilderMetadata
extends MappedObject {
    private static final String LABEL_NAME = "io.buildpacks.builder.metadata";
    private static final String[] EMPTY_MIRRORS = new String[0];
    private final Stack stack = this.valueAt("/stack", Stack.class);
    private final Lifecycle lifecycle = this.valueAt("/lifecycle", Lifecycle.class);
    private final CreatedBy createdBy = this.valueAt("/createdBy", CreatedBy.class);

    BuilderMetadata(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    Stack getStack() {
        return this.stack;
    }

    Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    BuilderMetadata copy(Consumer<Update> update) {
        return new Update(this).run(update);
    }

    void attachTo(ImageConfig.Update update) {
        try {
            String json = SharedObjectMapper.get().writeValueAsString((Object)this.getNode());
            update.withLabel(LABEL_NAME, json);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static BuilderMetadata fromImage(Image image) throws IOException {
        Assert.notNull((Object)image, (String)"Image must not be null");
        return BuilderMetadata.fromImageConfig(image.getConfig());
    }

    static BuilderMetadata fromImageConfig(ImageConfig imageConfig) throws IOException {
        Assert.notNull((Object)imageConfig, (String)"ImageConfig must not be null");
        String json = imageConfig.getLabels().get(LABEL_NAME);
        Assert.notNull((Object)json, () -> "No 'io.buildpacks.builder.metadata' label found in image config labels '" + StringUtils.collectionToCommaDelimitedString(imageConfig.getLabels().keySet()) + "'");
        return BuilderMetadata.fromJson(json);
    }

    static BuilderMetadata fromJson(String json) throws IOException {
        return new BuilderMetadata(SharedObjectMapper.get().readTree(json));
    }

    static final class Update {
        private final ObjectNode copy;

        private Update(BuilderMetadata source) {
            this.copy = (ObjectNode)source.getNode().deepCopy();
        }

        private BuilderMetadata run(Consumer<Update> update) {
            update.accept(this);
            return new BuilderMetadata((JsonNode)this.copy);
        }

        void withCreatedBy(String name, String version) {
            ObjectNode createdBy = (ObjectNode)this.copy.at("/createdBy");
            if (createdBy == null) {
                createdBy = this.copy.putObject("createdBy");
            }
            createdBy.put("name", name);
            createdBy.put("version", version);
        }
    }

    static interface CreatedBy {
        public String getName();

        public String getVersion();
    }

    static interface Lifecycle {
        public String getVersion();

        public Api getApi();

        public Apis getApis();

        public static interface Apis {
            default public String[] getBuildpack() {
                return (String[])BuilderMetadata.valueAt(this, "/buildpack/supported", String[].class);
            }

            default public String[] getPlatform() {
                return (String[])BuilderMetadata.valueAt(this, "/platform/supported", String[].class);
            }
        }

        public static interface Api {
            public String getBuildpack();

            public String getPlatform();
        }
    }

    static interface Stack {
        public RunImage getRunImage();

        public static interface RunImage {
            public String getImage();

            default public String[] getMirrors() {
                return EMPTY_MIRRORS;
            }
        }
    }
}

