/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.availability;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.availability.AvailabilityProbesHealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.util.Assert;

class AvailabilityProbesHealthEndpointGroups
implements HealthEndpointGroups {
    private static final Map<String, AvailabilityProbesHealthEndpointGroup> GROUPS;
    private final HealthEndpointGroups groups;
    private final Set<String> names;

    AvailabilityProbesHealthEndpointGroups(HealthEndpointGroups groups) {
        Assert.notNull((Object)groups, (String)"Groups must not be null");
        this.groups = groups;
        LinkedHashSet<String> names = new LinkedHashSet<String>(groups.getNames());
        names.addAll(GROUPS.keySet());
        this.names = Collections.unmodifiableSet(names);
    }

    public HealthEndpointGroup getPrimary() {
        return this.groups.getPrimary();
    }

    public Set<String> getNames() {
        return this.names;
    }

    public HealthEndpointGroup get(String name) {
        HealthEndpointGroup group = this.groups.get(name);
        if (group == null) {
            group = GROUPS.get(name);
        }
        return group;
    }

    static boolean containsAllProbeGroups(HealthEndpointGroups groups) {
        return groups.getNames().containsAll(GROUPS.keySet());
    }

    static {
        LinkedHashMap<String, AvailabilityProbesHealthEndpointGroup> groups = new LinkedHashMap<String, AvailabilityProbesHealthEndpointGroup>();
        groups.put("liveness", new AvailabilityProbesHealthEndpointGroup("livenessState"));
        groups.put("readiness", new AvailabilityProbesHealthEndpointGroup("readinessState"));
        GROUPS = Collections.unmodifiableMap(groups);
    }
}

