/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.availability;

import org.springframework.boot.actuate.autoconfigure.availability.AvailabilityHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.availability.AvailabilityProbesHealthEndpointGroupsPostProcessor;
import org.springframework.boot.actuate.availability.LivenessStateHealthIndicator;
import org.springframework.boot.actuate.availability.ReadinessStateHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.availability.ApplicationAvailabilityAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ProbesCondition.class})
@AutoConfigureAfter(value={AvailabilityHealthContributorAutoConfiguration.class, ApplicationAvailabilityAutoConfiguration.class})
public class AvailabilityProbesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LivenessStateHealthIndicator livenessStateProbeIndicator(ApplicationAvailability applicationAvailability) {
        return new LivenessStateHealthIndicator(applicationAvailability);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReadinessStateHealthIndicator readinessStateProbeIndicator(ApplicationAvailability applicationAvailability) {
        return new ReadinessStateHealthIndicator(applicationAvailability);
    }

    @Bean
    public AvailabilityProbesHealthEndpointGroupsPostProcessor availabilityProbesHealthEndpointGroupsPostProcessor() {
        return new AvailabilityProbesHealthEndpointGroupsPostProcessor();
    }

    static class ProbesCondition
    extends SpringBootCondition {
        private static final String ENABLED_PROPERTY = "management.endpoint.health.probes.enabled";
        private static final String DEPRECATED_ENABLED_PROPERTY = "management.health.probes.enabled";

        ProbesCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message;
            Environment environment = context.getEnvironment();
            ConditionOutcome outcome = this.onProperty(environment, message = ConditionMessage.forCondition((String)"Probes availability", (Object[])new Object[0]), ENABLED_PROPERTY);
            if (outcome != null) {
                return outcome;
            }
            outcome = this.onProperty(environment, message, DEPRECATED_ENABLED_PROPERTY);
            if (outcome != null) {
                return outcome;
            }
            if (CloudPlatform.getActive((Environment)environment) == CloudPlatform.KUBERNETES) {
                return ConditionOutcome.match((ConditionMessage)message.because("running on Kubernetes"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not running on a supported cloud platform"));
        }

        private ConditionOutcome onProperty(Environment environment, ConditionMessage.Builder message, String propertyName) {
            String enabled = environment.getProperty(propertyName);
            if (enabled != null) {
                boolean match = !"false".equalsIgnoreCase(enabled);
                return new ConditionOutcome(match, message.because("'" + propertyName + "' set to '" + enabled + "'"));
            }
            return null;
        }
    }
}

