/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.gem;

import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class ValueMappingGem
implements Gem {
    private final GemValue<String> source;
    private final GemValue<String> target;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private ValueMappingGem(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.isValid = this.source != null && this.source.isValid() && this.target != null && this.target.isValid();
        this.mirror = builder.mirror;
    }

    public GemValue<String> source() {
        return this.source;
    }

    public GemValue<String> target() {
        return this.target;
    }

    @Override
    public AnnotationMirror mirror() {
        return this.mirror;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static ValueMappingGem instanceOn(Element element) {
        return ValueMappingGem.build(element, new BuilderImpl());
    }

    public static ValueMappingGem instanceOn(AnnotationMirror mirror) {
        return ValueMappingGem.build(mirror, new BuilderImpl());
    }

    public static <T> T build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream().filter(a -> "org.mapstruct.ValueMapping".contentEquals(((TypeElement)a.getAnnotationType().asElement()).getQualifiedName())).findAny().orElse(null);
        return ValueMappingGem.build(mirror, builder);
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder) {
        if (mirror == null || builder == null) {
            return null;
        }
        List<ExecutableElement> enclosed = ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements());
        HashMap defaultValues = new HashMap(enclosed.size());
        enclosed.forEach(e -> defaultValues.put(e.getSimpleName().toString(), e.getDefaultValue()));
        HashMap values = new HashMap(enclosed.size());
        mirror.getElementValues().entrySet().forEach(e -> {
            AnnotationValue cfr_ignored_0 = (AnnotationValue)values.put(((ExecutableElement)e.getKey()).getSimpleName().toString(), e.getValue());
        });
        for (String methodName : defaultValues.keySet()) {
            if ("source".equals(methodName)) {
                builder.setSource(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
                continue;
            }
            if (!"target".equals(methodName)) continue;
            builder.setTarget(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
        }
        builder.setMirror(mirror);
        return builder.build();
    }

    private static class BuilderImpl
    implements Builder<ValueMappingGem> {
        private GemValue<String> source;
        private GemValue<String> target;
        private AnnotationMirror mirror;

        private BuilderImpl() {
        }

        @Override
        public Builder setSource(GemValue<String> source) {
            this.source = source;
            return this;
        }

        @Override
        public Builder setTarget(GemValue<String> target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder setMirror(AnnotationMirror mirror) {
            this.mirror = mirror;
            return this;
        }

        @Override
        public ValueMappingGem build() {
            return new ValueMappingGem(this);
        }
    }

    public static interface Builder<T> {
        public Builder setSource(GemValue<String> var1);

        public Builder setTarget(GemValue<String> var1);

        public Builder setMirror(AnnotationMirror var1);

        public T build();
    }
}

