/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.extensions;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisHandlerExtension;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J*\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001e0 H\u0002J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020!2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001e0 H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/extensions/PartialAnalysisHandlerExtension;", "Lorg/jetbrains/kotlin/resolve/jvm/extensions/AnalysisHandlerExtension;", "()V", "analyzeDefaultParameterValues", "", "getAnalyzeDefaultParameterValues", "()Z", "analyzePartially", "getAnalyzePartially", "containingScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getContainingScope", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "doAnalysis", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "doForEachDeclaration", "", "f", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "frontend.java"})
public class PartialAnalysisHandlerExtension
implements AnalysisHandlerExtension {
    public boolean getAnalyzePartially() {
        return true;
    }

    public boolean getAnalyzeDefaultParameterValues() {
        return false;
    }

    @Override
    @Nullable
    public AnalysisResult doAnalysis(@NotNull Project project, @NotNull ModuleDescriptor module2, @NotNull ProjectContext projectContext, @NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace bindingTrace, @NotNull ComponentProvider componentProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)projectContext, (String)"projectContext");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter((Object)componentProvider, (String)"componentProvider");
        if (!this.getAnalyzePartially()) {
            return null;
        }
        ComponentProvider $this$get$iv = componentProvider;
        boolean $i$f$get = false;
        ResolveSession resolveSession = DslKt.getService($this$get$iv, ResolveSession.class);
        ComponentProvider $this$get$iv2 = componentProvider;
        boolean $i$f$get2 = false;
        BodyResolver bodyResolver = DslKt.getService($this$get$iv2, BodyResolver.class);
        ComponentProvider $this$get$iv3 = componentProvider;
        boolean $i$f$get3 = false;
        DeclarationScopeProvider declarationScopeProvider = DslKt.getService($this$get$iv3, DeclarationScopeProvider.class);
        ComponentProvider $this$get$iv4 = componentProvider;
        boolean $i$f$get4 = false;
        LazyTopDownAnalyzer topDownAnalyzer = DslKt.getService($this$get$iv4, LazyTopDownAnalyzer.class);
        TopDownAnalysisContext topDownAnalysisContext = new TopDownAnalysisContext(TopDownAnalysisMode.TopLevelDeclarations, DataFlowInfo.Companion.getEMPTY(), declarationScopeProvider);
        for (KtFile ktFile : files2) {
            ForceResolveUtil.forceResolveAllContents(resolveSession.getFileAnnotations(ktFile));
            topDownAnalyzer.resolveImportsInFile(ktFile);
        }
        this.doForEachDeclaration(files2, (Function1<? super KtDeclaration, Unit>)((Function1)new Function1<KtDeclaration, Unit>(resolveSession, bodyResolver, topDownAnalysisContext, this, bindingTrace){
            final /* synthetic */ ResolveSession $resolveSession;
            final /* synthetic */ BodyResolver $bodyResolver;
            final /* synthetic */ TopDownAnalysisContext $topDownAnalysisContext;
            final /* synthetic */ PartialAnalysisHandlerExtension this$0;
            final /* synthetic */ BindingTrace $bindingTrace;
            {
                this.$resolveSession = $resolveSession;
                this.$bodyResolver = $bodyResolver;
                this.$topDownAnalysisContext = $topDownAnalysisContext;
                this.this$0 = $receiver;
                this.$bindingTrace = $bindingTrace;
                super(1);
            }

            public final void invoke(@NotNull KtDeclaration declaration2) {
                DeclarationDescriptor descriptor2;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                DeclarationDescriptor declarationDescriptor = this.$resolveSession.resolveToDescriptor(declaration2);
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"resolveSession.resolveToDescriptor(declaration)");
                declarationDescriptor = descriptor2 = declarationDescriptor;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    ForceResolveUtil.forceResolveAllContents(descriptor2);
                    ForceResolveUtil.forceResolveAllContents(((ClassDescriptor)descriptor2).getTypeConstructor().getSupertypes());
                    if (declaration2 instanceof KtClassOrObject && descriptor2 instanceof ClassDescriptorWithResolutionScopes) {
                        this.$bodyResolver.resolveSuperTypeEntryList(DataFlowInfo.Companion.getEMPTY(), (KtClassOrObject)declaration2, (ClassDescriptor)descriptor2, ((ClassDescriptorWithResolutionScopes)descriptor2).getUnsubstitutedPrimaryConstructor(), ((ClassDescriptorWithResolutionScopes)descriptor2).getScopeForConstructorHeaderResolution(), ((ClassDescriptorWithResolutionScopes)descriptor2).getScopeForMemberDeclarationResolution(), this.$resolveSession.getInferenceSession());
                    }
                } else if (declarationDescriptor instanceof PropertyDescriptor) {
                    if (declaration2 instanceof KtProperty) {
                        this.$bodyResolver.resolveProperty(this.$topDownAnalysisContext, (KtProperty)declaration2, (PropertyDescriptor)descriptor2);
                    }
                } else if (declarationDescriptor instanceof FunctionDescriptor) {
                    if (declaration2 instanceof KtPrimaryConstructor && (this.this$0.getAnalyzeDefaultParameterValues() || DescriptorUtilsKt.isAnnotationConstructor(descriptor2))) {
                        LexicalScope containingScope = PartialAnalysisHandlerExtension.access$getContainingScope(this.this$0, descriptor2);
                        if (containingScope != null) {
                            this.$bodyResolver.resolveConstructorParameterDefaultValues(this.$topDownAnalysisContext.getOuterDataFlowInfo(), this.$bindingTrace, (KtPrimaryConstructor)declaration2, (ConstructorDescriptor)descriptor2, containingScope, this.$resolveSession.getInferenceSession());
                        }
                    } else if (declaration2 instanceof KtFunction && !((KtFunction)declaration2).hasDeclaredReturnType() && !((KtFunction)declaration2).hasBlockBody()) {
                        ForceResolveUtil.forceResolveAllContents(descriptor2);
                    }
                }
            }
        }));
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingTrace.bindingContext");
        return AnalysisResult.Companion.success(bindingContext, module2, true);
    }

    private final LexicalScope getContainingScope(DeclarationDescriptor $this$containingScope) {
        DeclarationDescriptor declarationDescriptor = $this$containingScope.getContainingDeclaration();
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        DeclarationDescriptor containingDescriptor = declarationDescriptor2;
        declarationDescriptor2 = containingDescriptor;
        return declarationDescriptor2 instanceof ClassDescriptorWithResolutionScopes ? ((ClassDescriptorWithResolutionScopes)containingDescriptor).getScopeForInitializerResolution() : (declarationDescriptor2 instanceof PackageFragmentDescriptor ? (LexicalScope)new LexicalScope.Base(ScopeUtilsKt.memberScopeAsImportingScope$default(((PackageFragmentDescriptor)containingDescriptor).getMemberScope(), null, 1, null), $this$containingScope) : null);
    }

    private final void doForEachDeclaration(KtDeclaration declaration2, Function1<? super KtDeclaration, Unit> f) {
        if (!(declaration2 instanceof KtAnonymousInitializer)) {
            f.invoke((Object)declaration2);
        }
        if (declaration2 instanceof KtClassOrObject) {
            KtPrimaryConstructor primaryConstructor2 = ((KtClassOrObject)declaration2).getPrimaryConstructor();
            if (primaryConstructor2 != null) {
                f.invoke((Object)primaryConstructor2);
            }
            Iterable $this$forEach$iv = ((KtClassOrObject)declaration2).getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                this.doForEachDeclaration(it, f);
            }
        }
    }

    private final void doForEachDeclaration(Collection<? extends KtFile> files2, Function1<? super KtDeclaration, Unit> f) {
        for (KtFile ktFile : files2) {
            Iterable $this$forEach$iv = ktFile.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                this.doForEachDeclaration(it, f);
            }
        }
    }

    @Override
    @Nullable
    public AnalysisResult analysisCompleted(@NotNull Project project, @NotNull ModuleDescriptor module2, @NotNull BindingTrace bindingTrace, @NotNull Collection<? extends KtFile> files2) {
        return AnalysisHandlerExtension.DefaultImpls.analysisCompleted(this, project, module2, bindingTrace, files2);
    }

    public static final /* synthetic */ LexicalScope access$getContainingScope(PartialAnalysisHandlerExtension $this, DeclarationDescriptor $receiver) {
        return $this.getContainingScope($receiver);
    }
}

