/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.AllUnderImportScope;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LazyExplicitImportScope;
import org.jetbrains.kotlin.resolve.PackageFragmentWithCustomSource;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolverKt;
import org.jetbrains.kotlin.resolve.QualifierPosition;
import org.jetbrains.kotlin.resolve.ResolutionAnchorProviderKt;
import org.jetbrains.kotlin.resolve.calls.CallExpressionElement;
import org.jetbrains.kotlin.resolve.calls.CallExpressionUnrollerKt;
import org.jetbrains.kotlin.resolve.calls.checkers.UnderscoreUsageChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.CompositePrioritizedImportingScope;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TypeAliasQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.TypeParameterQualifier;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.expressions.DoubleColonExpressionResolverKt;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.utils.CallOnceFunction;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 h2\u00020\u0001:\u0005hijklB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002J:\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J8\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010JB\u0010%\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010'\u001a\u00020\u001f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002J.\u0010(\u001a\u00020\b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020,H\u0002J\u001e\u0010-\u001a\u00020.2\u0006\u0010\r\u001a\u00020!2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J&\u00103\u001a\u0002042\u0006\u0010\r\u001a\u0002052\u0006\u0010/\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00106\u001a\u000207J&\u00108\u001a\u0002042\u0006\u00109\u001a\u00020:2\u0006\u0010/\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00106\u001a\u000207J\u0016\u0010;\u001a\u0002072\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\"\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u00101\u001a\u00020@J\u001e\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fJ0\u0010E\u001a\b\u0012\u0004\u0012\u00020F0\u001e2\u0006\u0010\r\u001a\u00020!2\u0006\u00101\u001a\u00020@2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002070HJ8\u0010I\u001a\u0002042\f\u0010J\u001a\b\u0012\u0004\u0012\u00020K0\u001e2\b\u0010L\u001a\u0004\u0018\u00010\n2\u0006\u0010/\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010M\u001a\u000207H\u0002JD\u0010N\u001a\u0004\u0018\u00010\n2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\b\u0010O\u001a\u0004\u0018\u00010\n2\b\u0010P\u001a\u0004\u0018\u0001002\u0006\u0010+\u001a\u00020,H\u0002Jh\u0010Q\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020#0R2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\b\u0010O\u001a\u0004\u0018\u00010\n2\b\u0010P\u001a\u0004\u0018\u0001002\u0006\u0010+\u001a\u00020,2\u0016\b\u0002\u0010G\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u000207\u0018\u00010HH\u0002J\"\u0010S\u001a\u0004\u0018\u00010=2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010T\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002JD\u0010U\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010T\u001a\u0004\u0018\u00010\u000e2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\b\u0010O\u001a\u0004\u0018\u00010\n2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010M\u001a\u000207H\u0002JB\u0010U\u001a\u0004\u0018\u00010=2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010T\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010O\u001a\u0004\u0018\u00010\n2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010M\u001a\u000207H\u0002J(\u0010W\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010X\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u001fH\u0002J\u001c\u0010Y\u001a\b\u0012\u0004\u0012\u00020K0\u001e*\u0002052\b\b\u0002\u0010Z\u001a\u000207H\u0002J\u0012\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e*\u00020[H\u0002J\u001e\u0010Y\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0\u001e\u0012\u0004\u0012\u0002070R*\u00020:H\u0002J\u0010\u0010\\\u001a\u0004\u0018\u00010\n*\u0004\u0018\u00010\nH\u0002J.\u0010]\u001a\u0004\u0018\u00010^*\u0002002\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\b\u0010c\u001a\u0004\u0018\u0001052\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010d\u001a\u0004\u0018\u00010^*\u00020e2\u0006\u0010f\u001a\u00020\u001fJ6\u0010g\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020#0R*\u00020\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020,H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006m"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkNotEnumEntry", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "computePackageFragmentToCheck", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "containingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "packageFragmentForVisibilityCheck", "doProcessImportReference", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportInfo;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "excludedImportNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "mapToQualifierParts", "", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "qualifiedExpressions", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "skipLast", "", "processImportReference", "processSingleImport", "path", "lastPart", "recordPackageViews", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "position", "Lorg/jetbrains/kotlin/resolve/QualifierPosition;", "resolveClassOrPackageInQualifiedExpression", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolveDescriptorForDoubleColonLHS", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isDebuggerContext", "", "resolveDescriptorForType", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "resolveInIDEMode", "resolveNameExpressionAsQualifierForDiagnostics", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolvePackageHeader", "packageDirective", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "module", "resolveQualifierInExpressionAndUnroll", "Lorg/jetbrains/kotlin/resolve/calls/CallExpressionElement;", "isValue", "Lkotlin/Function1;", "resolveQualifierPartListForType", "qualifierPartList", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$ExpressionQualifierPart;", "ownerDescriptor", "isQualifier", "resolveToPackageOrClass", "shouldBeVisibleFrom", "scopeForFirstPart", "resolveToPackageOrClassPrefix", "Lkotlin/Pair;", "storeQualifier", "referenceExpression", "storeResult", "descriptors", "tryResolveDescriptorsWhichCannotBeImported", "packageOrClassDescriptor", "asQualifierPartList", "doubleColonLHS", "Lorg/jetbrains/kotlin/psi/KtImportInfo$ImportContent;", "classDescriptorFromTypeAlias", "findClassifierAndReportDeprecationIfNeeded", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "lookupLocation", "Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "reportOn", "getContributedClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "qualifierPart", "quickResolveToPackage", "Companion", "ExpressionQualifierPart", "QualifiedExpressionResolveResult", "QualifierPart", "TypeQualifierResolutionResult", "frontend"})
public final class QualifiedExpressionResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    public static final String ROOT_PREFIX_FOR_IDE_RESOLUTION_MODE = "_root_ide_package_";
    @NotNull
    public static final String ROOT_PREFIX_FOR_IDE_RESOLUTION_MODE_WITH_DOT = "_root_ide_package_.";

    public QualifiedExpressionResolver(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public final void resolvePackageHeader(@NotNull KtPackageDirective packageDirective, @NotNull ModuleDescriptor module2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)packageDirective, (String)"packageDirective");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Object object = packageDirective.getPackageNames();
        Intrinsics.checkNotNullExpressionValue(object, (String)"packageDirective.packageNames");
        List<KtSimpleNameExpression> packageNames = object;
        object = packageNames.iterator();
        int n = 0;
        while (object.hasNext()) {
            int index2 = n++;
            KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)object.next();
            FqName fqName2 = packageDirective.getFqName(nameExpression);
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"packageDirective.getFqName(nameExpression)");
            this.storeResult(trace, nameExpression, module2.getPackage(fqName2), null, QualifierPosition.PACKAGE_HEADER, index2 != CollectionsKt.getLastIndex(packageNames));
        }
    }

    @Nullable
    public final ClassifierDescriptor findClassifierAndReportDeprecationIfNeeded(@NotNull LexicalScope $this$findClassifierAndReportDeprecationIfNeeded, @NotNull Name name, @NotNull KotlinLookupLocation lookupLocation, @Nullable KtExpression reportOn, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)$this$findClassifierAndReportDeprecationIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        DescriptorWithDeprecation<ClassifierDescriptor> descriptorWithDeprecation = ScopeUtilsKt.findFirstClassifierWithDeprecationStatus($this$findClassifierAndReportDeprecationIfNeeded, name, lookupLocation);
        if (descriptorWithDeprecation == null) {
            return null;
        }
        DescriptorWithDeprecation<ClassifierDescriptor> descriptorWithDeprecation2 = descriptorWithDeprecation;
        ClassifierDescriptor classifier2 = descriptorWithDeprecation2.component1();
        boolean isDeprecated = descriptorWithDeprecation2.component2();
        if (isDeprecated && reportOn != null) {
            trace.record(BindingContext.DEPRECATED_SHORT_NAME_ACCESS, reportOn);
            if (!ScopeUtilsKt.canBeResolvedWithoutDeprecation(classifier2, $this$findClassifierAndReportDeprecationIfNeeded, lookupLocation)) {
                trace.report(Errors.DEPRECATED_ACCESS_BY_SHORT_NAME.on((KtElement)((PsiElement)reportOn), classifier2));
            }
        }
        return classifier2;
    }

    @NotNull
    public final TypeQualifierResolutionResult resolveDescriptorForType(@NotNull KtUserType userType, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        DeclarationDescriptor ownerDescriptor;
        Intrinsics.checkNotNullParameter((Object)userType, (String)"userType");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        DeclarationDescriptor declarationDescriptor = ownerDescriptor = !isDebuggerContext ? scope2.getOwnerDescriptor() : null;
        if (userType.getQualifier() == null) {
            ClassifierDescriptor classifierDescriptor;
            KtSimpleNameExpression ktSimpleNameExpression = userType.getReferenceExpression();
            if (ktSimpleNameExpression == null) {
                classifierDescriptor = null;
            } else {
                KtSimpleNameExpression ktSimpleNameExpression2;
                KtSimpleNameExpression expression2 = ktSimpleNameExpression2 = ktSimpleNameExpression;
                boolean bl = false;
                ClassifierDescriptor classifier2 = this.findClassifierAndReportDeprecationIfNeeded(scope2, expression2.getReferencedNameAsName(), new KotlinLookupLocation(expression2), expression2, trace);
                this.checkNotEnumEntry(classifier2, trace, expression2);
                this.storeResult(trace, expression2, classifier2, ownerDescriptor, QualifierPosition.TYPE, false);
                classifierDescriptor = classifier2;
            }
            ClassifierDescriptor descriptor2 = classifierDescriptor;
            return new TypeQualifierResolutionResult((List)this.asQualifierPartList(userType).getFirst(), descriptor2);
        }
        Pair<List<ExpressionQualifierPart>, Boolean> pair = this.asQualifierPartList(userType);
        List qualifierPartList = (List)pair.component1();
        boolean hasError = (Boolean)pair.component2();
        if (hasError) {
            DeclarationDescriptor declarationDescriptor2 = this.resolveToPackageOrClass(qualifierPartList, DescriptorUtilsKt.getModule(scope2.getOwnerDescriptor()), trace, ownerDescriptor, scope2, QualifierPosition.TYPE);
            ClassifierDescriptor descriptor3 = declarationDescriptor2 instanceof ClassifierDescriptor ? (ClassifierDescriptor)declarationDescriptor2 : null;
            return new TypeQualifierResolutionResult(qualifierPartList, descriptor3);
        }
        return this.resolveQualifierPartListForType(qualifierPartList, ownerDescriptor, scope2, trace, false);
    }

    private final TypeQualifierResolutionResult resolveQualifierPartListForType(List<ExpressionQualifierPart> qualifierPartList, DeclarationDescriptor ownerDescriptor, LexicalScope scope2, BindingTrace trace, boolean isQualifier) {
        ClassifierDescriptor classifierDescriptor;
        boolean bl;
        boolean bl2 = bl = !((Collection)qualifierPartList).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-QualifiedExpressionResolver$resolveQualifierPartListForType$22 = false;
            String $i$a$-assert-QualifiedExpressionResolver$resolveQualifierPartListForType$22 = "Qualifier list should not be empty";
            throw new AssertionError((Object)$i$a$-assert-QualifiedExpressionResolver$resolveQualifierPartListForType$22);
        }
        DeclarationDescriptor $i$a$-assert-QualifiedExpressionResolver$resolveQualifierPartListForType$22 = this.resolveToPackageOrClass(qualifierPartList.subList(0, qualifierPartList.size() - 1), DescriptorUtilsKt.getModule(scope2.getOwnerDescriptor()), trace, ownerDescriptor, scope2, QualifierPosition.TYPE);
        if ($i$a$-assert-QualifiedExpressionResolver$resolveQualifierPartListForType$22 == null) {
            return new TypeQualifierResolutionResult(qualifierPartList, null);
        }
        DeclarationDescriptor qualifier = $i$a$-assert-QualifiedExpressionResolver$resolveQualifierPartListForType$22;
        ExpressionQualifierPart lastPart = (ExpressionQualifierPart)CollectionsKt.last(qualifierPartList);
        DeclarationDescriptor declarationDescriptor = qualifier;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            classifierDescriptor = ((PackageViewDescriptor)qualifier).getMemberScope().getContributedClassifier(lastPart.getName(), lastPart.getLocation());
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            ClassifierDescriptor descriptor2 = ((ClassDescriptor)qualifier).getUnsubstitutedInnerClassesScope().getContributedClassifier(lastPart.getName(), lastPart.getLocation());
            this.checkNotEnumEntry(descriptor2, trace, lastPart.getExpression());
            classifierDescriptor = descriptor2;
        } else {
            classifierDescriptor = null;
        }
        ClassifierDescriptor classifier2 = classifierDescriptor;
        this.storeResult(trace, lastPart.getExpression(), classifier2, ownerDescriptor, QualifierPosition.TYPE, isQualifier);
        return new TypeQualifierResolutionResult(qualifierPartList, classifier2);
    }

    private final void checkNotEnumEntry(DeclarationDescriptor descriptor2, BindingTrace trace, KtSimpleNameExpression expression2) {
        KtQualifiedExpression qualifiedParent;
        KtSimpleNameExpression ktSimpleNameExpression = expression2;
        if (ktSimpleNameExpression == null) {
            return;
        }
        if (descriptor2 != null && DescriptorUtils.isEnumEntry(descriptor2) && ((qualifiedParent = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(expression2)) == null || !(qualifiedParent.getParent() instanceof KtDoubleColonExpression))) {
            trace.report(Errors.ENUM_ENTRY_AS_TYPE.on((KtSimpleNameExpression)((PsiElement)expression2)));
        }
    }

    @NotNull
    public final TypeQualifierResolutionResult resolveDescriptorForDoubleColonLHS(@NotNull KtExpression expression2, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        DeclarationDescriptor ownerDescriptor = !isDebuggerContext ? scope2.getOwnerDescriptor() : null;
        List<ExpressionQualifierPart> qualifierPartList = this.asQualifierPartList(expression2, true);
        if (qualifierPartList.isEmpty()) {
            return new TypeQualifierResolutionResult(qualifierPartList, null);
        }
        if (qualifierPartList.size() == 1) {
            ExpressionQualifierPart expressionQualifierPart = (ExpressionQualifierPart)CollectionsKt.single(qualifierPartList);
            Name name = expressionQualifierPart.component1();
            KtSimpleNameExpression simpleNameExpression = expressionQualifierPart.component2();
            ClassifierDescriptor descriptor2 = this.findClassifierAndReportDeprecationIfNeeded(scope2, name, new KotlinLookupLocation(simpleNameExpression), simpleNameExpression, trace);
            this.storeResult(trace, simpleNameExpression, descriptor2, ownerDescriptor, QualifierPosition.TYPE, true);
            return new TypeQualifierResolutionResult(qualifierPartList, descriptor2);
        }
        return this.resolveQualifierPartListForType(qualifierPartList, ownerDescriptor, scope2, trace, true);
    }

    private final Pair<List<ExpressionQualifierPart>, Boolean> asQualifierPartList(KtUserType $this$asQualifierPartList) {
        boolean hasError = false;
        SmartList<ExpressionQualifierPart> result2 = new SmartList<ExpressionQualifierPart>();
        for (KtUserType userType = $this$asQualifierPartList; userType != null; userType = userType.getQualifier()) {
            KtSimpleNameExpression referenceExpression = userType.getReferenceExpression();
            if (referenceExpression != null) {
                result2.add(new ExpressionQualifierPart(referenceExpression.getReferencedNameAsName(), referenceExpression, userType.getTypeArgumentList()));
                continue;
            }
            hasError = true;
        }
        return TuplesKt.to((Object)CollectionsKt.asReversedMutable((List)result2), (Object)hasError);
    }

    @Nullable
    public final ImportingScope processImportReference(@NotNull KtImportInfo importDirective, @NotNull ModuleDescriptor moduleDescriptor, @NotNull BindingTrace trace, @NotNull Collection<FqName> excludedImportNames, @Nullable PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        Intrinsics.checkNotNullParameter((Object)importDirective, (String)"importDirective");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter(excludedImportNames, (String)"excludedImportNames");
        ImportingScope primaryImportingScope = QualifiedExpressionResolver.processImportReference$processReferenceInContextOf(this, importDirective, trace, excludedImportNames, packageFragmentForVisibilityCheck, moduleDescriptor);
        if (!CommonConfigurationKeysKt.isLibraryToSourceAnalysisEnabled(this.languageVersionSettings)) {
            return primaryImportingScope;
        }
        ModuleDescriptor moduleDescriptor2 = ResolutionAnchorProviderKt.getResolutionAnchorIfAny(moduleDescriptor);
        if (moduleDescriptor2 == null) {
            return primaryImportingScope;
        }
        ModuleDescriptor resolutionAnchor = moduleDescriptor2;
        ImportingScope importingScope = QualifiedExpressionResolver.processImportReference$processReferenceInContextOf(this, importDirective, trace, excludedImportNames, packageFragmentForVisibilityCheck, resolutionAnchor);
        if (importingScope == null) {
            return primaryImportingScope;
        }
        ImportingScope anchorImportingScope = importingScope;
        if (primaryImportingScope == null) {
            return anchorImportingScope;
        }
        return new CompositePrioritizedImportingScope(anchorImportingScope, primaryImportingScope);
    }

    private final ImportingScope doProcessImportReference(KtImportInfo importDirective, ModuleDescriptor moduleDescriptor, BindingTrace trace, Collection<FqName> excludedImportNames, PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        PackageFragmentDescriptor packageFragmentForCheck;
        PackageFragmentDescriptor packageFragmentDescriptor;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        KtImportInfo.ImportContent importContent = importDirective.getImportContent();
        if (importContent == null) {
            return null;
        }
        KtImportInfo.ImportContent importedReference = importContent;
        List<QualifierPart> path2 = this.asQualifierPartList(importedReference);
        QualifierPart qualifierPart = (QualifierPart)CollectionsKt.lastOrNull(path2);
        if (qualifierPart == null) {
            return null;
        }
        QualifierPart lastPart = qualifierPart;
        if (importDirective instanceof KtImportDirective) {
            KtFile ktFile = ((KtImportDirective)importDirective).getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"importDirective.containingKtFile");
            packageFragmentDescriptor = this.computePackageFragmentToCheck(ktFile, packageFragmentForVisibilityCheck);
        } else {
            packageFragmentDescriptor = packageFragmentForCheck = null;
        }
        if (importDirective.isAllUnder()) {
            DeclarationDescriptor declarationDescriptor = this.classDescriptorFromTypeAlias(this.resolveToPackageOrClass(path2, moduleDescriptor, trace, packageFragmentForCheck, null, QualifierPosition.IMPORT));
            if (declarationDescriptor == null) {
                return null;
            }
            DeclarationDescriptor packageOrClassDescriptor = declarationDescriptor;
            if (packageOrClassDescriptor instanceof ClassDescriptor && ((ClassDescriptor)packageOrClassDescriptor).getKind().isSingleton() && lastPart.getExpression() != null) {
                KtSimpleNameExpression ktSimpleNameExpression = lastPart.getExpression();
                Intrinsics.checkNotNull((Object)ktSimpleNameExpression);
                trace.report(Errors.CANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON.on((KtSimpleNameExpression)((PsiElement)ktSimpleNameExpression), (ClassDescriptor)packageOrClassDescriptor));
                return null;
            }
            return AllUnderImportScope.Companion.create(packageOrClassDescriptor, excludedImportNames);
        }
        return this.processSingleImport(moduleDescriptor, trace, importDirective, path2, lastPart, packageFragmentForCheck);
    }

    private final DeclarationDescriptor classDescriptorFromTypeAlias(DeclarationDescriptor $this$classDescriptorFromTypeAlias) {
        return $this$classDescriptorFromTypeAlias instanceof TypeAliasDescriptor ? (DeclarationDescriptor)((TypeAliasDescriptor)$this$classDescriptorFromTypeAlias).getClassDescriptor() : $this$classDescriptorFromTypeAlias;
    }

    private final PackageFragmentDescriptor computePackageFragmentToCheck(KtFile containingFile, PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        return CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(containingFile) ? null : (packageFragmentForVisibilityCheck instanceof DeclarationDescriptorWithSource && Intrinsics.areEqual((Object)packageFragmentForVisibilityCheck.getSource(), (Object)SourceElement.NO_SOURCE) ? (PackageFragmentDescriptor)new PackageFragmentWithCustomSource(packageFragmentForVisibilityCheck, new KotlinSourceElement(containingFile)) : packageFragmentForVisibilityCheck);
    }

    private final ImportingScope processSingleImport(ModuleDescriptor moduleDescriptor, BindingTrace trace, KtImportInfo importDirective, List<? extends QualifierPart> path2, QualifierPart lastPart, PackageFragmentDescriptor packageFragmentForVisibilityCheck) {
        DeclarationDescriptor declarationDescriptor;
        TypeAliasDescriptor typeAliasDescriptor;
        Name aliasName = importDirective.getImportedName();
        if (aliasName == null) {
            this.resolveToPackageOrClass(path2, moduleDescriptor, trace, packageFragmentForVisibilityCheck, null, QualifierPosition.IMPORT);
            return null;
        }
        DeclarationDescriptor declarationDescriptor2 = this.resolveToPackageOrClass(path2.subList(0, path2.size() - 1), moduleDescriptor, trace, packageFragmentForVisibilityCheck, null, QualifierPosition.IMPORT);
        if (declarationDescriptor2 == null) {
            return null;
        }
        DeclarationDescriptor resolvedDescriptor = declarationDescriptor2;
        TypeAliasDescriptor typeAliasDescriptor2 = typeAliasDescriptor = resolvedDescriptor instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)resolvedDescriptor : null;
        if (typeAliasDescriptor == null) {
            declarationDescriptor = resolvedDescriptor;
        } else {
            TypeAliasDescriptor typeAliasDescriptor3;
            TypeAliasDescriptor it = typeAliasDescriptor3 = typeAliasDescriptor;
            boolean bl = false;
            ClassDescriptor classDescriptor = it.getClassDescriptor();
            if (classDescriptor == null) {
                return null;
            }
            declarationDescriptor = classDescriptor;
        }
        DeclarationDescriptor packageOrClassDescriptor = declarationDescriptor;
        return new LazyExplicitImportScope(packageOrClassDescriptor, packageFragmentForVisibilityCheck, lastPart.getName(), aliasName, new CallOnceFunction<Collection<DeclarationDescriptor>, Unit>(Unit.INSTANCE, (Function1)new Function1<Collection<? extends DeclarationDescriptor>, Unit>(this, trace, lastPart, packageFragmentForVisibilityCheck, moduleDescriptor, packageOrClassDescriptor){
            final /* synthetic */ QualifiedExpressionResolver this$0;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ QualifierPart $lastPart;
            final /* synthetic */ PackageFragmentDescriptor $packageFragmentForVisibilityCheck;
            final /* synthetic */ ModuleDescriptor $moduleDescriptor;
            final /* synthetic */ DeclarationDescriptor $packageOrClassDescriptor;
            {
                this.this$0 = $receiver;
                this.$trace = $trace;
                this.$lastPart = $lastPart;
                this.$packageFragmentForVisibilityCheck = $packageFragmentForVisibilityCheck;
                this.$moduleDescriptor = $moduleDescriptor;
                this.$packageOrClassDescriptor = $packageOrClassDescriptor;
                super(1);
            }

            public final void invoke(@NotNull Collection<? extends DeclarationDescriptor> candidates2) {
                Intrinsics.checkNotNullParameter(candidates2, (String)"candidates");
                if (!candidates2.isEmpty()) {
                    QualifiedExpressionResolver.access$storeResult(this.this$0, this.$trace, this.$lastPart.getExpression(), candidates2, this.$packageFragmentForVisibilityCheck, QualifierPosition.IMPORT, false);
                } else {
                    QualifiedExpressionResolver.access$tryResolveDescriptorsWhichCannotBeImported(this.this$0, this.$trace, this.$moduleDescriptor, this.$packageOrClassDescriptor, this.$lastPart);
                }
            }
        }));
    }

    private final void tryResolveDescriptorsWhichCannotBeImported(BindingTrace trace, ModuleDescriptor moduleDescriptor, DeclarationDescriptor packageOrClassDescriptor, QualifierPart lastPart) {
        KtSimpleNameExpression ktSimpleNameExpression = lastPart.getExpression();
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression lastPartExpression = ktSimpleNameExpression;
        SmartList<DeclarationDescriptor> descriptors = new SmartList<DeclarationDescriptor>();
        Name lastName = lastPart.getName();
        DeclarationDescriptor declarationDescriptor = packageOrClassDescriptor;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            FqName fqName2 = ((PackageViewDescriptor)packageOrClassDescriptor).getFqName().child(lastName);
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"packageOrClassDescriptor.fqName.child(lastName)");
            PackageViewDescriptor packageDescriptor = moduleDescriptor.getPackage(fqName2);
            if (!packageDescriptor.isEmpty()) {
                trace.report(Errors.PACKAGE_CANNOT_BE_IMPORTED.on((KtSimpleNameExpression)((PsiElement)lastPartExpression)));
                descriptors.add(packageOrClassDescriptor);
            }
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            MemberScope memberScope2 = ((ClassDescriptor)packageOrClassDescriptor).getUnsubstitutedMemberScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"packageOrClassDescriptor.unsubstitutedMemberScope");
            MemberScope memberScope3 = memberScope2;
            descriptors.addAll(memberScope3.getContributedFunctions(lastName, lastPart.getLocation()));
            descriptors.addAll(memberScope3.getContributedVariables(lastName, lastPart.getLocation()));
            if (!((Collection)descriptors).isEmpty()) {
                trace.report(Errors.CANNOT_BE_IMPORTED.on((KtSimpleNameExpression)((PsiElement)lastPartExpression), lastName));
            }
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Should be class or package: ", (Object)packageOrClassDescriptor));
        }
        this.storeResult(trace, lastPart.getExpression(), (Collection<? extends DeclarationDescriptor>)descriptors, null, QualifierPosition.IMPORT, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<QualifierPart> asQualifierPartList(KtImportInfo.ImportContent $this$asQualifierPartList) {
        List list2;
        KtImportInfo.ImportContent importContent = $this$asQualifierPartList;
        if (importContent instanceof KtImportInfo.ImportContent.ExpressionBased) {
            list2 = QualifiedExpressionResolver.asQualifierPartList$default(this, ((KtImportInfo.ImportContent.ExpressionBased)$this$asQualifierPartList).getExpression(), false, 1, null);
        } else if (importContent instanceof KtImportInfo.ImportContent.FqNameBased) {
            void $this$mapTo$iv$iv;
            List<Name> list3 = ((KtImportInfo.ImportContent.FqNameBased)$this$asQualifierPartList).getFqName().pathSegments();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"fqName.pathSegments()");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Name name = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                QualifierPart qualifierPart = new QualifierPart((Name)it, null, null, 6, null);
                collection.add(qualifierPart);
            }
            list2 = (List)destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    private final List<ExpressionQualifierPart> asQualifierPartList(KtExpression $this$asQualifierPartList, boolean doubleColonLHS) {
        SmartList<ExpressionQualifierPart> result2 = new SmartList<ExpressionQualifierPart>();
        KtExpression expression2 = $this$asQualifierPartList;
        while (!QualifiedExpressionResolver.asQualifierPartList$addQualifierPart(result2, doubleColonLHS, expression2) && expression2 instanceof KtQualifiedExpression) {
            QualifiedExpressionResolver.asQualifierPartList$addQualifierPart(result2, doubleColonLHS, ((KtQualifiedExpression)expression2).getSelectorExpression());
            expression2 = ((KtQualifiedExpression)expression2).getReceiverExpression();
        }
        return CollectionsKt.asReversedMutable((List)result2);
    }

    static /* synthetic */ List asQualifierPartList$default(QualifiedExpressionResolver qualifiedExpressionResolver, KtExpression ktExpression, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return qualifiedExpressionResolver.asQualifierPartList(ktExpression, bl);
    }

    private final DeclarationDescriptor resolveToPackageOrClass(List<? extends QualifierPart> path2, ModuleDescriptor moduleDescriptor, BindingTrace trace, DeclarationDescriptor shouldBeVisibleFrom, LexicalScope scopeForFirstPart, QualifierPosition position) {
        Pair pair = QualifiedExpressionResolver.resolveToPackageOrClassPrefix$default(this, path2, moduleDescriptor, trace, shouldBeVisibleFrom, scopeForFirstPart, position, null, 64, null);
        DeclarationDescriptor packageOrClassDescriptor = (DeclarationDescriptor)pair.component1();
        int endIndex = ((Number)pair.component2()).intValue();
        if (endIndex != path2.size()) {
            return null;
        }
        return packageOrClassDescriptor;
    }

    private final boolean resolveInIDEMode(List<? extends QualifierPart> path2) {
        return this.languageVersionSettings.getFlag(AnalysisFlags.getIdeMode()) != false && path2.size() > 1 && Intrinsics.areEqual((Object)((QualifierPart)CollectionsKt.first(path2)).getName().asString(), (Object)ROOT_PREFIX_FOR_IDE_RESOLUTION_MODE);
    }

    private final Pair<DeclarationDescriptor, Integer> resolveToPackageOrClassPrefix(List<? extends QualifierPart> path2, ModuleDescriptor moduleDescriptor, BindingTrace trace, DeclarationDescriptor shouldBeVisibleFrom, LexicalScope scopeForFirstPart, QualifierPosition position, Function1<? super KtSimpleNameExpression, Boolean> isValue) {
        Pair<PackageViewDescriptor, Integer> pair;
        ClassifierDescriptor classifierDescriptor;
        if (this.resolveInIDEMode(path2)) {
            Pair<DeclarationDescriptor, Integer> pair2;
            Pair<DeclarationDescriptor, Integer> it = pair2 = this.resolveToPackageOrClassPrefix(path2.subList(1, path2.size()), moduleDescriptor, trace, shouldBeVisibleFrom, null, position, null);
            boolean bl = false;
            return TuplesKt.to((Object)it.getFirst(), (Object)(((Number)it.getSecond()).intValue() + 1));
        }
        if (path2.isEmpty()) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ROOT");
            return new Pair((Object)moduleDescriptor.getPackage(fqName2), (Object)0);
        }
        QualifierPart firstPart = (QualifierPart)CollectionsKt.first(path2);
        if (position == QualifierPosition.EXPRESSION && scopeForFirstPart != null && isValue != null && firstPart.getExpression() != null) {
            KtSimpleNameExpression ktSimpleNameExpression = firstPart.getExpression();
            Intrinsics.checkNotNull((Object)ktSimpleNameExpression);
            if (((Boolean)isValue.invoke((Object)ktSimpleNameExpression)).booleanValue()) {
                return new Pair(null, (Object)0);
            }
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = (pair = scopeForFirstPart) == null ? null : ScopeUtilsKt.findClassifier((HierarchicalScope)pair, firstPart.getName(), firstPart.getLocation());
        if (classifierDescriptor != null) {
            QualifiedExpressionResolver.storeResult$default(this, trace, firstPart.getExpression(), classifierDescriptor, shouldBeVisibleFrom, position, false, 32, null);
        }
        pair = classifierDescriptor != null ? new Pair<PackageViewDescriptor, Integer>((Object)classifierDescriptor, (Object)1) : this.quickResolveToPackage(moduleDescriptor, path2, trace, position);
        DeclarationDescriptor prefixDescriptor = (DeclarationDescriptor)pair.component1();
        int nextIndexAfterPrefix = ((Number)pair.component2()).intValue();
        DeclarationDescriptor currentDescriptor = prefixDescriptor;
        int n = nextIndexAfterPrefix;
        int n2 = path2.size();
        while (n < n2) {
            DeclarationDescriptor nextPackageOrClassDescriptor;
            DeclarationDescriptor declarationDescriptor;
            int qualifierPartIndex = n++;
            QualifierPart qualifierPart = path2.get(qualifierPartIndex);
            DeclarationDescriptor declarationDescriptor2 = currentDescriptor;
            if (declarationDescriptor2 instanceof TypeAliasDescriptor) {
                declarationDescriptor = null;
            } else if (declarationDescriptor2 instanceof ClassDescriptor) {
                declarationDescriptor = this.getContributedClassifier((ClassDescriptor)currentDescriptor, qualifierPart);
            } else if (declarationDescriptor2 instanceof PackageViewDescriptor) {
                PackageViewDescriptor packageView;
                PackageViewDescriptor packageViewDescriptor;
                if (qualifierPart.getTypeArguments() == null) {
                    FqName fqName3 = ((PackageViewDescriptor)currentDescriptor).getFqName().child(qualifierPart.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"currentDescriptor.fqName.child(qualifierPart.name)");
                    packageViewDescriptor = moduleDescriptor.getPackage(fqName3);
                } else {
                    packageViewDescriptor = packageView = null;
                }
                declarationDescriptor = packageView != null && !packageView.isEmpty() ? (DeclarationDescriptor)packageView : (DeclarationDescriptor)((PackageViewDescriptor)currentDescriptor).getMemberScope().getContributedClassifier(qualifierPart.getName(), qualifierPart.getLocation());
            } else {
                declarationDescriptor = nextPackageOrClassDescriptor = null;
            }
            if (position != QualifierPosition.EXPRESSION || nextPackageOrClassDescriptor != null) {
                QualifiedExpressionResolver.storeResult$default(this, trace, qualifierPart.getExpression(), nextPackageOrClassDescriptor, shouldBeVisibleFrom, position, false, 32, null);
            }
            if (nextPackageOrClassDescriptor == null) {
                return new Pair((Object)currentDescriptor, (Object)qualifierPartIndex);
            }
            currentDescriptor = nextPackageOrClassDescriptor;
        }
        return new Pair((Object)currentDescriptor, (Object)path2.size());
    }

    static /* synthetic */ Pair resolveToPackageOrClassPrefix$default(QualifiedExpressionResolver qualifiedExpressionResolver, List list2, ModuleDescriptor moduleDescriptor, BindingTrace bindingTrace, DeclarationDescriptor declarationDescriptor, LexicalScope lexicalScope, QualifierPosition qualifierPosition, Function1 function1, int n, Object object) {
        if ((n & 0x40) != 0) {
            function1 = null;
        }
        return qualifiedExpressionResolver.resolveToPackageOrClassPrefix(list2, moduleDescriptor, bindingTrace, declarationDescriptor, lexicalScope, qualifierPosition, (Function1<? super KtSimpleNameExpression, Boolean>)function1);
    }

    @Nullable
    public final ClassifierDescriptor getContributedClassifier(@NotNull ClassDescriptor $this$getContributedClassifier, @NotNull QualifierPart qualifierPart) {
        Intrinsics.checkNotNullParameter((Object)$this$getContributedClassifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)qualifierPart, (String)"qualifierPart");
        return $this$getContributedClassifier.getUnsubstitutedInnerClassesScope().getContributedClassifier(qualifierPart.getName(), qualifierPart.getLocation());
    }

    @Nullable
    public final Qualifier resolveNameExpressionAsQualifierForDiagnostics(@NotNull KtSimpleNameExpression expression2, @Nullable Receiver receiver, @NotNull ExpressionTypingContext context2) {
        DeclarationDescriptor qualifierDescriptor;
        DeclarationDescriptor declarationDescriptor;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Name name = expression2.getReferencedNameAsName();
        if (!expression2.isPhysical() && !name.isSpecial()) {
            String string2 = name.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
            if (StringsKt.endsWith$default((String)string2, (String)"IntellijIdeaRulezzz", (boolean)false, (int)2, null)) {
                return null;
            }
        }
        KotlinLookupLocation location2 = new KotlinLookupLocation(expression2);
        Object object2 = receiver;
        if (object2 instanceof PackageQualifier) {
            PackageViewDescriptor packageViewDescriptor;
            object = ((PackageQualifier)receiver).getDescriptor().getFqName().child(name);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"receiver.descriptor.fqName.child(name)");
            Object childPackageFQN = object;
            PackageViewDescriptor it = packageViewDescriptor = ((PackageQualifier)receiver).getDescriptor().getModule().getPackage((FqName)childPackageFQN);
            boolean bl = false;
            Object object3 = object = !it.isEmpty() ? packageViewDescriptor : null;
            declarationDescriptor = object == null ? (DeclarationDescriptor)((PackageQualifier)receiver).getDescriptor().getMemberScope().getContributedClassifier(name, location2) : (DeclarationDescriptor)object;
        } else if (object2 instanceof ClassQualifier) {
            declarationDescriptor = ((ClassQualifier)receiver).getStaticScope().getContributedClassifier(name, location2);
        } else if (object2 == null) {
            object = context2.scope;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.scope");
            ClassifierDescriptor classifierDescriptor = ScopeUtilsKt.findClassifier((HierarchicalScope)object, name, location2);
            if (classifierDescriptor == null) {
                ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(context2.scope.getOwnerDescriptor());
                object = FqName.ROOT.child(name);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ROOT.child(name)");
                Object it = object = moduleDescriptor.getPackage((FqName)object);
                boolean bl = false;
                declarationDescriptor = (DeclarationDescriptor)(!it.isEmpty() ? object : null);
            } else {
                declarationDescriptor = classifierDescriptor;
            }
        } else {
            declarationDescriptor = qualifierDescriptor = object2 instanceof ReceiverValue ? (DeclarationDescriptor)ScopeUtilsKt.findClassifier(ScopeUtilsKt.memberScopeAsImportingScope$default(((ReceiverValue)receiver).getType().getMemberScope(), null, 1, null), name, location2) : null;
        }
        if (qualifierDescriptor != null) {
            object2 = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.trace");
            return QualifiedExpressionResolver.storeResult$default(this, (BindingTrace)object2, expression2, qualifierDescriptor, context2.scope.getOwnerDescriptor(), QualifierPosition.EXPRESSION, false, 32, null);
        }
        return null;
    }

    @NotNull
    public final QualifiedExpressionResolveResult resolveClassOrPackageInQualifiedExpression(@NotNull KtQualifiedExpression expression2, @NotNull LexicalScope scope2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List<KtQualifiedExpression> qualifiedExpressions = CallExpressionUnrollerKt.unrollToLeftMostQualifiedExpression(expression2);
        List<QualifierPart> path2 = this.mapToQualifierParts(qualifiedExpressions, 0);
        DelegatingBindingTrace trace = new DelegatingBindingTrace(context2, "Temp trace for resolving qualified expression", false, null, false, null, 60, null);
        Pair pair = QualifiedExpressionResolver.resolveToPackageOrClassPrefix$default(this, path2, DescriptorUtilsKt.getModule(scope2.getOwnerDescriptor()), trace, scope2.getOwnerDescriptor(), scope2, QualifierPosition.EXPRESSION, null, 64, null);
        DeclarationDescriptor result2 = (DeclarationDescriptor)pair.component1();
        int index2 = ((Number)pair.component2()).intValue();
        if (result2 == null) {
            return QualifiedExpressionResolveResult.Companion.getUNRESOLVED();
        }
        int n = index2;
        return n == path2.size() ? new QualifiedExpressionResolveResult(result2, null) : (n == path2.size() - 1 ? new QualifiedExpressionResolveResult(result2, path2.get(index2).getName()) : QualifiedExpressionResolveResult.Companion.getUNRESOLVED());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CallExpressionElement> resolveQualifierInExpressionAndUnroll(@NotNull KtQualifiedExpression expression2, @NotNull ExpressionTypingContext context2, @NotNull Function1<? super KtSimpleNameExpression, Boolean> isValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(isValue, (String)"isValue");
        List<KtQualifiedExpression> qualifiedExpressions = CallExpressionUnrollerKt.unrollToLeftMostQualifiedExpression(expression2);
        List<QualifierPart> maxPossibleQualifierPrefix = this.mapToQualifierParts(qualifiedExpressions, 1);
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(context2.scope.getOwnerDescriptor());
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        int nextIndexAfterPrefix = ((Number)this.resolveToPackageOrClassPrefix(maxPossibleQualifierPrefix, moduleDescriptor, bindingTrace, context2.scope.getOwnerDescriptor(), context2.scope, QualifierPosition.EXPRESSION, isValue).getSecond()).intValue();
        int nextExpressionIndexAfterQualifier = nextIndexAfterPrefix == 0 ? 0 : nextIndexAfterPrefix - 1;
        Iterable iterable = qualifiedExpressions.subList(nextExpressionIndexAfterQualifier, qualifiedExpressions.size());
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CallExpressionElement callExpressionElement = new CallExpressionElement((KtQualifiedExpression)p0);
            collection.add(callExpressionElement);
        }
        return (List)destination$iv$iv;
    }

    private final List<QualifierPart> mapToQualifierParts(List<? extends KtQualifiedExpression> qualifiedExpressions, int skipLast) {
        KtExpression selector;
        KtQualifiedExpression qualifiedExpression;
        if (qualifiedExpressions.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        KtQualifiedExpression first = (KtQualifiedExpression)CollectionsKt.first(qualifiedExpressions);
        if (!(first instanceof KtDotQualifiedExpression)) {
            return CollectionsKt.emptyList();
        }
        KtExpression firstReceiver = first.getReceiverExpression();
        if (!(firstReceiver instanceof KtSimpleNameExpression)) {
            return CollectionsKt.emptyList();
        }
        ArrayList<ExpressionQualifierPart> qualifierParts = new ArrayList<ExpressionQualifierPart>();
        qualifierParts.add(new ExpressionQualifierPart((KtSimpleNameExpression)firstReceiver));
        Iterator iterator2 = CollectionsKt.dropLast(qualifiedExpressions, (int)skipLast).iterator();
        while (iterator2.hasNext() && (qualifiedExpression = (KtQualifiedExpression)iterator2.next()) instanceof KtDotQualifiedExpression && (selector = qualifiedExpression.getSelectorExpression()) instanceof KtSimpleNameExpression) {
            qualifierParts.add(new ExpressionQualifierPart((KtSimpleNameExpression)selector));
        }
        return qualifierParts;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<PackageViewDescriptor, Integer> quickResolveToPackage(ModuleDescriptor $this$quickResolveToPackage, List<? extends QualifierPart> path2, BindingTrace trace, QualifierPosition position) {
        int $this$indexOfFirst$iv22;
        int n;
        block5: {
            List<? extends QualifierPart> $this$indexOfFirst$iv22 = path2;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<? extends QualifierPart> iterator2 = $this$indexOfFirst$iv22.iterator();
            while (iterator2.hasNext()) {
                QualifierPart qualifierPart;
                QualifierPart it232 = qualifierPart = iterator2.next();
                boolean bl = false;
                if (it232.getTypeArguments() != null) {
                    n = index$iv;
                    break block5;
                }
                int it232 = index$iv;
                index$iv = it232 + 1;
            }
            n = -1;
        }
        int it332 = $this$indexOfFirst$iv22 = n;
        boolean bl = false;
        int possiblePackagePrefixSize = it332 == -1 ? path2.size() : it332 + 1;
        Iterable $this$map$iv = path2.subList(0, possiblePackagePrefixSize);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            QualifierPart qualifierPart = (QualifierPart)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string2 = it.getName().asString();
            collection.add(string2);
        }
        FqName it332 = FqName.fromSegments((List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)it332, (String)"fromSegments(path.subLis\u2026p { it.name.asString() })");
        FqName fqName2 = it332;
        int prefixSize = possiblePackagePrefixSize;
        while (!fqName2.isRoot()) {
            PackageViewDescriptor packageDescriptor = $this$quickResolveToPackage.getPackage(fqName2);
            if (!packageDescriptor.isEmpty()) {
                this.recordPackageViews(path2.subList(0, prefixSize), packageDescriptor, trace, position);
                return new Pair((Object)packageDescriptor, (Object)prefixSize);
            }
            FqName fqName3 = fqName2.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"fqName.parent()");
            fqName2 = fqName3;
            int n2 = prefixSize;
            prefixSize = n2 + -1;
        }
        FqName fqName4 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"ROOT");
        return new Pair((Object)$this$quickResolveToPackage.getPackage(fqName4), (Object)0);
    }

    /*
     * WARNING - void declaration
     */
    private final void recordPackageViews(List<? extends QualifierPart> path2, PackageViewDescriptor packageView, BindingTrace trace, QualifierPosition position) {
        List<? extends QualifierPart> $this$foldRight$iv = path2;
        boolean $i$f$foldRight = false;
        PackageViewDescriptor accumulator$iv = packageView;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator<? extends QualifierPart> iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void currentView;
                PackageViewDescriptor packageViewDescriptor = accumulator$iv;
                QualifierPart qualifierPart = iterator$iv.previous();
                boolean bl = false;
                QualifiedExpressionResolver.storeResult$default(this, trace, qualifierPart.getExpression(), (DeclarationDescriptor)currentView, null, position, false, 32, null);
                PackageViewDescriptor packageViewDescriptor2 = currentView.getContainingDeclaration();
                if (packageViewDescriptor2 == null) {
                    throw new IllegalStateException(("Containing Declaration must be not null for package with fqName: " + currentView.getFqName() + ", path: " + CollectionsKt.joinToString$default((Iterable)path2, null, null, null, (int)0, null, null, (int)63, null) + ", packageView fqName: " + packageView.getFqName()).toString());
                }
                accumulator$iv = packageViewDescriptor2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void storeResult(BindingTrace trace, KtSimpleNameExpression referenceExpression, Collection<? extends DeclarationDescriptor> descriptors, DeclarationDescriptor shouldBeVisibleFrom, QualifierPosition position, boolean isQualifier) {
        KtSimpleNameExpression ktSimpleNameExpression = referenceExpression;
        if (ktSimpleNameExpression == null) {
            return;
        }
        if (descriptors.size() > 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = descriptors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                boolean bl = false;
                if (!QualifiedExpressionResolverKt.isVisible(it, shouldBeVisibleFrom, position)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List visibleDescriptors = (List)destination$iv$iv;
            if (visibleDescriptors.isEmpty()) {
                DeclarationDescriptorWithVisibility descriptor2 = (DeclarationDescriptorWithVisibility)CollectionsKt.first((Iterable)descriptors);
                trace.report(Errors.INVISIBLE_REFERENCE.on((KtSimpleNameExpression)((PsiElement)referenceExpression), descriptor2, descriptor2.getVisibility(), descriptor2));
            } else if (visibleDescriptors.size() > 1) {
                trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression, visibleDescriptors);
            } else {
                this.storeResult(trace, referenceExpression, (DeclarationDescriptor)CollectionsKt.single((List)visibleDescriptors), null, position, isQualifier);
            }
        } else {
            this.storeResult(trace, referenceExpression, (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)descriptors), shouldBeVisibleFrom, position, isQualifier);
        }
    }

    private final Qualifier storeResult(BindingTrace trace, KtSimpleNameExpression referenceExpression, DeclarationDescriptor descriptor2, DeclarationDescriptor shouldBeVisibleFrom, QualifierPosition position, boolean isQualifier) {
        KtSimpleNameExpression ktSimpleNameExpression = referenceExpression;
        if (ktSimpleNameExpression == null) {
            return null;
        }
        if (descriptor2 == null) {
            trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)referenceExpression), referenceExpression));
            return null;
        }
        trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, descriptor2);
        UnderscoreUsageChecker.INSTANCE.checkSimpleNameUsage(descriptor2, referenceExpression, trace);
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility) {
            DeclarationDescriptor fromToCheck;
            DeclarationDescriptor declarationDescriptor;
            if (shouldBeVisibleFrom instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)shouldBeVisibleFrom).getSource(), (Object)SourceElement.NO_SOURCE) && !(referenceExpression.getContainingFile() instanceof DummyHolder)) {
                PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)shouldBeVisibleFrom;
                KtFile ktFile = referenceExpression.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"referenceExpression.containingKtFile");
                declarationDescriptor = new PackageFragmentWithCustomSource(packageFragmentDescriptor, new KotlinSourceElement(ktFile));
            } else {
                declarationDescriptor = fromToCheck = shouldBeVisibleFrom;
            }
            if (!QualifiedExpressionResolverKt.isVisible(descriptor2, fromToCheck, position)) {
                trace.report(Errors.INVISIBLE_REFERENCE.on((KtSimpleNameExpression)((PsiElement)referenceExpression), descriptor2, ((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), descriptor2));
            }
        }
        return isQualifier ? this.storeQualifier(trace, referenceExpression, descriptor2) : null;
    }

    static /* synthetic */ Qualifier storeResult$default(QualifiedExpressionResolver qualifiedExpressionResolver, BindingTrace bindingTrace, KtSimpleNameExpression ktSimpleNameExpression, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, QualifierPosition qualifierPosition, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return qualifiedExpressionResolver.storeResult(bindingTrace, ktSimpleNameExpression, declarationDescriptor, declarationDescriptor2, qualifierPosition, bl);
    }

    private final Qualifier storeQualifier(BindingTrace trace, KtSimpleNameExpression referenceExpression, DeclarationDescriptor descriptor2) {
        Qualifier qualifier;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            qualifier = new PackageQualifier(referenceExpression, (PackageViewDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            qualifier = new ClassQualifier(referenceExpression, (ClassDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof TypeParameterDescriptor) {
            qualifier = new TypeParameterQualifier(referenceExpression, (TypeParameterDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            qualifier = new TypeAliasQualifier(referenceExpression, (TypeAliasDescriptor)descriptor2, classDescriptor2);
        } else {
            return null;
        }
        Qualifier qualifier2 = qualifier;
        trace.record(BindingContext.QUALIFIER, QualifierKt.getExpression(qualifier2), qualifier2);
        return qualifier2;
    }

    private static final ImportingScope processImportReference$processReferenceInContextOf(QualifiedExpressionResolver this$0, KtImportInfo $importDirective, BindingTrace $trace, Collection<FqName> $excludedImportNames, PackageFragmentDescriptor $packageFragmentForVisibilityCheck, ModuleDescriptor moduleDescriptor) {
        return this$0.doProcessImportReference($importDirective, moduleDescriptor, $trace, $excludedImportNames, $packageFragmentForVisibilityCheck);
    }

    private static final boolean asQualifierPartList$addQualifierPart(SmartList<ExpressionQualifierPart> result2, boolean $doubleColonLHS, KtExpression expression2) {
        KtExpression simpleName;
        if (expression2 instanceof KtSimpleNameExpression) {
            result2.add(new ExpressionQualifierPart((KtSimpleNameExpression)expression2));
            return true;
        }
        if ($doubleColonLHS && expression2 instanceof KtCallExpression && DoubleColonExpressionResolverKt.isWithoutValueArguments((KtCallExpression)expression2) && (simpleName = ((KtCallExpression)expression2).getCalleeExpression()) instanceof KtSimpleNameExpression) {
            result2.add(new ExpressionQualifierPart(((KtSimpleNameExpression)simpleName).getReferencedNameAsName(), (KtSimpleNameExpression)simpleName, ((KtCallExpression)expression2).getTypeArgumentList()));
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void access$storeResult(QualifiedExpressionResolver $this, BindingTrace trace, KtSimpleNameExpression referenceExpression, Collection descriptors, DeclarationDescriptor shouldBeVisibleFrom, QualifierPosition position, boolean isQualifier) {
        $this.storeResult(trace, referenceExpression, descriptors, shouldBeVisibleFrom, position, isQualifier);
    }

    public static final /* synthetic */ void access$tryResolveDescriptorsWhichCannotBeImported(QualifiedExpressionResolver $this, BindingTrace trace, ModuleDescriptor moduleDescriptor, DeclarationDescriptor packageOrClassDescriptor, QualifierPart lastPart) {
        $this.tryResolveDescriptorsWhichCannotBeImported(trace, moduleDescriptor, packageOrClassDescriptor, lastPart);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J%\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "", "qualifierParts", "", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$ExpressionQualifierPart;", "classifierDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)V", "allProjections", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "getAllProjections", "()Ljava/util/List;", "getClassifierDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getQualifierParts", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class TypeQualifierResolutionResult {
        @NotNull
        private final List<ExpressionQualifierPart> qualifierParts;
        @Nullable
        private final ClassifierDescriptor classifierDescriptor;

        public TypeQualifierResolutionResult(@NotNull List<ExpressionQualifierPart> qualifierParts, @Nullable ClassifierDescriptor classifierDescriptor) {
            Intrinsics.checkNotNullParameter(qualifierParts, (String)"qualifierParts");
            this.qualifierParts = qualifierParts;
            this.classifierDescriptor = classifierDescriptor;
        }

        public /* synthetic */ TypeQualifierResolutionResult(List list2, ClassifierDescriptor classifierDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                classifierDescriptor = null;
            }
            this(list2, classifierDescriptor);
        }

        @NotNull
        public final List<ExpressionQualifierPart> getQualifierParts() {
            return this.qualifierParts;
        }

        @Nullable
        public final ClassifierDescriptor getClassifierDescriptor() {
            return this.classifierDescriptor;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtTypeProjection> getAllProjections() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.qualifierParts;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List<KtTypeProjection> list2;
                ExpressionQualifierPart it = (ExpressionQualifierPart)element$iv$iv;
                boolean bl = false;
                KtTypeArgumentList ktTypeArgumentList = it.getTypeArguments();
                List<KtTypeProjection> list3 = list2 = ktTypeArgumentList == null ? null : ktTypeArgumentList.getArguments();
                Iterable list$iv$iv = list2 == null ? CollectionsKt.emptyList() : list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<ExpressionQualifierPart> component1() {
            return this.qualifierParts;
        }

        @Nullable
        public final ClassifierDescriptor component2() {
            return this.classifierDescriptor;
        }

        @NotNull
        public final TypeQualifierResolutionResult copy(@NotNull List<ExpressionQualifierPart> qualifierParts, @Nullable ClassifierDescriptor classifierDescriptor) {
            Intrinsics.checkNotNullParameter(qualifierParts, (String)"qualifierParts");
            return new TypeQualifierResolutionResult(qualifierParts, classifierDescriptor);
        }

        public static /* synthetic */ TypeQualifierResolutionResult copy$default(TypeQualifierResolutionResult typeQualifierResolutionResult, List list2, ClassifierDescriptor classifierDescriptor, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = typeQualifierResolutionResult.qualifierParts;
            }
            if ((n & 2) != 0) {
                classifierDescriptor = typeQualifierResolutionResult.classifierDescriptor;
            }
            return typeQualifierResolutionResult.copy(list2, classifierDescriptor);
        }

        @NotNull
        public String toString() {
            return "TypeQualifierResolutionResult(qualifierParts=" + this.qualifierParts + ", classifierDescriptor=" + this.classifierDescriptor + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.qualifierParts).hashCode();
            result2 = result2 * 31 + (this.classifierDescriptor == null ? 0 : this.classifierDescriptor.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeQualifierResolutionResult)) {
                return false;
            }
            TypeQualifierResolutionResult typeQualifierResolutionResult = (TypeQualifierResolutionResult)other;
            if (!Intrinsics.areEqual(this.qualifierParts, typeQualifierResolutionResult.qualifierParts)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.classifierDescriptor, (Object)typeQualifierResolutionResult.classifierDescriptor);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u0086\u0002J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0096\u0002J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0086\u0002R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "typeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)V", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getLocation", "()Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getTypeArguments", "()Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "component1", "component2", "component3", "frontend"})
    public static class QualifierPart {
        @NotNull
        private final Name name;
        @Nullable
        private final KtTypeArgumentList typeArguments;
        @NotNull
        private final LookupLocation location;

        public QualifierPart(@NotNull Name name, @Nullable KtTypeArgumentList typeArguments2, @NotNull LookupLocation location2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            this.name = name;
            this.typeArguments = typeArguments2;
            this.location = location2;
        }

        public /* synthetic */ QualifierPart(Name name, KtTypeArgumentList ktTypeArgumentList, LookupLocation lookupLocation, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                ktTypeArgumentList = null;
            }
            if ((n & 4) != 0) {
                lookupLocation = NoLookupLocation.FOR_DEFAULT_IMPORTS;
            }
            this(name, ktTypeArgumentList, lookupLocation);
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @Nullable
        public final KtTypeArgumentList getTypeArguments() {
            return this.typeArguments;
        }

        @NotNull
        public final LookupLocation getLocation() {
            return this.location;
        }

        @Nullable
        public KtSimpleNameExpression getExpression() {
            return null;
        }

        @NotNull
        public final Name component1() {
            return this.name;
        }

        @Nullable
        public KtSimpleNameExpression component2() {
            return this.getExpression();
        }

        @Nullable
        public final KtTypeArgumentList component3() {
            return this.typeArguments;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\f\u001a\u00020\u0003H\u0096\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$ExpressionQualifierPart;", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "typeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "component2", "frontend"})
    public static final class ExpressionQualifierPart
    extends QualifierPart {
        @NotNull
        private final KtSimpleNameExpression expression;

        public ExpressionQualifierPart(@NotNull Name name, @NotNull KtSimpleNameExpression expression2, @Nullable KtTypeArgumentList typeArguments2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            super(name, typeArguments2, new KotlinLookupLocation(expression2));
            this.expression = expression2;
        }

        public /* synthetic */ ExpressionQualifierPart(Name name, KtSimpleNameExpression ktSimpleNameExpression, KtTypeArgumentList ktTypeArgumentList, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                ktTypeArgumentList = null;
            }
            this(name, ktSimpleNameExpression, ktTypeArgumentList);
        }

        @Override
        @NotNull
        public KtSimpleNameExpression getExpression() {
            return this.expression;
        }

        public ExpressionQualifierPart(@NotNull KtSimpleNameExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this(expression2.getReferencedNameAsName(), expression2, null, 4, null);
        }

        @Override
        @NotNull
        public KtSimpleNameExpression component2() {
            return this.getExpression();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult;", "", "classOrPackage", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "memberName", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/name/Name;)V", "getClassOrPackage", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getMemberName", "()Lorg/jetbrains/kotlin/name/Name;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "frontend"})
    public static final class QualifiedExpressionResolveResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final DeclarationDescriptor classOrPackage;
        @Nullable
        private final Name memberName;
        @NotNull
        private static final QualifiedExpressionResolveResult UNRESOLVED = new QualifiedExpressionResolveResult(null, null);

        public QualifiedExpressionResolveResult(@Nullable DeclarationDescriptor classOrPackage, @Nullable Name memberName) {
            this.classOrPackage = classOrPackage;
            this.memberName = memberName;
        }

        @Nullable
        public final DeclarationDescriptor getClassOrPackage() {
            return this.classOrPackage;
        }

        @Nullable
        public final Name getMemberName() {
            return this.memberName;
        }

        @Nullable
        public final DeclarationDescriptor component1() {
            return this.classOrPackage;
        }

        @Nullable
        public final Name component2() {
            return this.memberName;
        }

        @NotNull
        public final QualifiedExpressionResolveResult copy(@Nullable DeclarationDescriptor classOrPackage, @Nullable Name memberName) {
            return new QualifiedExpressionResolveResult(classOrPackage, memberName);
        }

        public static /* synthetic */ QualifiedExpressionResolveResult copy$default(QualifiedExpressionResolveResult qualifiedExpressionResolveResult, DeclarationDescriptor declarationDescriptor, Name name, int n, Object object) {
            if ((n & 1) != 0) {
                declarationDescriptor = qualifiedExpressionResolveResult.classOrPackage;
            }
            if ((n & 2) != 0) {
                name = qualifiedExpressionResolveResult.memberName;
            }
            return qualifiedExpressionResolveResult.copy(declarationDescriptor, name);
        }

        @NotNull
        public String toString() {
            return "QualifiedExpressionResolveResult(classOrPackage=" + this.classOrPackage + ", memberName=" + this.memberName + ')';
        }

        public int hashCode() {
            int result2 = this.classOrPackage == null ? 0 : this.classOrPackage.hashCode();
            result2 = result2 * 31 + (this.memberName == null ? 0 : this.memberName.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QualifiedExpressionResolveResult)) {
                return false;
            }
            QualifiedExpressionResolveResult qualifiedExpressionResolveResult = (QualifiedExpressionResolveResult)other;
            if (!Intrinsics.areEqual((Object)this.classOrPackage, (Object)qualifiedExpressionResolveResult.classOrPackage)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.memberName, (Object)qualifiedExpressionResolveResult.memberName);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult$Companion;", "", "()V", "UNRESOLVED", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult;", "getUNRESOLVED", "()Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifiedExpressionResolveResult;", "frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final QualifiedExpressionResolveResult getUNRESOLVED() {
                return UNRESOLVED;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$Companion;", "", "()V", "ROOT_PREFIX_FOR_IDE_RESOLUTION_MODE", "", "ROOT_PREFIX_FOR_IDE_RESOLUTION_MODE_WITH_DOT", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

