/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayElement;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0019J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0019H\u0002J\r\u0010%\u001a\u00020\u0011*\u00020\u0019H\u0086\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilder;", "", "builder", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "arrayType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getArrayType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getBuilder", "()Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "elementType", "getElementType", "elements", "", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrArrayElement;", "hasSpread", "", "getHasSpread", "()Z", "isUnboxedInlineClassArray", "unwrappedArrayType", "getUnwrappedArrayType", "add", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "addSpread", "build", "buildComplexArray", "buildSimpleArray", "coerce", "irType", "copyArray", "spread", "newArray", "size", "", "unaryPlus", "backend.jvm"})
public final class IrArrayBuilder {
    @NotNull
    private final JvmIrBuilder builder;
    @NotNull
    private final IrType arrayType;
    @NotNull
    private final IrType unwrappedArrayType;
    @NotNull
    private final IrType elementType;
    @NotNull
    private final List<IrArrayElement> elements;

    public IrArrayBuilder(@NotNull JvmIrBuilder builder2, @NotNull IrType arrayType) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        this.builder = builder2;
        this.arrayType = arrayType;
        this.unwrappedArrayType = InlineClassAbiKt.unboxInlineClass(this.arrayType);
        this.elementType = IrTypeUtilsKt.getArrayElementType(this.unwrappedArrayType, this.builder.getContext().getIrBuiltIns());
        this.elements = new ArrayList();
    }

    @NotNull
    public final JvmIrBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final IrType getArrayType() {
        return this.arrayType;
    }

    @NotNull
    public final IrType getUnwrappedArrayType() {
        return this.unwrappedArrayType;
    }

    public final boolean isUnboxedInlineClassArray() {
        return this.arrayType != this.unwrappedArrayType;
    }

    @NotNull
    public final IrType getElementType() {
        return this.elementType;
    }

    private final boolean getHasSpread() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.elements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrArrayElement it = (IrArrayElement)element$iv;
                    boolean bl2 = false;
                    if (!it.isSpread()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean unaryPlus(@NotNull IrExpression $this$unaryPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
        return this.add($this$unaryPlus);
    }

    public final boolean add(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.elements.add(new IrArrayElement(expression2, false));
    }

    public final boolean addSpread(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.elements.add(new IrArrayElement(expression2, true));
    }

    @NotNull
    public final IrExpression build() {
        IrExpression array2 = this.elements.isEmpty() ? this.newArray(0) : (!this.getHasSpread() ? this.buildSimpleArray() : (this.elements.size() == 1 ? this.copyArray(((IrArrayElement)CollectionsKt.single(this.elements)).getExpression()) : this.buildComplexArray()));
        return this.coerce(array2, this.arrayType);
    }

    private final IrExpression newArray(int size) {
        return this.newArray(ExpressionHelpersKt.irInt$default(this.builder, size, null, 2, null));
    }

    private final IrExpression newArray(IrExpression size) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrSymbol irSymbol2;
        if (IrTypeUtilsKt.isBoxedArray(this.unwrappedArrayType)) {
            irSymbol2 = this.builder.getIrSymbols().getArrayOfNulls();
        } else {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.unwrappedArrayType);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            Sequence<IrConstructorSymbol> $this$single$iv = IrUtilsKt.getConstructors(irClassSymbol);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrConstructorSymbol it = (IrConstructorSymbol)element$iv;
                boolean bl = false;
                if (!(((IrConstructor)it.getOwner()).getValueParameters().size() == 1)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            irSymbol2 = single$iv;
        }
        IrSymbol arrayConstructor = irSymbol2;
        IrFunctionAccessExpression $this$newArray_u24lambda_u2d2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall(this.builder, (IrFunctionSymbol)arrayConstructor, this.unwrappedArrayType);
        boolean bl = false;
        if ($this$newArray_u24lambda_u2d2.getTypeArgumentsCount() != 0) {
            $this$newArray_u24lambda_u2d2.putTypeArgument(0, this.getElementType());
        }
        $this$newArray_u24lambda_u2d2.putValueArgument(0, size);
        return irFunctionAccessExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildSimpleArray() {
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = this.builder;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$buildSimpleArray_u24lambda_u2d5 = this_$iv$iv;
        boolean bl = false;
        IrVariable result2 = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$buildSimpleArray_u24lambda_u2d5, this.newArray(this.elements.size()), null, null, false, 14, null);
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.getUnwrappedArrayType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        Sequence<IrSimpleFunctionSymbol> $this$single$iv = IrUtilsKt.getFunctions(irClassSymbol);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"set")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol set = single$iv;
        Iterator<IrArrayElement> iterator2 = this.elements.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            void $this$buildSimpleArray_u24lambda_u2d5_u24lambda_u2d4;
            Object element$iv;
            int index2 = n++;
            IrArrayElement element = iterator2.next();
            IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildSimpleArray_u24lambda_u2d5, set);
            element$iv = irCall;
            void var21_24 = $this$buildSimpleArray_u24lambda_u2d5;
            boolean bl3 = false;
            $this$buildSimpleArray_u24lambda_u2d5_u24lambda_u2d4.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSimpleArray_u24lambda_u2d5, result2));
            $this$buildSimpleArray_u24lambda_u2d5_u24lambda_u2d4.putValueArgument(0, ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$buildSimpleArray_u24lambda_u2d5, index2, null, 2, null));
            $this$buildSimpleArray_u24lambda_u2d5_u24lambda_u2d4.putValueArgument(1, this.coerce(element.getExpression(), this.getElementType()));
            Unit unit2 = Unit.INSTANCE;
            var21_24.unaryPlus(irCall);
        }
        $this$buildSimpleArray_u24lambda_u2d5.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSimpleArray_u24lambda_u2d5, result2));
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression copyArray(IrExpression spread) {
        void $this$copyArray_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6;
        IrCall irCall;
        void $this$copyArray_u24lambda_u2d8_u24lambda_u2d7;
        IrCall irCall2;
        void this_$iv$iv;
        if (spread instanceof IrConstructorCall || spread instanceof IrFunctionAccessExpression && Intrinsics.areEqual(((IrFunctionAccessExpression)spread).getSymbol(), (Object)this.builder.getIrSymbols().getArrayOfNulls())) {
            return spread;
        }
        IrBuilderWithScope $this$irBlock_u24default$iv = this.builder;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$copyArray_u24lambda_u2d8 = this_$iv$iv;
        boolean bl = false;
        IrValueDeclaration spreadVar = spread instanceof IrGetValue ? ((IrGetValue)spread).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$copyArray_u24lambda_u2d8, spread, null, null, false, 14, null);
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.getUnwrappedArrayType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter(irClassSymbol, "size");
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        IrSimpleFunctionSymbol size = irSimpleFunctionSymbol;
        IrSimpleFunctionSymbol arrayCopyOf = this.getBuilder().getIrSymbols().getArraysCopyOfFunction((IrSimpleType)this.getUnwrappedArrayType());
        IrCall irCall3 = irCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$copyArray_u24lambda_u2d8, arrayCopyOf);
        void var17_17 = $this$copyArray_u24lambda_u2d8;
        boolean bl2 = false;
        $this$copyArray_u24lambda_u2d8_u24lambda_u2d7.putValueArgument(0, this.coerce(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$copyArray_u24lambda_u2d8, spreadVar), this.getUnwrappedArrayType()));
        IrCall irCall4 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$copyArray_u24lambda_u2d8, size);
        int n = 1;
        void var22_22 = $this$copyArray_u24lambda_u2d8_u24lambda_u2d7;
        boolean bl3 = false;
        $this$copyArray_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$copyArray_u24lambda_u2d8, spreadVar));
        Unit unit2 = Unit.INSTANCE;
        var22_22.putValueArgument(n, irCall);
        Unit unit3 = Unit.INSTANCE;
        var17_17.unaryPlus(irCall2);
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildComplexArray() {
        void $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d12;
        void this_$iv$iv;
        IrClassSymbol spreadBuilder2 = IrTypeUtilsKt.isBoxedArray(this.unwrappedArrayType) ? this.builder.getIrSymbols().getSpreadBuilder() : (IrClassSymbol)MapsKt.getValue(this.builder.getIrSymbols().getPrimitiveSpreadBuilders(), (Object)this.elementType);
        Sequence<IrSimpleFunctionSymbol> $this$single$iv = IrUtilsKt.getFunctions(spreadBuilder2);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"add")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol addElement = (IrSimpleFunctionSymbol)single$iv;
        Sequence<IrSimpleFunctionSymbol> $this$single$iv2 = IrUtilsKt.getFunctions(spreadBuilder2);
        boolean $i$f$single2 = false;
        Object single$iv2 = null;
        boolean found$iv2 = false;
        for (Object element$iv : $this$single$iv2) {
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"addSpread")) continue;
            if (found$iv2) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv2 = element$iv;
            found$iv2 = true;
        }
        if (!found$iv2) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol addSpread = (IrSimpleFunctionSymbol)single$iv2;
        Sequence<IrSimpleFunctionSymbol> $this$single$iv3 = IrUtilsKt.getFunctions(spreadBuilder2);
        boolean $i$f$single3 = false;
        Object single$iv3 = null;
        boolean found$iv3 = false;
        for (Object element$iv : $this$single$iv3) {
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"toArray")) continue;
            if (found$iv3) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv3 = element$iv;
            found$iv3 = true;
        }
        if (!found$iv3) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol toArray = single$iv3;
        IrBuilderWithScope $this$irBlock_u24default$iv = this.builder;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder it = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$buildComplexArray_u24lambda_u2d18 = this_$iv$iv;
        boolean bl = false;
        IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCallConstructor((IrBuilderWithScope)$this$buildComplexArray_u24lambda_u2d18, (IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(spreadBuilder2)), CollectionsKt.emptyList());
        IrFunctionAccessExpression irFunctionAccessExpression = irConstructorCall;
        IrStatementsBuilder irStatementsBuilder = (IrStatementsBuilder)$this$buildComplexArray_u24lambda_u2d18;
        boolean bl2 = false;
        $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d12.putValueArgument(0, ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$buildComplexArray_u24lambda_u2d18, this.elements.size(), null, 2, null));
        Unit unit2 = Unit.INSTANCE;
        IrVariable spreadBuilderVar = ExpressionHelpersKt.irTemporary$default(irStatementsBuilder, irConstructorCall, null, null, false, 14, null);
        for (IrArrayElement element : this.elements) {
            void $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d13;
            IrCall irCall = bl2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildComplexArray_u24lambda_u2d18, element.isSpread() ? addSpread : addElement);
            irStatementsBuilder = $this$buildComplexArray_u24lambda_u2d18;
            boolean bl3 = false;
            $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d13.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildComplexArray_u24lambda_u2d18, spreadBuilderVar));
            $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d13.putValueArgument(0, this.coerce(element.getExpression(), element.isSpread() ? this.getUnwrappedArrayType() : this.getElementType()));
            unit2 = Unit.INSTANCE;
            irStatementsBuilder.unaryPlus(bl2);
        }
        IrFunctionAccessExpression $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d17 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildComplexArray_u24lambda_u2d18, toArray);
        boolean bl4 = false;
        $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d17.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildComplexArray_u24lambda_u2d18, spreadBuilderVar));
        if (IrTypeUtilsKt.isBoxedArray(this.getUnwrappedArrayType())) {
            void $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d15;
            void $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16;
            IrCall irCall;
            Sequence<IrSimpleFunctionSymbol> $this$single$iv4 = IrUtilsKt.getFunctions(spreadBuilder2);
            boolean $i$f$single222 = false;
            Object single$iv4 = null;
            boolean found$iv4 = false;
            for (Object element$iv : $this$single$iv4) {
                IrSimpleFunctionSymbol it2 = (IrSimpleFunctionSymbol)element$iv;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it2.getOwner()).getName().asString(), (Object)"size")) continue;
                if (found$iv4) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv4 = element$iv;
                found$iv4 = true;
            }
            if (!found$iv4) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunctionSymbol size = single$iv4;
            IrCall $i$f$single222 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)$this$buildComplexArray_u24lambda_u2d18, this.getBuilder().getIrSymbols().getArrayOfNulls(), this.getArrayType(), 0, 0, null, 28, null);
            int n = 0;
            IrFunctionAccessExpression irFunctionAccessExpression2 = $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d17;
            boolean bl6 = false;
            $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16.putTypeArgument(0, this.getElementType());
            IrCall irCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildComplexArray_u24lambda_u2d18, size);
            IrCall irCall3 = irCall2;
            int n2 = 0;
            void var28_51 = $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16;
            boolean bl7 = false;
            $this$buildComplexArray_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d15.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildComplexArray_u24lambda_u2d18, spreadBuilderVar));
            Unit unit3 = Unit.INSTANCE;
            var28_51.putValueArgument(n2, irCall2);
            Unit unit4 = Unit.INSTANCE;
            irFunctionAccessExpression2.putValueArgument(n, irCall);
        }
        IrFunctionAccessExpression toArrayCall = irFunctionAccessExpression;
        if (IrTypeUtilsKt.isBoxedArray(this.getUnwrappedArrayType())) {
            $this$buildComplexArray_u24lambda_u2d18.unaryPlus(ExpressionHelpersKt.irImplicitCast(this.getBuilder(), toArrayCall, this.getUnwrappedArrayType()));
        } else {
            $this$buildComplexArray_u24lambda_u2d18.unaryPlus(toArrayCall);
        }
        return this_$iv$iv.doBuild();
    }

    private final IrExpression coerce(IrExpression expression2, IrType irType) {
        IrExpression irExpression;
        if (this.isUnboxedInlineClassArray()) {
            IrCall irCall;
            IrCall $this$coerce_u24lambda_u2d19 = irCall = ExpressionHelpersKt.irCall$default(this.builder, this.builder.getIrSymbols().getUnsafeCoerceIntrinsic(), irType, 0, 0, null, 28, null);
            boolean bl = false;
            $this$coerce_u24lambda_u2d19.putTypeArgument(0, expression2.getType());
            $this$coerce_u24lambda_u2d19.putTypeArgument(1, irType);
            $this$coerce_u24lambda_u2d19.putValueArgument(0, expression2);
            irExpression = irCall;
        } else {
            irExpression = expression2;
        }
        return irExpression;
    }
}

