/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_0e20598.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import org.jacoco.agent.rt.internal_0e20598.core.data.ExecutionDataWriter;
import org.jacoco.agent.rt.internal_0e20598.core.runtime.AgentOptions;
import org.jacoco.agent.rt.internal_0e20598.core.runtime.RuntimeData;
import org.jacoco.agent.rt.internal_0e20598.output.IAgentOutput;

public class FileOutput
implements IAgentOutput {
    private static final int LOCK_RETRY_COUNT = 30;
    private static final long LOCK_RETRY_WAIT_TIME_MS = 100L;
    private RuntimeData data;
    private File destFile;
    private boolean append;

    public final void startup(AgentOptions options, RuntimeData data) throws IOException {
        this.data = data;
        this.destFile = new File(options.getDestfile()).getAbsoluteFile();
        this.append = options.getAppend();
        File folder = this.destFile.getParentFile();
        if (folder != null) {
            folder.mkdirs();
        }
        this.openFile().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExecutionData(boolean reset) throws IOException {
        OutputStream output = this.openFile();
        try {
            ExecutionDataWriter writer = new ExecutionDataWriter(output);
            this.data.collect(writer, writer, reset);
        }
        finally {
            output.close();
        }
    }

    public void shutdown() throws IOException {
    }

    private OutputStream openFile() throws IOException {
        FileOutputStream file = new FileOutputStream(this.destFile, this.append);
        FileChannel fc = file.getChannel();
        int retries = 0;
        while (true) {
            try {
                fc.lock();
                return file;
            }
            catch (OverlappingFileLockException e) {
                if (retries++ > 30) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    throw new InterruptedIOException();
                }
            }
        }
    }
}

