/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.migration;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.protocol.xpack.migration.UpgradeActionRequired;

public class IndexUpgradeInfoResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField INDICES = new ParseField("indices", new String[0]);
    private static final ParseField ACTION_REQUIRED = new ParseField("action_required", new String[0]);
    private static final ConstructingObjectParser<IndexUpgradeInfoResponse, String> PARSER = new ConstructingObjectParser("IndexUpgradeInfoResponse", true, (a, c) -> {
        Map map = (Map)a[0];
        Map<String, UpgradeActionRequired> actionsRequired = map.entrySet().stream().filter(e -> {
            if (!(e.getValue() instanceof Map)) {
                return false;
            }
            Map value = (Map)e.getValue();
            return value.containsKey(ACTION_REQUIRED.getPreferredName());
        }).collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Map value = (Map)e.getValue();
            return UpgradeActionRequired.fromString((String)value.get(ACTION_REQUIRED.getPreferredName()));
        }));
        return new IndexUpgradeInfoResponse(actionsRequired);
    });
    private Map<String, UpgradeActionRequired> actions;

    public IndexUpgradeInfoResponse() {
    }

    public IndexUpgradeInfoResponse(Map<String, UpgradeActionRequired> actions) {
        this.actions = actions;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.actions = in.readMap(StreamInput::readString, UpgradeActionRequired::readFromStream);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.actions, StreamOutput::writeString, (out1, value) -> value.writeTo(out1));
    }

    public Map<String, UpgradeActionRequired> getActions() {
        return this.actions;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(INDICES.getPreferredName());
        for (Map.Entry<String, UpgradeActionRequired> entry : this.actions.entrySet()) {
            builder.startObject(entry.getKey());
            builder.field(ACTION_REQUIRED.getPreferredName(), entry.getValue().toString());
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IndexUpgradeInfoResponse response = (IndexUpgradeInfoResponse)((Object)o);
        return Objects.equals(this.actions, response.actions);
    }

    public int hashCode() {
        return Objects.hash(this.actions);
    }

    public static IndexUpgradeInfoResponse fromXContent(XContentParser parser) {
        return (IndexUpgradeInfoResponse)((Object)PARSER.apply(parser, null));
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), INDICES);
    }
}

