/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.watcher.AckWatchRequest;
import org.elasticsearch.client.watcher.ActivateWatchRequest;
import org.elasticsearch.client.watcher.StartWatchServiceRequest;
import org.elasticsearch.client.watcher.StopWatchServiceRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;

final class WatcherRequestConverters {
    private WatcherRequestConverters() {
    }

    static Request startWatchService(StartWatchServiceRequest startWatchServiceRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("_start").build();
        return new Request("POST", endpoint);
    }

    static Request stopWatchService(StopWatchServiceRequest stopWatchServiceRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("_stop").build();
        return new Request("POST", endpoint);
    }

    static Request putWatch(PutWatchRequest putWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("watch").addPathPart(putWatchRequest.getId()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request).withVersion(putWatchRequest.getVersion());
        if (!putWatchRequest.isActive()) {
            params.putParam("active", "false");
        }
        ContentType contentType = RequestConverters.createContentType(putWatchRequest.xContentType());
        BytesReference source = putWatchRequest.getSource();
        request.setEntity((HttpEntity)new ByteArrayEntity(source.toBytesRef().bytes, 0, source.length(), contentType));
        return request;
    }

    static Request deleteWatch(DeleteWatchRequest deleteWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("watch").addPathPart(deleteWatchRequest.getId()).build();
        Request request = new Request("DELETE", endpoint);
        return request;
    }

    public static Request ackWatch(AckWatchRequest ackWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("watch").addPathPart(ackWatchRequest.getWatchId()).addPathPartAsIs("_ack").addCommaSeparatedPathParts(ackWatchRequest.getActionIds()).build();
        Request request = new Request("PUT", endpoint);
        return request;
    }

    static Request activateWatch(ActivateWatchRequest activateWatchRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("watcher").addPathPartAsIs("watch").addPathPart(activateWatchRequest.getWatchId()).addPathPartAsIs("_activate").build();
        Request request = new Request("PUT", endpoint);
        return request;
    }
}

