/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.xml.AbstractXmlMojo;
import org.codehaus.mojo.xml.format.FormatFileSet;
import org.codehaus.mojo.xml.format.IndentCheckSaxHandler;
import org.codehaus.mojo.xml.format.XmlFormatViolation;
import org.codehaus.mojo.xml.format.XmlFormatViolationHandler;
import org.codehaus.plexus.util.DirectoryScanner;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

@Mojo(defaultPhase=LifecyclePhase.VALIDATE, name="check-format", threadSafe=true)
public class CheckFormatMojo
extends AbstractXmlMojo {
    @Parameter(property="xml.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="xml.failOnFormatViolation", defaultValue="true")
    private boolean failOnFormatViolation;
    @Parameter
    private List<FormatFileSet> formatFileSets = new ArrayList<FormatFileSet>();
    @Parameter(property="xml.indentSize", defaultValue="2")
    private int indentSize;
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    @Parameter(property="xml.useDefaultFormatFileSet", defaultValue="true")
    private boolean useDefaultFormatFileSet;

    public CheckFormatMojo() {
        this.saxParserFactory.setValidating(false);
    }

    private void check(File file, String encoding, XmlFormatViolationHandler violationHandler) throws MojoExecutionException {
        Reader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            IndentCheckSaxHandler handler = new IndentCheckSaxHandler(file, this.indentSize, violationHandler);
            saxParser.parse(new InputSource(in), (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not process file " + file.getAbsolutePath(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Could not close Reader for " + file.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipping()) {
            this.getLog().debug((CharSequence)"Skipping execution, as demanded by user.");
            return;
        }
        if (this.useDefaultFormatFileSet) {
            this.formatFileSets.add(FormatFileSet.getDefault(this.getBasedir(), this.encoding, this.indentSize));
        }
        if (this.formatFileSets == null || this.formatFileSets.isEmpty()) {
            return;
        }
        ViolationCollector violationCollector = new ViolationCollector();
        int processedFileCount = 0;
        for (FormatFileSet formatFileSet : this.formatFileSets) {
            String[] includedFiles;
            String effectiveEncoding = formatFileSet.getEncoding();
            if (effectiveEncoding == null) {
                effectiveEncoding = this.encoding;
            }
            for (String includedPath : includedFiles = this.scan(formatFileSet)) {
                ++processedFileCount;
                File file = new File(formatFileSet.getDirectory(), includedPath);
                this.check(file, effectiveEncoding, violationCollector);
                if (!this.getLog().isDebugEnabled() || violationCollector.hasViolations(file)) continue;
                this.getLog().debug((CharSequence)("No XML formatting violations found in file " + file.getAbsolutePath()));
            }
        }
        this.getLog().debug((CharSequence)("Checked the formatting of " + processedFileCount + " files"));
        if (this.failOnFormatViolation && violationCollector.hasViolations()) {
            throw new MojoFailureException("There are XML formatting violations. Check the above log for details.");
        }
    }

    private String[] scan(FileSet fileSet) {
        File basedir = new File(fileSet.getDirectory());
        if (!basedir.exists() || !basedir.isDirectory()) {
            return null;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        List includes = fileSet.getIncludes();
        List excludes = fileSet.getExcludes();
        if (includes != null && includes.size() > 0) {
            scanner.setIncludes(includes.toArray(new String[0]));
        }
        if (excludes != null && excludes.size() > 0) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.setBasedir(basedir);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    private class ViolationCollector
    implements XmlFormatViolationHandler {
        private final Map<String, List<XmlFormatViolation>> violations = new LinkedHashMap<String, List<XmlFormatViolation>>();

        private ViolationCollector() {
        }

        @Override
        public void handle(XmlFormatViolation violation) {
            List<XmlFormatViolation> list = this.violations.get(violation.getFile().getAbsolutePath());
            if (list == null) {
                list = new ArrayList<XmlFormatViolation>();
                this.violations.put(violation.getFile().getAbsolutePath(), list);
            }
            list.add(violation);
            if (CheckFormatMojo.this.failOnFormatViolation) {
                CheckFormatMojo.this.getLog().error((CharSequence)violation.toString());
            } else {
                CheckFormatMojo.this.getLog().warn((CharSequence)violation.toString());
            }
        }

        public boolean hasViolations() {
            return !this.violations.isEmpty();
        }

        public boolean hasViolations(File file) {
            List<XmlFormatViolation> list = this.violations.get(file.getAbsolutePath());
            return list != null && !list.isEmpty();
        }
    }
}

