/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectAssertFactory;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;

public class ProxyableListAssert<ELEMENT>
extends FactoryBasedNavigableListAssert<ProxyableListAssert<ELEMENT>, List<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> {
    public ProxyableListAssert(List<? extends ELEMENT> actual) {
        super(actual, ProxyableListAssert.class, new ObjectAssertFactory());
    }

    @Override
    protected <ELEMENT2> AbstractListAssert<?, List<? extends ELEMENT2>, ELEMENT2, ObjectAssert<ELEMENT2>> newListAssertInstance(List<? extends ELEMENT2> newActual) {
        return new ProxyableListAssert<ELEMENT2>(newActual);
    }

    protected ProxyableListAssert(Stream<? extends ELEMENT> actual) {
        this(actual == null ? null : new ListFromStream(actual));
    }

    protected ProxyableListAssert(IntStream actual) {
        this(actual == null ? null : new ListFromStream<Integer, IntStream>(actual));
    }

    protected ProxyableListAssert(LongStream actual) {
        this(actual == null ? null : new ListFromStream<Long, LongStream>(actual));
    }

    protected ProxyableListAssert(DoubleStream actual) {
        this(actual == null ? null : new ListFromStream<Double, DoubleStream>(actual));
    }

    @Override
    public ProxyableListAssert<ELEMENT> isEqualTo(Object expected) {
        if (this.actual instanceof ListFromStream && this.asListFromStream().stream == expected) {
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isEqualTo(expected);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isInstanceOf(Class<?> type) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsInstanceOf(this.info, this.asListFromStream().stream, type);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isInstanceOf((Class)type);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsInstanceOfAny(this.info, this.asListFromStream().stream, types);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isInstanceOfAny((Class[])types);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsOfAnyClassIn(this.info, this.asListFromStream().stream, types);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isOfAnyClassIn((Class[])types);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isExactlyInstanceOf(Class<?> type) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsExactlyInstanceOf(this.info, this.asListFromStream().stream, type);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isExactlyInstanceOf((Class)type);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isNotInstanceOf(Class<?> type) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsNotInstanceOf(this.info, this.asListFromStream().stream, type);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isNotInstanceOf((Class)type);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isNotInstanceOfAny(Class<?> ... types) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsNotInstanceOfAny(this.info, this.asListFromStream().stream, types);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isNotInstanceOfAny((Class[])types);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isNotOfAnyClassIn(Class<?> ... types) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsNotOfAnyClassIn(this.info, this.asListFromStream().stream, types);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isNotOfAnyClassIn((Class[])types);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isNotExactlyInstanceOf(Class<?> type) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertIsNotExactlyInstanceOf(this.info, this.asListFromStream().stream, type);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isNotExactlyInstanceOf((Class)type);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isSameAs(Object expected) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertSame(this.info, this.asListFromStream().stream, expected);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isSameAs(expected);
    }

    @Override
    public ProxyableListAssert<ELEMENT> isNotSameAs(Object expected) {
        if (this.actual instanceof ListFromStream) {
            this.objects.assertNotSame(this.info, this.asListFromStream().stream, expected);
            return (ProxyableListAssert)this.myself;
        }
        return (ProxyableListAssert)super.isNotSameAs(expected);
    }

    @Override
    public ProxyableListAssert<ELEMENT> startsWith(ELEMENT ... sequence) {
        if (!(this.actual instanceof ListFromStream)) {
            return (ProxyableListAssert)super.startsWith((Object[])sequence);
        }
        this.objects.assertNotNull(this.info, this.actual);
        CommonValidations.checkIsNotNull(sequence);
        Iterator iterator = this.asListFromStream().stream().iterator();
        if (sequence.length == 0 && iterator.hasNext()) {
            throw new AssertionError((Object)"actual is not empty");
        }
        int i = 0;
        while (iterator.hasNext() && i < sequence.length) {
            if (this.iterables.getComparisonStrategy().areEqual(iterator.next(), sequence[i++])) continue;
            throw this.actualDoesNotStartWithSequence(this.info, sequence);
        }
        if (sequence.length > i) {
            throw this.actualDoesNotStartWithSequence(this.info, sequence);
        }
        return (ProxyableListAssert)this.myself;
    }

    private AssertionError actualDoesNotStartWithSequence(AssertionInfo info, Object[] sequence) {
        return Failures.instance().failure(info, ShouldStartWith.shouldStartWith("Stream under test", sequence, this.iterables.getComparisonStrategy()));
    }

    private ListFromStream asListFromStream() {
        return (ListFromStream)this.actual;
    }

    @VisibleForTesting
    static class ListFromStream<ELEMENT, STREAM extends BaseStream<ELEMENT, STREAM>>
    extends AbstractList<ELEMENT> {
        private BaseStream<ELEMENT, STREAM> stream;
        private List<ELEMENT> list;

        public ListFromStream(BaseStream<ELEMENT, STREAM> stream) {
            this.stream = stream;
        }

        @Override
        public Stream<ELEMENT> stream() {
            this.initList();
            return this.list.stream();
        }

        private List<ELEMENT> initList() {
            if (this.list == null) {
                this.list = Lists.newArrayList(this.stream.iterator());
            }
            return this.list;
        }

        @Override
        public int size() {
            this.initList();
            return this.list.size();
        }

        @Override
        public ELEMENT get(int index) {
            this.initList();
            return this.list.get(index);
        }
    }
}

