/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.step.map;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeEdgeStep;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class TinkerMergeEdgeStep<S>
extends MergeEdgeStep<S> {
    public TinkerMergeEdgeStep(MergeEdgeStep step) {
        super(step.getTraversal(), step.isStart(), step.getSearchCreateTraversal());
        if (step.getOnMatchTraversal() != null) {
            this.addChildOption(Merge.onMatch, step.getOnMatchTraversal());
        }
        if (step.getOnCreateTraversal() != null) {
            this.addChildOption(Merge.onCreate, step.getOnCreateTraversal());
        }
        if (step.getCallbackRegistry() != null) {
            this.callbackRegistry = step.getCallbackRegistry();
        }
    }

    protected Stream<Edge> createSearchStream(Map<Object, Object> search) {
        Stream stream;
        TinkerGraph graph = (TinkerGraph)this.getTraversal().getGraph().get();
        Optional<Object> firstIndex = Optional.empty();
        if (null == search) {
            return Stream.empty();
        }
        if (search.containsKey(T.id)) {
            stream = IteratorUtils.stream(graph.edges(search.get(T.id)));
        } else {
            Set<String> indexedKeys = graph.getIndexedKeys(Edge.class);
            firstIndex = search.keySet().stream().filter(k -> k instanceof String).map(k -> (String)k).filter(indexedKeys::contains).findFirst();
            stream = firstIndex.map(s -> TinkerHelper.queryEdgeIndex(graph, s, search.get(s)).stream().map(e -> e)).orElseGet(() -> {
                if (search.containsKey(Direction.BOTH)) {
                    return IteratorUtils.stream(graph.vertices(search.get(Direction.BOTH))).flatMap(v -> IteratorUtils.stream((Iterator)v.edges(Direction.BOTH, new String[0]))).distinct();
                }
                if (search.containsKey(Direction.OUT)) {
                    return IteratorUtils.stream(graph.vertices(search.get(Direction.OUT))).flatMap(v -> IteratorUtils.stream((Iterator)v.edges(Direction.OUT, new String[0])));
                }
                if (search.containsKey(Direction.IN)) {
                    return IteratorUtils.stream(graph.vertices(search.get(Direction.IN))).flatMap(v -> IteratorUtils.stream((Iterator)v.edges(Direction.IN, new String[0])));
                }
                return IteratorUtils.stream(graph.edges(new Object[0]));
            });
        }
        Optional indexUsed = firstIndex;
        stream = stream.filter(e -> search.entrySet().stream().filter(kv -> {
            Object k = kv.getKey();
            return k != T.id && (!indexUsed.isPresent() || !((String)indexUsed.get()).equals(k));
        }).allMatch(kv -> {
            if (kv.getKey() == T.label) {
                return e.label().equals(kv.getValue());
            }
            if (kv.getKey() instanceof Direction) {
                Direction direction = (Direction)kv.getKey();
                Iterator<Vertex> found = graph.vertices(kv.getValue());
                Iterator dfound = e.vertices(direction);
                boolean matched = found.hasNext() && ((Vertex)dfound.next()).equals(found.next());
                CloseableIterator.closeIterator(found);
                CloseableIterator.closeIterator((Iterator)dfound);
                return matched;
            }
            Property vp = e.property(kv.getKey().toString());
            return vp.isPresent() && kv.getValue().equals(vp.value());
        }));
        return stream;
    }
}

