/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process;

import java.io.NotSerializableException;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinProcessRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(GremlinProcessRunner.class);

    public GremlinProcessRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
        } else {
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            eachNotifier.fireTestStarted();
            boolean ignored = false;
            try {
                this.methodBlock(method).evaluate();
            }
            catch (AssumptionViolatedException ave) {
                eachNotifier.addFailedAssumption(ave);
            }
            catch (Throwable e) {
                if (GremlinProcessRunner.validateForGraphComputer(e)) {
                    eachNotifier.fireTestIgnored();
                    logger.info(e.getMessage());
                    ignored = true;
                } else {
                    eachNotifier.addFailure(e);
                }
            }
            finally {
                if (!ignored) {
                    eachNotifier.fireTestFinished();
                }
            }
        }
    }

    private static boolean validateForGraphComputer(Throwable e) {
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (ex instanceof VerificationException || ex.getCause() instanceof VerificationException || ex.getMessage() != null && (ex.getMessage().contains("It is not possible to access more than a path element's id on GraphComputer") || ex.getMessage().contains("Local traversals may not traverse past the local star-graph on GraphComputer"))) {
                return true;
            }
            if (!(ex instanceof NotSerializableException)) continue;
            return true;
        }
        return false;
    }
}

