/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.IOUtil;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getInterpolatedPropertiesFromFile(File propfile, boolean fail, boolean useSystemProps) throws IOException, AssemblyFormattingException {
        Properties props = useSystemProps ? new Properties(System.getProperties()) : new Properties();
        if (propfile.exists()) {
            FileInputStream inStream = new FileInputStream(propfile);
            try {
                props.load(inStream);
            }
            finally {
                IOUtil.close((InputStream)inStream);
            }
        } else if (fail) {
            throw new FileNotFoundException(propfile.toString());
        }
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(props));
        Enumeration<?> n = props.propertyNames();
        while (n.hasMoreElements()) {
            String key = (String)n.nextElement();
            String value = props.getProperty(key);
            try {
                value = interpolator.interpolate(value);
            }
            catch (InterpolationException e) {
                throw new AssemblyFormattingException("Failed to interpolate property value: '" + value + "' for key: '" + key + "'. Reason: " + e.getMessage(), e);
            }
            props.setProperty(key, value);
        }
        return props;
    }
}

