/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverterFactory;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.connectors.DynamicSinkUtils;
import org.apache.flink.table.planner.delegation.ExecutorBase;
import org.apache.flink.table.planner.delegation.ParserFactory;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.expressions.PlannerTypeInferenceUtilImpl;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalLegacySink$;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraphGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.reuse.SubplanReuser$;
import org.apache.flink.table.planner.plan.utils.SameRelObjectShuttle;
import org.apache.flink.table.planner.sinks.DataStreamTableSink;
import org.apache.flink.table.planner.sinks.TableSinkUtils$;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.LegacyTypeInfoDataTypeConverter;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r%b!B\u0001\u0003\u0003\u0003y!a\u0003)mC:tWM\u001d\"bg\u0016T!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eYR\"\u0001\u000e\u000b\u0005\r1\u0011B\u0001\u000f\u001b\u0005\u001d\u0001F.\u00198oKJD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\tKb,7-\u001e;peB\u0011\u0011\u0004I\u0005\u0003Ci\u0011\u0001\"\u0012=fGV$xN\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u000511m\u001c8gS\u001e\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002*M\tYA+\u00192mK\u000e{gNZ5h\u0011!Y\u0003A!b\u0001\n\u0003a\u0013a\u00044v]\u000e$\u0018n\u001c8DCR\fGn\\4\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R!\u0001\r\u0004\u0002\u000f\r\fG/\u00197pO&\u0011!g\f\u0002\u0010\rVt7\r^5p]\u000e\u000bG/\u00197pO\"AA\u0007\u0001B\u0001B\u0003%Q&\u0001\tgk:\u001cG/[8o\u0007\u0006$\u0018\r\\8hA!Aa\u0007\u0001BC\u0002\u0013\u0005q'\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0016\u0003a\u0002\"AL\u001d\n\u0005iz#AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0005\ty\u0001\u0011\t\u0011)A\u0005q\u0005y1-\u0019;bY><W*\u00198bO\u0016\u0014\b\u0005\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0003=I7o\u0015;sK\u0006l\u0017N\\4N_\u0012,\u0007C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%a\u0002\"p_2,\u0017M\u001c\u0005\u0006\r\u0002!\taR\u0001\u0007y%t\u0017\u000e\u001e \u0015\r!S5\nT'O!\tI\u0005!D\u0001\u0003\u0011\u0015qR\t1\u0001 \u0011\u0015\u0019S\t1\u0001%\u0011\u0015YS\t1\u0001.\u0011\u00151T\t1\u00019\u0011\u0015qT\t1\u0001@\u0011%\u0001\u0006\u00011AA\u0002\u0013%\u0011+\u0001\u0004qCJ\u001cXM]\u000b\u0002%B\u0011\u0011dU\u0005\u0003)j\u0011a\u0001U1sg\u0016\u0014\b\"\u0003,\u0001\u0001\u0004\u0005\r\u0011\"\u0003X\u0003)\u0001\u0018M]:fe~#S-\u001d\u000b\u00031n\u0003\"\u0001Q-\n\u0005i\u000b%\u0001B+oSRDq\u0001X+\u0002\u0002\u0003\u0007!+A\u0002yIEB\u0011B\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002*\u0002\u000fA\f'o]3sA!9\u0001\r\u0001a\u0001\n\u0013\t\u0017AD2veJ,g\u000e\u001e#jC2,7\r^\u000b\u0002EB\u0011QeY\u0005\u0003I\u001a\u0012!bU9m\t&\fG.Z2u\u0011\u001d1\u0007\u00011A\u0005\n\u001d\f!cY;se\u0016tG\u000fR5bY\u0016\u001cGo\u0018\u0013fcR\u0011\u0001\f\u001b\u0005\b9\u0016\f\t\u00111\u0001c\u0011\u0019Q\u0007\u0001)Q\u0005E\u0006y1-\u001e:sK:$H)[1mK\u000e$\b\u0005\u0003\u0005m\u0001\t\u0007I\u0011\u0001\u0005n\u00039\u0001H.\u00198oKJ\u001cuN\u001c;fqR,\u0012A\u001c\t\u0003\u0013>L!\u0001\u001d\u0002\u0003\u001dAc\u0017M\u001c8fe\u000e{g\u000e^3yi\"1!\u000f\u0001Q\u0001\n9\fq\u0002\u001d7b]:,'oQ8oi\u0016DH\u000f\t\u0015\u0003cR\u0004\"!\u001e=\u000e\u0003YT!a\u001e\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002zm\n\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\t\u000fm\u0004!\u0019!C\u0005y\u0006a2/\u001d7FqB\u0014Hk\u001c*fq\u000e{gN^3si\u0016\u0014h)Y2u_JLX#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t\u0001B\u0001\bG\u0006d7-\u001b;f\u0013\r\t)a \u0002\u001d'FdW\t\u001f9s)>\u0014V\r_\"p]Z,'\u000f^3s\r\u0006\u001cGo\u001c:z\u0011\u001d\tI\u0001\u0001Q\u0001\nu\fQd]9m\u000bb\u0004(\u000fV8SKb\u001cuN\u001c<feR,'OR1di>\u0014\u0018\u0010\t\u0005\t\u0003\u001b\u0001A\u0011\u0001\u0005\u0002\u0010\u0005iq-\u001a;SK2\u0014U/\u001b7eKJ,\"!!\u0005\u0011\u0007y\f\u0019\"C\u0002\u0002\u0016}\u0014qB\u00127j].\u0014V\r\u001c\"vS2$WM\u001d\u0005\t\u00033\u0001A\u0011\u0001\u0005\u0002\u001c\u0005\u00112M]3bi\u00164E.\u001b8l!2\fgN\\3s+\t\ti\u0002E\u0002\u007f\u0003?I1!!\t\u0000\u0005A1E.\u001b8l!2\fgN\\3s\u00136\u0004H\u000eK\u0002\u0002\u0018QD\u0001\"a\n\u0001\t\u0003A\u0011\u0011F\u0001\u000fO\u0016$H+\u001f9f\r\u0006\u001cGo\u001c:z+\t\tY\u0003E\u0002\u007f\u0003[I1!a\f\u0000\u0005A1E.\u001b8l)f\u0004XMR1di>\u0014\u0018\u0010C\u0004\u00024\u00011\t\"!\u000e\u0002\u0019\u001d,G\u000f\u0016:bSR$UMZ:\u0016\u0005\u0005]\u0002#\u0002!\u0002:\u0005u\u0012bAA\u001e\u0003\n)\u0011I\u001d:bsB\"\u0011qHA)!\u0019\t\t%!\u0013\u0002N5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0003qY\u0006t'bAA\u0001\u0015%!\u00111JA\"\u0005-\u0011V\r\u001c+sC&$H)\u001a4\u0011\t\u0005=\u0013\u0011\u000b\u0007\u0001\t1\t\u0019&!\r\u0002\u0002\u0003\u0005)\u0011AA+\u0005\ryF%M\t\u0005\u0003/\ni\u0006E\u0002A\u00033J1!a\u0017B\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0011\u0002`%!\u0011\u0011MA\"\u0005!\u0011V\r\u001c+sC&$\bbBA3\u0001\u0019E\u0011qM\u0001\rO\u0016$x\n\u001d;j[&TXM]\u000b\u0003\u0003S\u0002B!a\u001b\u0002t5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0005paRLW.\u001b>f\u0015\r\t)\u0005B\u0005\u0005\u0003k\niGA\u0005PaRLW.\u001b>fe\"9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0014AD4fiR\u000b'\r\\3D_:4\u0017nZ\u000b\u0002I!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0015aD4fi\u001ac\u0017N\\6D_:$X\r\u001f;\u0016\u0005\u0005\r\u0005c\u0001@\u0002\u0006&\u0019\u0011qQ@\u0003\u0019\u0019c\u0017N\\6D_:$X\r\u001f;\t\u0011\u0005-\u0005\u0001\"\u0001\t\u0003\u001b\u000b!bZ3u\u000bb,7-\u00128w+\t\ty\t\u0005\u0003\u0002\u0012\u0006uUBAAJ\u0015\u0011\t)*a&\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\u0006\u0004O\u0005e%bAAN\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003?\u000b\u0019J\u0001\u000eTiJ,\u0017-\\#yK\u000e,H/[8o\u000b:4\u0018N]8o[\u0016tG\u000f\u0003\u0004\u0002$\u0002!\t!U\u0001\u0010GJ,\u0017\r^3OK^\u0004\u0016M]:fe\"9\u0011q\u0015\u0001\u0005B\u0005%\u0016!C4fiB\u000b'o]3s)\u0005\u0011\u0006bBAW\u0001\u0011\u0005\u0013qV\u0001\niJ\fgn\u001d7bi\u0016$B!!-\u0002\\B1\u00111WA]\u0003{k!!!.\u000b\u0007\u0005]F#\u0001\u0003vi&d\u0017\u0002BA^\u0003k\u0013A\u0001T5tiB\"\u0011qXAh!\u0019\t\t-!3\u0002N6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-A\u0002eC\u001eT!a\n\u0005\n\t\u0005-\u00171\u0019\u0002\u000f)J\fgn\u001d4pe6\fG/[8o!\u0011\ty%a4\u0005\u0019\u0005E\u00171VA\u0001\u0002\u0003\u0015\t!a5\u0003\u0007}##'\u0005\u0003\u0002X\u0005U\u0007c\u0001!\u0002X&\u0019\u0011\u0011\\!\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002^\u0006-\u0006\u0019AAp\u0003Aiw\u000eZ5gs>\u0003XM]1uS>t7\u000f\u0005\u0004\u00024\u0006e\u0016\u0011\u001d\t\u0005\u0003G\fI/\u0004\u0002\u0002f*\u0019\u0011q\u001d\u0004\u0002\u0015=\u0004XM]1uS>t7/\u0003\u0003\u0002l\u0006\u0015(aD'pI&4\u0017p\u00149fe\u0006$\u0018n\u001c8\t\u0011\u0005=\b\u0001\"\u0001\t\u0003c\fa\u0002\u001e:b]Nd\u0017\r^3U_J+G\u000e\u0006\u0003\u0002t\u0006}\b\u0003BA{\u0003wl!!a>\u000b\t\u0005e\u0018qI\u0001\u0004e\u0016d\u0017\u0002BA\u007f\u0003o\u0014qAU3m\u001d>$W\r\u0003\u0005\u0003\u0002\u00055\b\u0019AAq\u0003=iw\u000eZ5gs>\u0003XM]1uS>t\u0007fAAwi\"A\u0011q\u000e\u0001\u0005\u0002!\u00119\u0001\u0006\u0003\u0003\n\t\u0005\u0002C\u0002B\u0006\u00057\t\u0019P\u0004\u0003\u0003\u000e\t]a\u0002\u0002B\b\u0005+i!A!\u0005\u000b\u0007\tMa\"\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0019!\u0011D!\u0002\u000fA\f7m[1hK&!!Q\u0004B\u0010\u0005\r\u0019V-\u001d\u0006\u0004\u00053\t\u0005\u0002\u0003B\u0012\u0005\u000b\u0001\rA!\u0003\u0002\u0011I,GNT8eKND3A!\u0002u\u0011!\ty\u0007\u0001C\u0001\u0011\t%B\u0003BAz\u0005WA\u0001B!\f\u0003(\u0001\u0007\u00111_\u0001\be\u0016dgj\u001c3fQ\r\u00119\u0003\u001e\u0005\t\u0005g\u0001A\u0011\u0001\u0005\u00036\u0005ABO]1og2\fG/\u001a+p\u000bb,7MT8eK\u001e\u0013\u0018\r\u001d5\u0015\t\t]\"q\t\t\u0005\u0005s\u0011\u0019%\u0004\u0002\u0003<)!!Q\bB \u0003\u0011)\u00070Z2\u000b\t\t\u0005\u0013\u0011O\u0001\u0006]>$Wm]\u0005\u0005\u0005\u000b\u0012YDA\u0007Fq\u0016\u001cgj\u001c3f\u000fJ\f\u0007\u000f\u001b\u0005\t\u0005\u0013\u0012\t\u00041\u0001\u0003\n\u0005\tr\u000e\u001d;j[&TX\r\u001a*fY:{G-Z:)\u0007\tEB\u000fC\u0004\u0003P\u00011\tB!\u0015\u00025\u001d,G/\u0012=fG:{G-Z$sCBD\u0007K]8dKN\u001cxN]:\u0016\u0005\tM\u0003C\u0002B\u0006\u00057\u0011)\u0006\u0005\u0003\u0003X\tuSB\u0001B-\u0015\u0011\u0011YFa\u000f\u0002\u0013A\u0014xnY3tg>\u0014\u0018\u0002\u0002B0\u00053\u0012a#\u0012=fG:{G-Z$sCBD\u0007K]8dKN\u001cxN\u001d\u0005\b\u0005G\u0002a\u0011\u0003B3\u0003=!(/\u00198tY\u0006$X\rV8QY\u0006tG\u0003\u0002B4\u0005g\u0002b!a-\u0002:\n%\u0004\u0007\u0002B6\u0005_\u0002b!!1\u0002J\n5\u0004\u0003BA(\u0005_\"AB!\u001d\u0003b\u0005\u0005\t\u0011!B\u0001\u0003'\u00141a\u0018\u00135\u0011!\u0011)H!\u0019A\u0002\t]\u0012!C3yK\u000e<%/\u00199i\u0011\u001d\u0011I\b\u0001C\u0005\u0005w\nAbZ3u)\u0006\u0014G.Z*j].$bA! \u0003\u0010\ne\u0005#\u0002!\u0003\u0000\t\r\u0015b\u0001BA\u0003\n1q\n\u001d;j_:\u0004r\u0001\u0011BC\u0005\u0013\u000b).C\u0002\u0003\b\u0006\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001\u0018\u0003\f&\u0019!QR\u0018\u0003)I+7o\u001c7wK\u0012\u001c\u0015\r^1m_\u001e$\u0016M\u00197f\u0011!\u0011\tJa\u001eA\u0002\tM\u0015\u0001E8cU\u0016\u001cG/\u00133f]RLg-[3s!\rq#QS\u0005\u0004\u0005/{#\u0001E(cU\u0016\u001cG/\u00133f]RLg-[3s\u0011!\u0011YJa\u001eA\u0002\tu\u0015A\u00043z]\u0006l\u0017nY(qi&|gn\u001d\t\t\u0005?\u00139L!0\u0003>:!!\u0011\u0015B[\u001d\u0011\u0011\u0019Ka-\u000f\t\t\u0015&\u0011\u0017\b\u0005\u0005O\u0013yK\u0004\u0003\u0003*\n5f\u0002\u0002B\b\u0005WK\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\r\u0011I\u0002B\u0005\u0005\u0005s\u0013YL\u0001\u0003K\u001b\u0006\u0004(b\u0001B\r\tA!!q\u0018Bd\u001d\u0011\u0011\tMa1\u0011\u0007\t=\u0011)C\u0002\u0003F\u0006\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002Be\u0005\u0017\u0014aa\u0015;sS:<'b\u0001Bc\u0003\"9!q\u001a\u0001\u0005\n\tE\u0017\u0001G5t\u0019\u0016<\u0017mY=D_:tWm\u0019;pe>\u0003H/[8ogR9qHa5\u0003V\n}\u0007\u0002\u0003BI\u0005\u001b\u0004\rAa%\t\u0011\t]'Q\u001aa\u0001\u00053\fAbY1uC2|w\rV1cY\u0016\u00042A\fBn\u0013\r\u0011in\f\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\b\u0005C\u0014i\r1\u0001@\u0003-I7\u000fV3na>\u0014\u0018M]=\t\u000f\t\u0015\b\u0001\"\u0011\u0003h\u0006Yq-\u001a;Kg>t\u0007\u000b\\1o)\u0011\u0011iL!;\t\u0011\u0005u'1\u001da\u0001\u0003?DqA!<\u0001\t\u0003\u0012y/A\tue\u0006t7\u000f\\1uK*\u001bxN\u001c)mC:$BA!=\u0003~B1\u00111WA]\u0005g\u0004DA!>\u0003zB1\u0011\u0011YAe\u0005o\u0004B!a\u0014\u0003z\u0012a!1 Bv\u0003\u0003\u0005\tQ!\u0001\u0002T\n\u0019q\fJ\u001b\t\u0011\t}(1\u001ea\u0001\u0005{\u000b\u0001B[:p]Bc\u0017M\u001c\u0005\b\u0007\u0007\u0001A\u0011CB\u0003\u0003I\u0019'/Z1uKN+'\u000fZ3D_:$X\r\u001f;\u0016\u0005\r\u001d\u0001\u0003BB\u0005\u0007\u001fi!aa\u0003\u000b\t\r5!1H\u0001\u0006g\u0016\u0014H-Z\u0005\u0005\u0007#\u0019YA\u0001\u0007TKJ$WmQ8oi\u0016DH\u000fC\u0004\u0004\u0016\u0001!Iaa\u0006\u0002\u001d\u001d,Go\u00117bgNdu.\u00193feV\u00111\u0011\u0004\t\u0004#\rm\u0011bAB\u000f%\tY1\t\\1tg2{\u0017\rZ3s\u0011\u001d\u0019\t\u0003\u0001C\t\u0007G\t\u0001E^1mS\u0012\fG/Z!oI>3XM\u001d:jI\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\t\u0001\fC\u0004\u0004(\u0001!\tba\t\u0002;\rdW-\u00198va&sG/\u001a:oC2\u001cuN\u001c4jOV\u0014\u0018\r^5p]N\u0004")
public abstract class PlannerBase
implements Planner {
    private final Executor executor;
    private final TableConfig config;
    private final FunctionCatalog functionCatalog;
    private final CatalogManager catalogManager;
    private final boolean isStreamingMode;
    private Parser parser;
    private SqlDialect currentDialect;
    @VisibleForTesting
    private final PlannerContext plannerContext;
    private final SqlExprToRexConverterFactory sqlExprToRexConverterFactory;

    public FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    private Parser parser() {
        return this.parser;
    }

    private void parser_$eq(Parser x$1) {
        this.parser = x$1;
    }

    private SqlDialect currentDialect() {
        return this.currentDialect;
    }

    private void currentDialect_$eq(SqlDialect x$1) {
        this.currentDialect = x$1;
    }

    public PlannerContext plannerContext() {
        return this.plannerContext;
    }

    private SqlExprToRexConverterFactory sqlExprToRexConverterFactory() {
        return this.sqlExprToRexConverterFactory;
    }

    public FlinkRelBuilder getRelBuilder() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createRelBuilder(currentCatalogName, currentDatabase);
    }

    @VisibleForTesting
    public FlinkPlannerImpl createFlinkPlanner() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createFlinkPlanner(currentCatalogName, currentDatabase);
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.plannerContext().getTypeFactory();
    }

    public abstract RelTraitDef<? extends RelTrait>[] getTraitDefs();

    public abstract Optimizer getOptimizer();

    public TableConfig getTableConfig() {
        return this.config;
    }

    public FlinkContext getFlinkContext() {
        return this.plannerContext().getFlinkContext();
    }

    public StreamExecutionEnvironment getExecEnv() {
        return ((ExecutorBase)this.executor).getExecutionEnvironment();
    }

    public Parser createNewParser() {
        scala.collection.immutable.Map parserProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TableConfigOptions.TABLE_SQL_DIALECT.key()), (Object)this.getTableConfig().getSqlDialect().name().toLowerCase())}));
        return ((ParserFactory)ComponentFactoryService.find(ParserFactory.class, (java.util.Map)JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)parserProps))).create(this.catalogManager(), this.plannerContext());
    }

    public Parser getParser() {
        block1: {
            block0: {
                if (this.parser() == null) break block0;
                SqlDialect sqlDialect = this.getTableConfig().getSqlDialect();
                SqlDialect sqlDialect2 = this.currentDialect();
                if (!(sqlDialect == null ? sqlDialect2 != null : !sqlDialect.equals(sqlDialect2))) break block1;
            }
            this.parser_$eq(this.createNewParser());
            this.currentDialect_$eq(this.getTableConfig().getSqlDialect());
        }
        return this.parser();
    }

    public List<Transformation<?>> translate(List<ModifyOperation> modifyOperations) {
        this.validateAndOverrideConfiguration();
        if (modifyOperations.isEmpty()) {
            return JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)List$.MODULE$.empty());
        }
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(modifyOperations).map((Function1 & Serializable & scala.Serializable)modifyOperation -> this.translateToRel((ModifyOperation)modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        return transformations;
    }

    @VisibleForTesting
    public RelNode translateToRel(ModifyOperation modifyOperation) {
        RelNode relNode;
        DataTypeFactory dataTypeFactory = this.catalogManager().getDataTypeFactory();
        ModifyOperation modifyOperation2 = modifyOperation;
        if (modifyOperation2 instanceof UnregisteredSinkModifyOperation) {
            UnregisteredSinkModifyOperation unregisteredSinkModifyOperation = (UnregisteredSinkModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(unregisteredSinkModifyOperation.getChild()).build();
            TableSchema sinkSchema = unregisteredSinkModifyOperation.getSink().getTableSchema();
            RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, this.catalogManager().getSchemaResolver().resolve(sinkSchema.toSchema()), null, dataTypeFactory, this.getTypeFactory());
            relNode = LogicalLegacySink$.MODULE$.create(query, unregisteredSinkModifyOperation.getSink(), "UnregisteredSink", (CatalogTable)ConnectorCatalogTable.sink((TableSink)unregisteredSinkModifyOperation.getSink(), (!this.isStreamingMode ? 1 : 0) != 0), LogicalLegacySink$.MODULE$.create$default$5());
        } else if (modifyOperation2 instanceof CollectModifyOperation) {
            CollectModifyOperation collectModifyOperation = (CollectModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            relNode = DynamicSinkUtils.convertCollectToRel(this.getRelBuilder(), input, collectModifyOperation);
        } else if (modifyOperation2 instanceof CatalogSinkModifyOperation) {
            RelNode sinkRel;
            java.util.Map dynamicOptions;
            CatalogSinkModifyOperation catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            ObjectIdentifier identifier = catalogSinkModifyOperation.getTableIdentifier();
            Option option = this.getTableSink(identifier, dynamicOptions = catalogSinkModifyOperation.getDynamicOptions()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    ResolvedCatalogTable table = (ResolvedCatalogTable)tuple2._1();
                    Object sink = tuple2._2();
                    if (sink instanceof TableSink) {
                        TableSink tableSink = (TableSink)sink;
                        RowType queryLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType());
                        TableSinkUtils$.MODULE$.validateLogicalPhysicalTypesCompatible((CatalogTable)table, tableSink, queryLogicalType);
                        TableSinkUtils$.MODULE$.validateTableSink(catalogSinkModifyOperation, identifier, tableSink, (Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(table.getPartitionKeys()));
                        RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, table.getResolvedSchema(), catalogSinkModifyOperation.getTableIdentifier(), dataTypeFactory, this.getTypeFactory());
                        ArrayList<RelHint> hints = new ArrayList<RelHint>();
                        Object object = !dynamicOptions.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)hints.add(RelHint.builder("OPTIONS").hintOptions(dynamicOptions).build())) : BoxedUnit.UNIT;
                        return LogicalLegacySink$.MODULE$.create(query, hints, tableSink, identifier.toString(), (CatalogTable)table, (scala.collection.immutable.Map<String, String>)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(catalogSinkModifyOperation.getStaticPartitions()).toMap(Predef$.MODULE$.$conforms()));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                ResolvedCatalogTable table = (ResolvedCatalogTable)tuple2._1();
                Object sink = tuple2._2();
                if (!(sink instanceof DynamicTableSink)) throw new MatchError((Object)tuple2);
                DynamicTableSink dynamicTableSink = (DynamicTableSink)sink;
                return DynamicSinkUtils.convertSinkToRel(this.getRelBuilder(), input, catalogSinkModifyOperation, dynamicTableSink, table);
            });
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new TableException(new StringBuilder(21).append("Sink ").append(catalogSinkModifyOperation.getTableIdentifier()).append(" does not exists").toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            RelNode relNode2 = sinkRel = (RelNode)some.value();
            relNode = relNode2;
        } else if (modifyOperation2 instanceof ExternalModifyOperation) {
            ExternalModifyOperation externalModifyOperation = (ExternalModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            relNode = DynamicSinkUtils.convertExternalToRel(this.getRelBuilder(), input, externalModifyOperation);
        } else if (modifyOperation2 instanceof OutputConversionModifyOperation) {
            Tuple2.mcZZ.sp sp2;
            OutputConversionModifyOperation outputConversionModifyOperation = (OutputConversionModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(outputConversionModifyOperation.getChild()).build();
            OutputConversionModifyOperation.UpdateMode updateMode = outputConversionModifyOperation.getUpdateMode();
            if (OutputConversionModifyOperation.UpdateMode.RETRACT.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(true, true);
            } else if (OutputConversionModifyOperation.UpdateMode.APPEND.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, false);
            } else if (OutputConversionModifyOperation.UpdateMode.UPSERT.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, true);
            } else {
                throw new MatchError((Object)updateMode);
            }
            Tuple2.mcZZ.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            boolean needUpdateBefore = sp3._1$mcZ$sp();
            boolean withChangeFlag = sp3._2$mcZ$sp();
            Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(needUpdateBefore, withChangeFlag);
            Tuple2.mcZZ.sp sp5 = sp4;
            boolean needUpdateBefore2 = sp5._1$mcZ$sp();
            boolean withChangeFlag2 = sp5._2$mcZ$sp();
            TypeInformation typeInfo = LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo((DataType)outputConversionModifyOperation.getType());
            RowType inputLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType());
            TableSchema sinkPhysicalSchema = TableSinkUtils$.MODULE$.inferSinkPhysicalSchema(outputConversionModifyOperation.getType(), inputLogicalType, withChangeFlag2);
            RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, this.catalogManager().getSchemaResolver().resolve(sinkPhysicalSchema.toSchema()), null, dataTypeFactory, this.getTypeFactory());
            DataStreamTableSink tableSink = new DataStreamTableSink(FlinkTypeFactory$.MODULE$.toTableSchema(query.getRowType()), typeInfo, needUpdateBefore2, withChangeFlag2);
            relNode = LogicalLegacySink$.MODULE$.create(query, tableSink, "DataStreamTableSink", (CatalogTable)ConnectorCatalogTable.sink(tableSink, (!this.isStreamingMode ? 1 : 0) != 0), LogicalLegacySink$.MODULE$.create$default$5());
        } else {
            throw new TableException(new StringBuilder(29).append("Unsupported ModifyOperation: ").append(modifyOperation).toString());
        }
        return relNode;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public Seq<RelNode> optimize(Seq<RelNode> relNodes) {
        void var2_2;
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize(relNodes);
        Predef$.MODULE$.require(optimizedRelNodes.size() == relNodes.size());
        return var2_2;
    }

    @VisibleForTesting
    public RelNode optimize(RelNode relNode) {
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize((Seq<RelNode>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{relNode}))));
        Predef$.MODULE$.require(optimizedRelNodes.size() == 1);
        return (RelNode)optimizedRelNodes.head();
    }

    @VisibleForTesting
    public ExecNodeGraph translateToExecNodeGraph(Seq<RelNode> optimizedRelNodes) {
        Seq nonPhysicalRel = (Seq)optimizedRelNodes.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PlannerBase.$anonfun$translateToExecNodeGraph$1(x$2)));
        if (nonPhysicalRel.nonEmpty()) {
            throw new TableException(new StringBuilder(54).append("The expected optimized plan is FlinkPhysicalRel plan, ").append(new StringBuilder(21).append("actual plan is ").append(nonPhysicalRel.head().getClass().getSimpleName()).append(" plan.").toString()).toString());
        }
        Predef$.MODULE$.require(optimizedRelNodes.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PlannerBase.$anonfun$translateToExecNodeGraph$2(x$3))));
        SameRelObjectShuttle shuttle = new SameRelObjectShuttle();
        Seq relsWithoutSameObj = (Seq)optimizedRelNodes.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.accept(shuttle), Seq$.MODULE$.canBuildFrom());
        Seq<RelNode> reusedPlan = SubplanReuser$.MODULE$.reuseDuplicatedSubplan((Seq<RelNode>)relsWithoutSameObj, this.config);
        ExecNodeGraphGenerator generator = new ExecNodeGraphGenerator();
        ExecNodeGraph execGraph = generator.generate(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)reusedPlan.map((Function1 & Serializable & scala.Serializable)x$5 -> (FlinkPhysicalRel)x$5, Seq$.MODULE$.canBuildFrom())));
        ProcessorContext context = new ProcessorContext(this);
        Seq<ExecNodeGraphProcessor> processors = this.getExecNodeGraphProcessors();
        return (ExecNodeGraph)processors.foldLeft((Object)execGraph, (Function2 & Serializable & scala.Serializable)(graph, processor) -> processor.process((ExecNodeGraph)graph, context));
    }

    public abstract Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors();

    public abstract List<Transformation<?>> translateToPlan(ExecNodeGraph var1);

    private Option<Tuple2<ResolvedCatalogTable, Object>> getTableSink(ObjectIdentifier objectIdentifier, java.util.Map<String, String> dynamicOptions) {
        None$ none$;
        Option optionalLookupResult = JavaScalaConversionUtil$.MODULE$.toScala(this.catalogManager().getTable(objectIdentifier));
        if (optionalLookupResult.isEmpty()) {
            return None$.MODULE$;
        }
        CatalogManager.TableLookupResult lookupResult = (CatalogManager.TableLookupResult)optionalLookupResult.get();
        CatalogBaseTable catalogBaseTable = lookupResult.getTable();
        if (catalogBaseTable instanceof ConnectorCatalogTable) {
            None$ none$2;
            ConnectorCatalogTable connectorCatalogTable = (ConnectorCatalogTable)catalogBaseTable;
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)lookupResult.getResolvedTable();
            Option option = JavaScalaConversionUtil$.MODULE$.toScala(connectorCatalogTable.getTableSink());
            if (option instanceof Some) {
                Some some = (Some)option;
                TableSink sink = (TableSink)some.value();
                none$2 = new Some((Object)new Tuple2((Object)resolvedTable, (Object)sink));
            } else if (None$.MODULE$.equals(option)) {
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            none$ = none$2;
        } else if (catalogBaseTable instanceof CatalogTable) {
            Option option;
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)lookupResult.getResolvedTable();
            ResolvedCatalogTable tableToFind = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(dynamicOptions).nonEmpty() ? resolvedTable.copy(FlinkHints.mergeTableOptions(dynamicOptions, resolvedTable.getOptions())) : resolvedTable;
            Optional catalog = this.catalogManager().getCatalog(objectIdentifier.getCatalogName());
            boolean isTemporary = lookupResult.isTemporary();
            if (this.isLegacyConnectorOptions(objectIdentifier, resolvedTable.getOrigin(), isTemporary)) {
                TableSink tableSink = TableFactoryUtil.findAndCreateTableSink((Catalog)catalog.orElse(null), (ObjectIdentifier)objectIdentifier, (CatalogTable)tableToFind.getOrigin(), (ReadableConfig)this.getTableConfig().getConfiguration(), (boolean)this.isStreamingMode, (boolean)isTemporary);
                option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, (Object)tableSink));
            } else {
                DynamicTableSink tableSink = FactoryUtil.createTableSink((Catalog)catalog.orElse(null), (ObjectIdentifier)objectIdentifier, (ResolvedCatalogTable)tableToFind, (ReadableConfig)this.getTableConfig().getConfiguration(), (ClassLoader)this.getClassLoader(), (boolean)isTemporary);
                option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, (Object)tableSink));
            }
            none$ = option;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private boolean isLegacyConnectorOptions(ObjectIdentifier objectIdentifier, CatalogTable catalogTable, boolean isTemporary) {
        boolean bl;
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(catalogTable.getOptions());
        if (properties.containsKey("connector.type")) {
            bl = true;
        } else {
            Optional catalog = this.catalogManager().getCatalog(objectIdentifier.getCatalogName());
            try {
                TableFactoryUtil.findAndCreateTableSink((Catalog)catalog.orElse(null), (ObjectIdentifier)objectIdentifier, (CatalogTable)catalogTable, (ReadableConfig)this.getTableConfig().getConfiguration(), (boolean)this.isStreamingMode, (boolean)isTemporary);
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        return bl;
    }

    public String getJsonPlan(List<ModifyOperation> modifyOperations) {
        if (!this.isStreamingMode) {
            throw new TableException("Only streaming mode is supported now.");
        }
        this.validateAndOverrideConfiguration();
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(modifyOperations).map((Function1 & Serializable & scala.Serializable)modifyOperation -> this.translateToRel((ModifyOperation)modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        String jsonPlan = ExecNodeGraph.createJsonPlan(execGraph, this.createSerdeContext());
        this.cleanupInternalConfigurations();
        return jsonPlan;
    }

    /*
     * WARNING - void declaration
     */
    public List<Transformation<?>> translateJsonPlan(String jsonPlan) {
        void var3_3;
        if (!this.isStreamingMode) {
            throw new TableException("Only streaming mode is supported now.");
        }
        this.validateAndOverrideConfiguration();
        ExecNodeGraph execGraph = ExecNodeGraph.createExecNodeGraph(jsonPlan, this.createSerdeContext());
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        return var3_3;
    }

    public SerdeContext createSerdeContext() {
        FlinkPlannerImpl planner = this.createFlinkPlanner();
        return new SerdeContext((FlinkContext)planner.config().getContext(), this.getClassLoader(), this.plannerContext().getTypeFactory(), planner.operatorTable());
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void validateAndOverrideConfiguration() {
        block1: {
            Configuration configuration = this.config.getConfiguration();
            if (!((Enum)configuration.get(TableConfigOptions.TABLE_PLANNER)).equals(PlannerType.BLINK)) {
                throw new IllegalArgumentException("Mismatch between configured planner and actual planner. Currently, the 'table.planner' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
            }
            Long epochTime = Predef$.MODULE$.long2Long(System.currentTimeMillis());
            configuration.set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)epochTime);
            Long localTime = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(epochTime) + (long)TimeZone.getTimeZone(this.config.getLocalTimeZone()).getOffset(Predef$.MODULE$.Long2long(epochTime)));
            configuration.set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)localTime);
            this.getExecEnv().configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
            int defaultParallelism = this.getTableConfig().getConfiguration().getInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM);
            if (defaultParallelism <= 0) break block1;
            this.getExecEnv().getConfig().setParallelism(defaultParallelism);
        }
    }

    public void cleanupInternalConfigurations() {
        Configuration configuration = this.config.getConfiguration();
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME);
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME);
    }

    public static final /* synthetic */ boolean $anonfun$translateToExecNodeGraph$1(RelNode x$2) {
        return x$2 instanceof FlinkPhysicalRel;
    }

    public static final /* synthetic */ boolean $anonfun$translateToExecNodeGraph$2(RelNode x$3) {
        return x$3 instanceof FlinkPhysicalRel;
    }

    public PlannerBase(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager, boolean isStreamingMode) {
        this.executor = executor;
        this.config = config;
        this.functionCatalog = functionCatalog;
        this.catalogManager = catalogManager;
        this.isStreamingMode = isStreamingMode;
        functionCatalog.setPlannerTypeInferenceUtil(PlannerTypeInferenceUtilImpl.INSTANCE);
        this.currentDialect = this.getTableConfig().getSqlDialect();
        this.plannerContext = new PlannerContext(config, functionCatalog, catalogManager, CalciteSchemaBuilder.asRootSchema(new CatalogManagerCalciteSchema(catalogManager, isStreamingMode)), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTraitDefs())).toList()));
        this.sqlExprToRexConverterFactory = this.plannerContext().getSqlExprToRexConverterFactory();
    }
}

