/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.connectors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.connector.source.abilities.SupportsSourceWatermark;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.connectors.TransformationScanProvider;
import org.apache.flink.table.runtime.operators.source.InputConversionOperator;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;

@Internal
final class ExternalDynamicSource<E>
implements ScanTableSource,
SupportsReadingMetadata,
SupportsSourceWatermark {
    private static final String ROWTIME_METADATA_KEY = "rowtime";
    private static final DataType ROWTIME_METADATA_DATA_TYPE = (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull();
    private final ObjectIdentifier identifier;
    private final DataStream<E> dataStream;
    private final DataType physicalDataType;
    private final boolean isTopLevelRecord;
    private final ChangelogMode changelogMode;
    private boolean produceRowtimeMetadata;
    private boolean propagateWatermark;

    ExternalDynamicSource(ObjectIdentifier identifier, DataStream<E> dataStream, DataType physicalDataType, boolean isTopLevelRecord, ChangelogMode changelogMode) {
        this.identifier = identifier;
        this.dataStream = dataStream;
        this.physicalDataType = physicalDataType;
        this.isTopLevelRecord = isTopLevelRecord;
        this.changelogMode = changelogMode;
    }

    public DynamicTableSource copy() {
        ExternalDynamicSource<E> copy = new ExternalDynamicSource<E>(this.identifier, this.dataStream, this.physicalDataType, this.isTopLevelRecord, this.changelogMode);
        copy.produceRowtimeMetadata = this.produceRowtimeMetadata;
        copy.propagateWatermark = this.propagateWatermark;
        return copy;
    }

    public String asSummaryString() {
        return this.generateOperatorName();
    }

    public ChangelogMode getChangelogMode() {
        return this.changelogMode;
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        DynamicTableSource.DataStructureConverter physicalConverter = runtimeProviderContext.createDataStructureConverter(this.physicalDataType);
        Transformation externalTransformation = this.dataStream.getTransformation();
        OneInputTransformation conversionTransformation = new OneInputTransformation(externalTransformation, this.generateOperatorName(), (OneInputStreamOperator)new InputConversionOperator(physicalConverter, !this.isTopLevelRecord, this.produceRowtimeMetadata, this.propagateWatermark, this.changelogMode.containsOnly(RowKind.INSERT)), null, externalTransformation.getParallelism());
        return TransformationScanProvider.of((Transformation<RowData>)conversionTransformation, false);
    }

    private String generateOperatorName() {
        return String.format("DataSteamToTable(stream=%s, type=%s, rowtime=%s, watermark=%s)", this.identifier.asSummaryString(), this.physicalDataType.toString(), this.produceRowtimeMetadata, this.propagateWatermark);
    }

    public Map<String, DataType> listReadableMetadata() {
        return Collections.singletonMap(ROWTIME_METADATA_KEY, ROWTIME_METADATA_DATA_TYPE);
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.produceRowtimeMetadata = metadataKeys.contains(ROWTIME_METADATA_KEY);
    }

    public void applySourceWatermark() {
        this.propagateWatermark = true;
    }
}

