/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.brave;

import brave.http.HttpTracing;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.tracing.brave.AbstractBraveProvider;

public abstract class AbstractBraveInterceptor
extends AbstractBraveProvider
implements PhaseInterceptor<Message> {
    private final String phase;

    protected AbstractBraveInterceptor(String phase, HttpTracing brave) {
        super(brave);
        this.phase = phase;
    }

    public Set<String> getAfter() {
        return Collections.emptySet();
    }

    public Set<String> getBefore() {
        return Collections.emptySet();
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPhase() {
        return this.phase;
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    public void handleFault(Message message) {
    }

    protected static class ParsedMessage {
        private Message message;

        ParsedMessage(Message message) {
            this.message = message;
        }

        String safeGet(String key) {
            if (!this.message.containsKey((Object)key)) {
                return null;
            }
            Object value = this.message.get((Object)key);
            return value instanceof String ? value.toString() : null;
        }

        URI getUri() {
            return AbstractBraveInterceptor.getUri((Message)this.message);
        }

        Message getEffectiveMessage() {
            boolean isRequestor = MessageUtils.isRequestor((Message)this.message);
            boolean isOutbound = MessageUtils.isOutbound((Message)this.message);
            if (isRequestor) {
                return isOutbound ? this.message : this.message.getExchange().getOutMessage();
            }
            return isOutbound ? this.message.getExchange().getInMessage() : this.message;
        }

        Map<String, List<String>> getHeaders() {
            Map headers = CastUtils.cast((Map)((Map)this.message.get((Object)Message.PROTOCOL_HEADERS)));
            if (headers == null) {
                return Collections.emptyMap();
            }
            return headers;
        }

        void addHeader(String key, String value) {
            HashMap<String, List<String>> headers = CastUtils.cast((Map)((Map)this.message.get((Object)Message.PROTOCOL_HEADERS)));
            if (headers == null) {
                headers = new HashMap<String, List<String>>();
                this.message.put((Object)Message.PROTOCOL_HEADERS, headers);
            }
            headers.put(key, Arrays.asList(value));
        }

        String getHttpMethod() {
            ParsedMessage eMessage = new ParsedMessage(this.getEffectiveMessage());
            return eMessage.safeGet("org.apache.cxf.request.method");
        }
    }
}

