/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.Parameter;

public class MBeanInfoHelper {
    public static MBeanOperationInfo[] getMBeanOperationsInfo(Class mbeanInterface) {
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (Method method : mbeanInterface.getMethods()) {
            if (MBeanInfoHelper.isGetterMethod(method) || MBeanInfoHelper.isSetterMethod(method) || MBeanInfoHelper.isIsBooleanMethod(method)) continue;
            operations.add(MBeanInfoHelper.getOperationInfo(method));
        }
        return operations.toArray(new MBeanOperationInfo[operations.size()]);
    }

    public static MBeanAttributeInfo[] getMBeanAttributesInfo(Class mbeanInterface) {
        ArrayList<MBeanAttributeInfo> tempAttributes = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanAttributeInfo> finalAttributes = new ArrayList<MBeanAttributeInfo>();
        ArrayList<String> alreadyAdded = new ArrayList<String>();
        for (Method method : mbeanInterface.getMethods()) {
            if (!MBeanInfoHelper.isGetterMethod(method) && !MBeanInfoHelper.isSetterMethod(method) && !MBeanInfoHelper.isIsBooleanMethod(method)) continue;
            tempAttributes.add(MBeanInfoHelper.getAttributeInfo(method));
        }
        Iterator iterator = tempAttributes.iterator();
        while (iterator.hasNext()) {
            MBeanAttributeInfo info1;
            MBeanAttributeInfo infoToCopy = info1 = (MBeanAttributeInfo)iterator.next();
            for (MBeanAttributeInfo info2 : tempAttributes) {
                if (!info1.getName().equals(info2.getName()) || info1.equals(info2)) continue;
                infoToCopy = new MBeanAttributeInfo(info1.getName(), info1.getType().equals("void") ? info2.getType() : info1.getType(), info1.getDescription(), info1.isReadable() || info2.isReadable(), info1.isWritable() || info2.isWritable(), info1.isIs() || info2.isIs());
            }
            if (alreadyAdded.contains(infoToCopy.getName())) continue;
            finalAttributes.add(infoToCopy);
            alreadyAdded.add(infoToCopy.getName());
        }
        return finalAttributes.toArray(new MBeanAttributeInfo[finalAttributes.size()]);
    }

    private static boolean isGetterMethod(Method method) {
        return !method.getName().equals("get") && method.getName().startsWith("get") && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isSetterMethod(Method method) {
        return !method.getName().equals("set") && method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isIsBooleanMethod(Method method) {
        return !method.getName().equals("is") && method.getName().startsWith("is") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Boolean.TYPE);
    }

    private static MBeanOperationInfo getOperationInfo(Method operation) {
        MBeanOperationInfo info = null;
        Class<?> returnType = operation.getReturnType();
        MBeanParameterInfo[] paramsInfo = MBeanInfoHelper.getParametersInfo(operation.getParameterAnnotations(), operation.getParameterTypes());
        String description = operation.getName();
        int impact = 3;
        if (operation.getAnnotation(Operation.class) != null) {
            description = operation.getAnnotation(Operation.class).desc();
            impact = operation.getAnnotation(Operation.class).impact();
        }
        info = new MBeanOperationInfo(operation.getName(), description, paramsInfo, returnType.getName(), impact);
        return info;
    }

    private static MBeanAttributeInfo getAttributeInfo(Method operation) {
        String description = "N/A";
        if (operation.getAnnotation(Attribute.class) != null) {
            description = operation.getAnnotation(Attribute.class).desc();
        }
        MBeanAttributeInfo info = new MBeanAttributeInfo(MBeanInfoHelper.getAttributeName(operation), operation.getReturnType().getName(), description, MBeanInfoHelper.isGetterMethod(operation) || MBeanInfoHelper.isIsBooleanMethod(operation), MBeanInfoHelper.isSetterMethod(operation), MBeanInfoHelper.isIsBooleanMethod(operation));
        return info;
    }

    private static String getAttributeName(Method operation) {
        String name = operation.getName();
        if (MBeanInfoHelper.isGetterMethod(operation) || MBeanInfoHelper.isSetterMethod(operation)) {
            name = operation.getName().substring(3);
        } else if (MBeanInfoHelper.isIsBooleanMethod(operation)) {
            name = operation.getName().substring(2);
        }
        return name;
    }

    private static MBeanParameterInfo[] getParametersInfo(Annotation[][] params, Class<?>[] paramTypes) {
        MBeanParameterInfo[] paramsInfo = new MBeanParameterInfo[params.length];
        for (int i = 0; i < params.length; ++i) {
            MBeanParameterInfo paramInfo = null;
            String type = paramTypes[i].getName();
            for (Annotation anno : params[i]) {
                if (!Parameter.class.isInstance(anno)) continue;
                String name = ((Parameter)Parameter.class.cast(anno)).name();
                String description = ((Parameter)Parameter.class.cast(anno)).desc();
                paramInfo = new MBeanParameterInfo(name, type, description);
            }
            if (paramInfo == null) {
                paramInfo = new MBeanParameterInfo("p " + (i + 1), type, "parameter " + (i + 1));
            }
            paramsInfo[i] = paramInfo;
        }
        return paramsInfo;
    }
}

