/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.text.MessageFormat;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class SignalEventSubscriptionEntity
extends EventSubscriptionEntity {
    private static final long serialVersionUID = 1L;
    private static final String CONFIGURATION_TEMPLATE = "'{'\"scope\":\"{0}\"'}'";

    public SignalEventSubscriptionEntity(ExecutionEntity executionEntity) {
        super(executionEntity);
        this.eventType = "signal";
    }

    public SignalEventSubscriptionEntity() {
        this.eventType = "signal";
    }

    @Override
    public void setConfiguration(String configuration) {
        this.configuration = MessageFormat.format(CONFIGURATION_TEMPLATE, configuration);
    }

    public boolean isProcessInstanceScoped() {
        String scope = this.extractScopeFormConfiguration();
        return scope != null && "processInstance".equals(scope);
    }

    public boolean isGlobalScoped() {
        String scope = this.extractScopeFormConfiguration();
        return scope == null || "global".equals(scope);
    }

    protected String extractScopeFormConfiguration() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.substring(10, this.configuration.length() - 2);
    }
}

