/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Arrays;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.plugins.RxJavaPlugins;

public final class OperatorOnErrorReturn<T>
implements Observable.Operator<T, T> {
    final Func1<Throwable, ? extends T> resultFunction;

    public OperatorOnErrorReturn(Func1<Throwable, ? extends T> resultFunction) {
        this.resultFunction = resultFunction;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Subscriber parent = new Subscriber<T>(){
            private boolean done = false;

            @Override
            public void onNext(T t) {
                if (this.done) {
                    return;
                }
                child.onNext(t);
            }

            @Override
            public void onError(Throwable e) {
                if (this.done) {
                    Exceptions.throwIfFatal(e);
                    return;
                }
                this.done = true;
                try {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                    this.unsubscribe();
                    Object result = OperatorOnErrorReturn.this.resultFunction.call(e);
                    child.onNext(result);
                }
                catch (Throwable x) {
                    child.onError(new CompositeException(Arrays.asList(e, x)));
                    return;
                }
                child.onCompleted();
            }

            @Override
            public void onCompleted() {
                if (this.done) {
                    return;
                }
                this.done = true;
                child.onCompleted();
            }

            @Override
            public void setProducer(final Producer producer) {
                child.setProducer(new Producer(){

                    @Override
                    public void request(long n) {
                        producer.request(n);
                    }
                });
            }
        };
        child.add(parent);
        return parent;
    }
}

