/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.async.utils;

import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BeanDefinitionUtil {
    public static boolean isFromConfigurationSource(BeanDefinition beanDefinition) {
        String beanDefinitionClassName = beanDefinition.getClass().getCanonicalName();
        return beanDefinitionClassName.startsWith("org.springframework.context.annotation.ConfigurationClassBeanDefinitionReader");
    }

    public static Class<?> resolveBeanClassType(BeanDefinition beanDefinition) {
        Class clazz = null;
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            String className;
            if (BeanDefinitionUtil.isFromConfigurationSource(beanDefinition)) {
                MethodMetadata methodMetadata = ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata();
                assert (methodMetadata != null);
                className = methodMetadata.getReturnTypeName();
            } else {
                AnnotationMetadata annotationMetadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata();
                className = annotationMetadata.getClassName();
            }
            try {
                clazz = StringUtils.isEmpty((Object)className) ? null : ClassUtils.forName((String)className, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && beanDefinition instanceof RootBeanDefinition) {
            clazz = ((RootBeanDefinition)beanDefinition).getTargetType();
        }
        if (BeanDefinitionUtil.isCglibProxyClass(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    private static boolean isCglibProxyClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.getName().contains("$$");
    }
}

