/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.async.processor;

import io.github.linyimin0812.async.bean.AsyncInitBeanFinder;
import io.github.linyimin0812.async.config.AsyncBeanProperties;
import io.github.linyimin0812.async.config.AsyncConfig;
import io.github.linyimin0812.async.executor.AsyncTaskExecutor;
import io.github.linyimin0812.profiler.common.logger.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.PriorityOrdered;

public class AsyncProxyBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
PriorityOrdered {
    private final Logger logger = LogFactory.getStartupLogger();
    private final ThreadLocal<Object> originBeanThreadLocal = new ThreadLocal();
    private ConfigurableListableBeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!this.beanFactory.containsBeanDefinition(beanName)) {
            return bean;
        }
        String methodName = AsyncInitBeanFinder.getAsyncInitMethodName(beanName, this.beanFactory.getBeanDefinition(beanName));
        if (methodName == null) {
            return bean;
        }
        this.originBeanThreadLocal.set(bean);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(bean.getClass());
        proxyFactory.setProxyTargetClass(true);
        AsyncInitializeBeanMethodInvoker invoker = new AsyncInitializeBeanMethodInvoker(bean, beanName, methodName);
        proxyFactory.addAdvice((Advice)invoker);
        return proxyFactory.getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        try {
            Object object = this.originBeanThreadLocal.get() != null ? this.originBeanThreadLocal.get() : bean;
            return object;
        }
        finally {
            this.originBeanThreadLocal.remove();
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        AsyncBeanProperties properties = AsyncBeanProperties.parse(applicationContext.getEnvironment());
        AsyncConfig.getInstance().setAsyncBeanProperties(properties);
    }

    class AsyncInitializeBeanMethodInvoker
    implements MethodInterceptor {
        private final Object targetObject;
        private final String beanName;
        private final String asyncMethodName;

        public AsyncInitializeBeanMethodInvoker(Object targetObject, String beanName, String asyncMethodName) {
            this.targetObject = targetObject;
            this.beanName = beanName;
            this.asyncMethodName = asyncMethodName;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (AsyncTaskExecutor.isFinished()) {
                return invocation.getMethod().invoke(this.targetObject, invocation.getArguments());
            }
            Method method = invocation.getMethod();
            String methodName = method.getName();
            if (this.asyncMethodName.equals(methodName)) {
                AsyncProxyBeanPostProcessor.this.logger.info("async-init-bean, beanName: {}, async init method: {}", (Object)this.beanName, (Object)this.asyncMethodName);
                AsyncTaskExecutor.submitTask(() -> {
                    try {
                        long start = System.currentTimeMillis();
                        invocation.getMethod().invoke(this.targetObject, invocation.getArguments());
                        AsyncProxyBeanPostProcessor.this.logger.info("async-init-bean, beanName: {}, async init method: {}, cost: {}", new Object[]{this.beanName, this.asyncMethodName, System.currentTimeMillis() - start});
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
                return null;
            }
            return invocation.getMethod().invoke(this.targetObject, invocation.getArguments());
        }
    }
}

