/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.async.processor;

import io.github.linyimin0812.async.config.AsyncConfig;
import io.github.linyimin0812.profiler.common.logger.LogFactory;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class AsyncBeanPriorityLoadPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware {
    private final Logger logger = LogFactory.getStartupLogger();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!AsyncConfig.getInstance().getAsyncBeanProperties().isBeanPriorityLoadEnable()) {
            return;
        }
        List<String> asyncBeans = AsyncConfig.getInstance().getAsyncBeanProperties().getBeanNames();
        for (String beanName : asyncBeans) {
            if (beanFactory instanceof DefaultListableBeanFactory && !((DefaultListableBeanFactory)beanFactory).containsBeanDefinition(beanName)) {
                this.logger.warn("BeanDefinition of bean {} is not exist.", (Object)beanName);
                continue;
            }
            this.logger.info("async init bean: {}", (Object)beanName);
            beanFactory.getBean(beanName);
        }
    }
}

