/*
 * Decompiled with CFR 0.152.
 */
package com.upyun;

import com.upyun.Base64Coder;
import com.upyun.Result;
import com.upyun.UpException;
import com.upyun.UpYunUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncProcessHandler {
    public static String HOST = "http://p0.api.upyun.com";
    protected final String AUTHORIZATION = "Authorization";
    protected final String DATE = "Date";
    protected String bucketName = null;
    protected String userName = null;
    protected String password = null;
    protected int timeout = 30000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected Result process(Map<String, Object> params) throws IOException, UpException {
        params.put("tasks", URLEncoder.encode(Base64Coder.encodeString(params.get("tasks").toString()), "UTF-8"));
        InputStream is = null;
        URL url = new URL(HOST + "/pretreatment/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String date = this.getGMTDate();
        conn.setConnectTimeout(this.timeout);
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("User-Agent", "upyun-java-sdk/4.0.1");
        conn.setRequestProperty("Date", date);
        conn.setRequestProperty("Authorization", this.sign("POST", "/pretreatment/", date, params));
        conn.connect();
        OutputStream os = conn.getOutputStream();
        for (Map.Entry<String, Object> mapping : params.entrySet()) {
            os.write((mapping.getKey() + "=" + mapping.getValue().toString() + "&").getBytes("UTF-8"));
        }
        Result result = this.getResp(conn);
        if (os != null) {
            os.close();
        }
        if (is != null) {
            is.close();
        }
        if (conn != null) {
            conn.disconnect();
        }
        return result;
    }

    public AsyncProcessHandler(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = UpYunUtils.md5(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result getResp(HttpURLConnection conn) throws IOException {
        Result result = new Result();
        StringBuilder text = new StringBuilder();
        InputStream is = null;
        InputStreamReader sr = null;
        BufferedReader br = null;
        int code = conn.getResponseCode();
        result.setCode(code);
        try {
            is = code >= 400 ? conn.getErrorStream() : conn.getInputStream();
            sr = new InputStreamReader(is);
            br = new BufferedReader(sr);
            char[] chars = new char[4096];
            int length = 0;
            while ((length = br.read(chars)) != -1) {
                text.append(chars, 0, length);
            }
        }
        finally {
            if (br != null) {
                br.close();
                br = null;
            }
            if (sr != null) {
                sr.close();
                sr = null;
            }
            if (is != null) {
                is.close();
                is = null;
            }
        }
        if (code == 200) {
            result.setSucceed(true);
        } else {
            result.setSucceed(false);
        }
        result.setMsg(text.toString());
        return result;
    }

    protected String sign(String method, String URI2, String date, Map<String, Object> params) throws UpException {
        StringBuilder sb = new StringBuilder();
        String sp = "&";
        sb.append(method);
        sb.append(sp);
        sb.append(URI2);
        sb.append(sp);
        sb.append(date);
        String raw = sb.toString().trim();
        byte[] hmac = null;
        try {
            hmac = UpYunUtils.calculateRFC2104HMACRaw(this.password, raw);
        }
        catch (Exception e) {
            throw new UpException("calculate SHA1 wrong.");
        }
        if (hmac != null) {
            return "UpYun " + this.userName + ":" + Base64Coder.encodeLines(hmac).trim();
        }
        return null;
    }

    protected String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }

    public String[] getTaskId(String raw) {
        JSONArray array = new JSONArray(raw);
        String[] ids = new String[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            ids[i] = (String)array.get(i);
        }
        return ids;
    }
}

