/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Container {
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Names")
    private ImmutableList<String> names;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="ImageID")
    private String imageId;
    @JsonProperty(value="Command")
    private String command;
    @JsonProperty(value="Created")
    private Long created;
    @JsonProperty(value="Status")
    private String status;
    @JsonProperty(value="Ports")
    private ImmutableList<PortMapping> ports;
    @JsonProperty(value="Labels")
    private ImmutableMap<String, String> labels;
    @JsonProperty(value="SizeRw")
    private Long sizeRw;
    @JsonProperty(value="SizeRootFs")
    private Long sizeRootFs;

    public String portsAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.ports != null) {
            for (PortMapping port : this.ports) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (port.ip != null) {
                    sb.append(port.ip).append(":");
                }
                if (port.publicPort > 0) {
                    sb.append(port.privatePort).append("->").append(port.publicPort);
                } else {
                    sb.append(port.privatePort);
                }
                sb.append("/").append(port.type);
            }
        }
        return sb.toString();
    }

    public String id() {
        return this.id;
    }

    public List<String> names() {
        return this.names;
    }

    public String image() {
        return this.image;
    }

    public String command() {
        return this.command;
    }

    public Long created() {
        return this.created;
    }

    public String status() {
        return this.status;
    }

    public List<PortMapping> ports() {
        return this.ports;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public Long sizeRw() {
        return this.sizeRw;
    }

    public Long sizeRootFs() {
        return this.sizeRootFs;
    }

    public String imageId() {
        return this.imageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container that = (Container)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.names, that.names) && Objects.equals(this.image, that.image) && Objects.equals(this.imageId, that.imageId) && Objects.equals(this.command, that.command) && Objects.equals(this.created, that.created) && Objects.equals(this.status, that.status) && Objects.equals(this.ports, that.ports) && Objects.equals(this.labels, that.labels) && Objects.equals(this.sizeRw, that.sizeRw) && Objects.equals(this.sizeRootFs, that.sizeRootFs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.names, this.image, this.command, this.created, this.status, this.ports, this.labels, this.sizeRw, this.sizeRootFs, this.imageId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("image", (Object)this.image).add("command", (Object)this.command).add("created", (Object)this.created).add("status", (Object)this.status).add("ports", this.ports).add("labels", this.labels).add("sizeRw", (Object)this.sizeRw).add("sizeRootFs", (Object)this.sizeRootFs).add("imageId", (Object)this.imageId).toString();
    }

    public static class PortMapping {
        @JsonProperty(value="PrivatePort")
        private int privatePort;
        @JsonProperty(value="PublicPort")
        private int publicPort;
        @JsonProperty(value="Type")
        private String type;
        @JsonProperty(value="IP")
        private String ip;

        public String getIp() {
            return this.ip;
        }

        public int getPrivatePort() {
            return this.privatePort;
        }

        public int getPublicPort() {
            return this.publicPort;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PortMapping that = (PortMapping)o;
            return Objects.equals(this.privatePort, that.privatePort) && Objects.equals(this.publicPort, that.publicPort) && Objects.equals(this.type, that.type) && Objects.equals(this.ip, that.ip);
        }

        public int hashCode() {
            return Objects.hash(this.privatePort, this.publicPort, this.type, this.ip);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("privatePort", this.privatePort).add("publicPort", this.publicPort).add("type", (Object)this.type).add("ip", (Object)this.ip).toString();
        }
    }
}

