/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lowcode.auth.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JwtUtil {
    private String secret;

    public JwtUtil(String secret) {
        this.secret = secret;
    }

    public String createToken(Map<String, String> claimMap, long expireTime) {
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("alg", "HS256");
        headMap.put("typ", "JWT");
        Date dateTime = new Date();
        JWTCreator.Builder jwt = JWT.create().withHeader(headMap);
        jwt.withIssuedAt(dateTime).withExpiresAt(new Date(dateTime.getTime() + expireTime * 1000L));
        if (this.isMapEmpty(claimMap)) {
            return jwt.sign(Algorithm.HMAC256((byte[])this.secret.getBytes()));
        }
        claimMap.forEach((arg_0, arg_1) -> ((JWTCreator.Builder)jwt).withClaim(arg_0, arg_1));
        String token = jwt.sign(Algorithm.HMAC256((byte[])this.secret.getBytes()));
        return token;
    }

    private boolean isMapEmpty(Map<String, String> claimMap) {
        return claimMap == null || claimMap.isEmpty();
    }

    public Map<String, Claim> decryptToken(String token) throws JWTVerificationException {
        JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((byte[])this.secret.getBytes())).acceptIssuedAt(300L).build();
        DecodedJWT decodedJWT = verifier.verify(token);
        return decodedJWT.getClaims();
    }
}

