/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lowcode.auth.util;

import com.auth0.jwt.interfaces.Claim;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netease.lowcode.auth.domain.LCAPUser;
import com.netease.lowcode.auth.util.JwtUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AuthManagerHelper {
    public static String SECRET;
    public static final String AUTH_TOKEN_NAME = "authorization";
    public static final String AUTH_LIBRARY_COOKIE_NAME = "_auth_lib_t";
    public static final String JWT_KEY_USERID = "UserId";
    public static final String JWT_KEY_USERNAME = "UserName";
    public static final String JWT_KEY_EXTRA_INFO = "ExtraInfo";
    public static final Long EXPIRE_TIME;
    private static ObjectMapper objectMapper;

    public static void removeToken() {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        Cookie[] cookies = request.getCookies();
        if (Objects.nonNull(cookies) && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(AUTH_TOKEN_NAME) && !cookies[i].getName().equals(AUTH_LIBRARY_COOKIE_NAME)) continue;
                cookies[i].setMaxAge(0);
                cookies[i].setPath("/");
                response.addCookie(cookies[i]);
            }
        }
    }

    public static void createToken(LCAPUser lcapUser) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(JWT_KEY_USERID, lcapUser.userId);
        map.put(JWT_KEY_USERNAME, lcapUser.userName);
        if (Objects.nonNull(lcapUser.extensionInfos) && !lcapUser.extensionInfos.isEmpty()) {
            try {
                map.put(JWT_KEY_EXTRA_INFO, objectMapper.writeValueAsString(lcapUser.extensionInfos));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        Cookie cookie = new Cookie(AUTH_TOKEN_NAME, new JwtUtil(SECRET).createToken(map, EXPIRE_TIME));
        cookie.setPath("/");
        cookie.setMaxAge(Math.toIntExact(EXPIRE_TIME));
        cookie.setHttpOnly(true);
        cookie.setSecure(false);
        Cookie cookieCsrf = new Cookie(AUTH_LIBRARY_COOKIE_NAME, UUID.randomUUID().toString().replace("-", ""));
        cookieCsrf.setPath("/");
        cookieCsrf.setMaxAge(Math.toIntExact(EXPIRE_TIME + 1000L));
        cookieCsrf.setHttpOnly(true);
        cookieCsrf.setSecure(false);
        response.addCookie(cookie);
        response.addCookie(cookieCsrf);
    }

    public static LCAPUser parseToken() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        return AuthManagerHelper.parseToken(request);
    }

    public static LCAPUser parseToken(HttpServletRequest request) {
        boolean isValidToken;
        Cookie[] cookies = request.getCookies();
        if (Objects.nonNull(cookies) && cookies.length > 0 && (isValidToken = Arrays.stream(cookies).anyMatch(cookie -> cookie.getName().equals(AUTH_LIBRARY_COOKIE_NAME)))) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(AUTH_TOKEN_NAME)) continue;
                Map<String, Claim> claimMap = new JwtUtil(SECRET).decryptToken(cookies[i].getValue());
                Iterator<String> keys = claimMap.keySet().iterator();
                LCAPUser lcapUser = new LCAPUser();
                while (keys.hasNext()) {
                    String key = keys.next();
                    if (JWT_KEY_USERID.equals(key)) {
                        lcapUser.userId = claimMap.get(key).asString();
                    }
                    if (JWT_KEY_USERNAME.equals(key)) {
                        lcapUser.userName = claimMap.get(key).asString();
                    }
                    if (!JWT_KEY_EXTRA_INFO.equals(key)) continue;
                    try {
                        lcapUser.extensionInfos = (Map)objectMapper.readValue(claimMap.get(key).asString(), (TypeReference)new TypeReference<HashMap<String, String>>(){});
                    }
                    catch (JsonProcessingException jsonProcessingException) {}
                }
                return lcapUser;
            }
        }
        return null;
    }

    public static boolean containsSessionKey(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (Objects.nonNull(cookies) && cookies.length > 0) {
            return Arrays.stream(cookies).anyMatch(cookie -> cookie.getName().equals(AUTH_LIBRARY_COOKIE_NAME));
        }
        return false;
    }

    static {
        EXPIRE_TIME = 86400L;
        objectMapper = new ObjectMapper();
    }
}

