/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lowcode.auth.api.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netease.lowcode.auth.api.auth.LCAPAuthService;
import com.netease.lowcode.auth.domain.LCAPUser;
import com.netease.lowcode.auth.util.AuthManagerHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultLCAPAuthService
implements LCAPAuthService {
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Map<String, String> getSession(HttpServletRequest request) throws Exception {
        HashMap<String, String> sessionMap = new HashMap<String, String>();
        LCAPUser lcapUser = AuthManagerHelper.parseToken(request);
        if (Objects.nonNull(lcapUser)) {
            sessionMap.put("UserId", lcapUser.userId);
            sessionMap.put("UserName", lcapUser.userName);
            sessionMap.put("ExtraInfo", this.objectMapper.writeValueAsString((Object)lcapUser));
        }
        return sessionMap;
    }

    @Override
    public boolean match(HttpServletRequest request) {
        return AuthManagerHelper.containsSessionKey(request);
    }

    @Override
    public boolean isRemoteUser() {
        return true;
    }

    @Override
    public void clearSession(HttpServletRequest request, HttpServletResponse response) {
        AuthManagerHelper.removeToken();
    }

    @Override
    public String type() {
        return "SYSTEM";
    }
}

