/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.transform;

import com.netease.cloud.ServiceException;
import com.netease.cloud.transform.Unmarshaller;
import com.netease.cloud.util.XpathUtils;
import java.lang.reflect.Constructor;
import org.w3c.dom.Node;

public class LegacyErrorUnmarshaller
implements Unmarshaller<ServiceException, Node> {
    private final Class<? extends ServiceException> exceptionClass;

    public LegacyErrorUnmarshaller() {
        this(ServiceException.class);
    }

    protected LegacyErrorUnmarshaller(Class<? extends ServiceException> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    @Override
    public ServiceException unmarshall(Node in) throws Exception {
        String errorCode = this.parseErrorCode(in);
        String message = XpathUtils.asString("Response/Errors/Error/Message", in);
        String requestId = XpathUtils.asString("Response/RequestID", in);
        String errorType = XpathUtils.asString("Response/Errors/Error/Type", in);
        Constructor<? extends ServiceException> constructor = this.exceptionClass.getConstructor(String.class);
        ServiceException ase = constructor.newInstance(message);
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        if (errorType == null) {
            ase.setErrorType(ServiceException.ErrorType.Unknown);
        } else if (errorType.equalsIgnoreCase("server")) {
            ase.setErrorType(ServiceException.ErrorType.Service);
        } else if (errorType.equalsIgnoreCase("client")) {
            ase.setErrorType(ServiceException.ErrorType.Client);
        }
        return ase;
    }

    public String parseErrorCode(Node in) throws Exception {
        return XpathUtils.asString("Response/Errors/Error/Code", in);
    }

    public String getErrorPropertyPath(String property) {
        return "Response/Errors/Error/" + property;
    }
}

