/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.transfer.internal;

import com.netease.cloud.ClientException;
import com.netease.cloud.ServiceException;
import com.netease.cloud.services.nos.model.ProgressListener;
import com.netease.cloud.services.nos.transfer.Transfer;
import com.netease.cloud.services.nos.transfer.TransferProgress;
import com.netease.cloud.services.nos.transfer.internal.ProgressListenerChain;
import com.netease.cloud.services.nos.transfer.internal.TransferMonitor;
import com.netease.cloud.services.nos.transfer.internal.TransferStateChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractTransfer
implements Transfer {
    private volatile Transfer.TransferState state = Transfer.TransferState.Waiting;
    protected TransferMonitor monitor;
    private final TransferProgress transferProgress;
    private final String description;
    protected ProgressListenerChain progressListenerChain;
    protected final Collection<TransferStateChangeListener> stateChangeListeners = new LinkedList<TransferStateChangeListener>();

    AbstractTransfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain) {
        this(description, transferProgress, progressListenerChain, null);
    }

    AbstractTransfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, TransferStateChangeListener stateChangeListener) {
        this.description = description;
        this.progressListenerChain = progressListenerChain;
        this.transferProgress = transferProgress;
        this.addStateChangeListener(stateChangeListener);
    }

    @Override
    public synchronized boolean isDone() {
        return this.state == Transfer.TransferState.Failed || this.state == Transfer.TransferState.Completed || this.state == Transfer.TransferState.Canceled;
    }

    @Override
    public void waitForCompletion() throws ClientException, ServiceException, InterruptedException {
        try {
            Object result = null;
            while (!this.monitor.isDone() || result == null) {
                Future<?> f = this.monitor.getFuture();
                result = f.get();
            }
        }
        catch (ExecutionException e) {
            this.rethrowExecutionException(e);
        }
    }

    @Override
    public ClientException waitForException() throws InterruptedException {
        try {
            while (!this.monitor.isDone()) {
                this.monitor.getFuture().get();
            }
            this.monitor.getFuture().get();
            return null;
        }
        catch (ExecutionException e) {
            return this.unwrapExecutionException(e);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized Transfer.TransferState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(Transfer.TransferState state) {
        AbstractTransfer abstractTransfer = this;
        synchronized (abstractTransfer) {
            this.state = state;
        }
        for (TransferStateChangeListener listener : this.stateChangeListeners) {
            listener.transferStateChanged(this, state);
        }
    }

    @Override
    public synchronized void addProgressListener(ProgressListener listener) {
        this.progressListenerChain.addProgressListener(listener);
    }

    @Override
    public synchronized void removeProgressListener(ProgressListener listener) {
        this.progressListenerChain.removeProgressListener(listener);
    }

    public synchronized void addStateChangeListener(TransferStateChangeListener listener) {
        if (listener != null) {
            this.stateChangeListeners.add(listener);
        }
    }

    public synchronized void removeStateChangeListener(TransferStateChangeListener listener) {
        if (listener != null) {
            this.stateChangeListeners.remove(listener);
        }
    }

    @Override
    public TransferProgress getProgress() {
        return this.transferProgress;
    }

    public void setMonitor(TransferMonitor monitor) {
        this.monitor = monitor;
    }

    public TransferMonitor getMonitor() {
        return this.monitor;
    }

    protected void rethrowExecutionException(ExecutionException e) {
        throw this.unwrapExecutionException(e);
    }

    protected ClientException unwrapExecutionException(ExecutionException e) {
        Throwable t = e.getCause();
        if (t instanceof ClientException) {
            return (ClientException)t;
        }
        return new ClientException("Unable to complete transfer: " + t.getMessage(), t);
    }
}

