/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.tools;

import com.netease.cloud.ClientException;
import com.netease.cloud.ServiceException;
import com.netease.cloud.WebServiceRequest;
import com.netease.cloud.auth.BasicCredentials;
import com.netease.cloud.services.nos.NosClient;
import com.netease.cloud.services.nos.internal.Constants;
import com.netease.cloud.services.nos.model.AbortMultipartUploadRequest;
import com.netease.cloud.services.nos.model.Bucket;
import com.netease.cloud.services.nos.model.CannedAccessControlList;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CreateBucketRequest;
import com.netease.cloud.services.nos.model.GetObjectMetadataRequest;
import com.netease.cloud.services.nos.model.GetObjectRequest;
import com.netease.cloud.services.nos.model.HeadBucketRequest;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadRequest;
import com.netease.cloud.services.nos.model.ListMultipartUploadsRequest;
import com.netease.cloud.services.nos.model.ListObjectsRequest;
import com.netease.cloud.services.nos.model.MultipartUpload;
import com.netease.cloud.services.nos.model.MultipartUploadListing;
import com.netease.cloud.services.nos.model.NOSObject;
import com.netease.cloud.services.nos.model.NOSObjectInputStream;
import com.netease.cloud.services.nos.model.NOSObjectSummary;
import com.netease.cloud.services.nos.model.ObjectListing;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.services.nos.model.PartETag;
import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.model.SetBucketAclRequest;
import com.netease.cloud.services.nos.model.StorageClass;
import com.netease.cloud.services.nos.model.UploadPartRequest;
import com.netease.cloud.services.nos.model.UploadPartResult;
import com.netease.cloud.services.nos.transfer.TransferManager;
import com.netease.cloud.services.nos.transfer.TransferManagerConfiguration;
import com.netease.cloud.services.nos.transfer.Upload;
import com.netease.cloud.services.nos.transfer.model.UploadResult;
import com.netease.cloud.util.Md5Utils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class noscmd {
    private TransferManager tx;
    private NosClient nosClient;
    private static Map<String, Integer> commands;
    private static Map<String, Integer> createBucketcommands;
    private static Logger log;
    private static final String credential = "/conf/credentials.properties";
    private static final String hostConfig = "/conf/host.properties";
    private static final String log4jConfig = "/conf/log4j.properties";
    private static long TransferManagerUPloadPartSize;
    private Set<String> localLessSet = new HashSet<String>();
    private Set<String> nosLessSet = new HashSet<String>();
    private String localString;
    private StorageClass storageClass;
    private String logID;
    private String logSeq;
    private AtomicLong seqID = new AtomicLong(1L);

    public noscmd() {
        String path = noscmd.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        String parent = new File(new File(path).getParent()).getParent();
        PropertyConfigurator.configure((String)(parent + log4jConfig));
        FileInputStream hostConfIn = null;
        try {
            hostConfIn = new FileInputStream(new File(parent + hostConfig));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Properties hostProperties = new Properties();
        try {
            hostProperties.load(hostConfIn);
        }
        catch (IOException e) {
            log.fatal((Object)"Errors occur when load the file 'conf/host.properties'.");
            System.out.println(-1);
            System.exit(-1);
        }
        Constants.NOS_HOST_NAME = hostProperties.getProperty("host");
        String storageClassString = hostProperties.getProperty("storageclass");
        String TXUploadPartSize = hostProperties.getProperty("TransferManagerUPloadPartSize");
        if (TXUploadPartSize != null) {
            try {
                TransferManagerUPloadPartSize = Long.valueOf(TXUploadPartSize) * 1024L * 1024L;
                if (TransferManagerUPloadPartSize > 0x6400000L) {
                    log.info((Object)"the maxmum Upload partSize is 100MB");
                }
                log.info((Object)("TransferManagerUPloadPartSize is :" + TransferManagerUPloadPartSize));
            }
            catch (NumberFormatException e) {
                log.info((Object)"the TransferManagerUPloadPartSize is illegal, we we will the defalut 5MB");
            }
        }
        if (storageClassString != null) {
            this.storageClass = StorageClass.fromValue(storageClassString);
        }
        FileInputStream keyConfIn = null;
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Failed to find the path of the jar.");
            System.out.println(-1);
            System.exit(-1);
        }
        try {
            keyConfIn = new FileInputStream(new File(parent + credential));
        }
        catch (FileNotFoundException e1) {
            log.error((Object)e1.getMessage());
            System.out.println(-1);
            System.exit(-1);
        }
        Properties keyProperties = new Properties();
        try {
            keyProperties.load(keyConfIn);
        }
        catch (IOException e) {
            log.fatal((Object)"Errors occur when load the file 'conf/credentials.properties'.");
            System.out.println(-1);
            System.exit(-1);
        }
        String accessKey = keyProperties.getProperty("accessKey");
        String secretKey = keyProperties.getProperty("secretKey");
        if (accessKey == null || secretKey == null || secretKey.length() == 0 || accessKey.length() == 0) {
            log.error((Object)"Please check your accessKey and secret key in file 'conf/credentials.properties'.");
            System.out.println(-1);
            System.exit(-1);
        }
        this.tx = new TransferManager(new BasicCredentials(accessKey, secretKey));
        TransferManagerConfiguration configuration = new TransferManagerConfiguration();
        configuration.setMinimumUploadPartSize(TransferManagerUPloadPartSize);
        this.tx.setConfiguration(configuration);
        this.nosClient = (NosClient)this.tx.getNosClient();
    }

    public static void usage() {
        System.out.println("Usage: noscmd options [args...]");
        System.out.println("where options include:");
        System.out.println("\tCommand \tArguments\t\t\tDescribe");
        System.out.println("\t-create\t\t<bucket>\t\t\tcreate a bucket.");
        System.out.println("\t\t\t--location<location>\t\tspecify the location(HZ,BJ,GZ) of this bucket.");
        System.out.println("\t\t\t--dedup<dedup>\t\t\tspecify the dedup status(true,false) of this bucket.");
        System.out.println("\t\t\t--acl<acl>\t\t\tspecify the acl(public-read,private) of this bucket.");
        System.out.println("\t-listbuckets\t\t\t\t\tlist your all buckets owned by you.");
        System.out.println("\t-putfile <file, bucketname, [-key objectkey], [-replace false(default)|true]>\tupload a file or files.");
        System.out.println("\t\t\t\t\t\t\tIf $file is a file, you can using -key to set specific object key, if no set, object key equals to f.getAbsolutePath()");
        System.out.println("\t\t\t\t\t\t\tIf $file is a directory, the tool will recursively put all sub folder files. Each object key equals subfolder string plus file name.");
        System.out.println("\t\t\t\t\t\t\tIf $cover is true, the tool will replace all remote file according to file name.");
        System.out.println("\t-putstream\t<bucket,key [,file]>\t\tupload a object from standard input or file.");
        System.out.print("\t-lookup\t\t<bucket[,key]>\t\t\t");
        System.out.print("view the object or bucket is existed or not.\n\t\t\t\t\t\t\t\t");
        System.out.print("if object exist return it's size, otherwise reurn -1;");
        System.out.print("\n\t\t\t\t\t\t\t\tif your bucket has existed return 1, ");
        System.out.println("others' bucket return -2, otherwise return -1.");
        System.out.println("\t-getobject\t<bucket,key [,file]>\t\tdownload a file to standard output or file.");
        System.out.println("\t-getobjects\t<bucket,prefix,directory [isCover]>\t\tdownload files to specified directory.");
        System.out.println("\t-deletebucket\t<bucket>\t\t\tdelete a bucket.");
        System.out.println("\t-deleteobject\t<bucket,key>\t\t\tdelete a object in specified bucket.");
        System.out.println("\t-listobjects\t<bucket>\t\t\tlist all objects in specified bucket.");
        System.out.println("\t-getbucketacl\t<bucket>\t\t\tget the access control of the specified bucket.");
        System.out.println("\t-setbucketacl\t<bucket,acl>\t\t\tset the access control of the specified bucket.");
        System.out.println("\t-copyobject\t<srcbuc,srckey,desbuc,deskey>\tcopy a object from another bucket");
        System.out.println("\t-moveobject\t<srcbuc,srckey,desbuc,deskey>\tmove a object to another bucket");
        System.out.println("\t-syncput\t<localDirectory,bucket>\t\tput all objects in local directory but not in NOS bucket");
        System.out.println("\t-syncget\t<localDirectory,bucket>\t\tdownload all objects in NOS bucket but not in local directory");
        System.out.println("\t-syncdif\t<localDirectory,bucket>\t\tlist the different between NOS bucket and local directory");
        System.out.println("\t-uploaddirectory\t<localDirectory, bucket, [-replace false(default)|true]>\t\tput all objects in local directory");
        System.out.println("\t-decodeip\t<requestid>\t\t\tdecode ip from the requestid");
    }

    public static void main(String[] args) {
        noscmd testnoscmd = new noscmd();
        if (args.length < 1) {
            noscmd.usage();
            System.exit(1);
        }
        String command = args[0];
        noscmd noscmd2 = new noscmd();
        if (!commands.containsKey(command)) {
            System.out.println("The option " + command + " can not be found");
            noscmd.usage();
            System.exit(-1);
        }
        args = noscmd.parseCommonParams(args, noscmd2);
        try {
            switch (commands.get(command)) {
                case 1: {
                    String location = "HZ";
                    String acl = "private";
                    boolean dedup = false;
                    if (args.length % 2 != 0) {
                        log.info((Object)"Error: missing  argument");
                        noscmd.usage();
                        System.exit(-1);
                    }
                    block31: for (int i = 2; i < args.length; i += 2) {
                        if (!createBucketcommands.containsKey(args[i])) {
                            System.out.println("The option:" + args[i] + " can not be found");
                            System.exit(-1);
                        }
                        switch (createBucketcommands.get(args[i])) {
                            case 1: {
                                location = args[i + 1];
                                continue block31;
                            }
                            case 2: {
                                if ("true".equalsIgnoreCase(args[i + 1])) {
                                    dedup = true;
                                    continue block31;
                                }
                                if ("false".equalsIgnoreCase(args[i + 1])) continue block31;
                                System.out.println("Invaild argument dedup:(true,false)");
                                System.exit(-1);
                                continue block31;
                            }
                            case 3: {
                                acl = args[i + 1];
                            }
                        }
                    }
                    noscmd2.createBucket(args[1], location, dedup, acl);
                    break;
                }
                case 2: {
                    String putUsage = "putfile usage: noscmd -putfile <file, bucketname, [-key objectkey], [-replace false(default)|true]>";
                    if (args.length != 3 && args.length != 5 && args.length != 7) {
                        System.out.println("Error: missing argument");
                        System.out.println(putUsage);
                        System.exit(-1);
                    }
                    String objectKey = null;
                    boolean replace = false;
                    if (args.length > 3) {
                        for (int i = 3; i < args.length; i += 2) {
                            if ("-key".equalsIgnoreCase(args[i])) {
                                if (args.length < i + 2) {
                                    System.out.println(putUsage);
                                    System.exit(-1);
                                    continue;
                                }
                                objectKey = args[i + 1];
                                continue;
                            }
                            if ("-replace".equalsIgnoreCase(args[i])) {
                                if (args.length < i + 2) {
                                    System.out.println(putUsage);
                                    System.exit(-1);
                                    continue;
                                }
                                replace = Boolean.parseBoolean(args[i + 1]);
                                continue;
                            }
                            System.out.println(putUsage);
                            System.exit(-1);
                        }
                    }
                    noscmd2.putFile(args[2], objectKey, new File(args[1]), replace);
                    break;
                }
                case 3: {
                    if (args.length == 3) {
                        noscmd2.putStream(args[1], args[2], null);
                        break;
                    }
                    if (args.length == 4) {
                        noscmd2.putStream(args[1], args[2], args[3]);
                        break;
                    }
                    System.out.println("Error: missing  argument");
                    System.out.println("putstream usage: noscmd -putstream <bucketname, objectkey[,file]>");
                    System.exit(-1);
                    break;
                }
                case 4: {
                    if (args.length == 3) {
                        noscmd2.getObject(args[1], args[2], null);
                        break;
                    }
                    if (args.length == 4) {
                        noscmd2.getObject(args[1], args[2], args[3]);
                        break;
                    }
                    System.out.println("Error: missing  argument");
                    System.out.println("getobject usage: noscmd -getobject <bucketname, objectkey[,file]>");
                    System.exit(-1);
                    break;
                }
                case 5: {
                    if (args.length != 3) {
                        System.out.println("Error: missing  argument");
                        System.out.println("deleteobject usage: noscmd -deleteobject <bucketname, objectkey>");
                        System.exit(-1);
                    }
                    noscmd2.deleteObject(args[1], args[2]);
                    break;
                }
                case 6: {
                    if (args.length != 2) {
                        System.out.println("Error: missing  argument");
                        System.out.println("deletebucket usage: noscmd -deletebucket <bucketname>");
                        System.exit(-1);
                    }
                    noscmd2.deleteBucket(args[1]);
                    break;
                }
                case 7: {
                    if (args.length != 2) {
                        System.out.println("Error: missing  argument");
                        System.out.println("listobjects usage: noscmd -listobjects <bucketname>");
                        System.exit(-1);
                    }
                    noscmd2.listObjects(args[1], null, null);
                    break;
                }
                case 9: {
                    if (args.length != 2) {
                        System.out.println("Error: missing  argument");
                        System.out.println("getbucketacl usage: noscmd -getbucketacl <bucketname>");
                        System.exit(-1);
                    }
                    noscmd2.getBucketAcl(args[1]);
                    break;
                }
                case 10: {
                    if (args.length != 1) {
                        System.out.println("Error:List Bucket do not need any arguments");
                        System.out.println("listbuckets usage: noscmd -listbuckets");
                        System.exit(-1);
                    }
                    noscmd2.listBucket();
                    break;
                }
                case 11: {
                    if (args.length == 3) {
                        noscmd2.lookup(args[1], args[2]);
                        break;
                    }
                    if (args.length == 2) {
                        noscmd2.lookup(args[1], null);
                        break;
                    }
                    System.out.println("Error: missing  argument");
                    System.out.println("lookup usage: noscmd -lookup <bucketname, key>");
                    System.exit(-1);
                    break;
                }
                case 13: {
                    if (args.length != 3) {
                        System.out.println("Error: missing  argument");
                        System.out.println("setbucketacl usage: noscmd -setbucketacl <bucketname, acl>");
                        System.exit(-1);
                    }
                    noscmd2.setBucketAcl(args[1], args[2]);
                    break;
                }
                case 14: {
                    if (args.length != 5) {
                        System.out.println("Error: missing  argument");
                        System.out.println("copyobject usage: noscmd -copyobject <srcbucket,srckey,descbucket,desckey>");
                        System.exit(-1);
                    }
                    noscmd2.copyObject(args[1], args[2], args[3], args[4]);
                    break;
                }
                case 15: {
                    if (args.length != 5) {
                        System.out.println("Error: missing  argument");
                        System.out.println("moveobject usage: noscmd -moveobject <srcbucket,srckey,descbucket,desckey>");
                        System.exit(-1);
                    }
                    noscmd2.moveObject(args[1], args[2], args[3], args[4]);
                    break;
                }
                case 16: {
                    if (args.length != 3) {
                        System.out.println("Error: missing  argument");
                        System.out.println("syncput usage: noscmd -syncput <localDirectory,bucket>");
                        System.exit(-1);
                    }
                    noscmd2.syncput(args[1], args[2]);
                    break;
                }
                case 17: {
                    if (args.length != 3) {
                        System.out.println("Error: missing  argument");
                        System.out.println("syncget usage: noscmd -syncget <localDirectory,bucket>");
                        System.exit(-1);
                    }
                    noscmd2.syncget(args[1], args[2]);
                    break;
                }
                case 18: {
                    if (args.length != 3) {
                        System.out.println("Error: missing  argument");
                        System.out.println("syndelete usage: noscmd -syncdel <localDirectory,bucket>");
                        System.exit(-1);
                    }
                    noscmd2.syndelete(args[1], args[2]);
                    break;
                }
                case 19: {
                    if (args.length != 3) {
                        System.out.println("Error: missing  argument");
                        System.out.println("syndiff usage: noscmd -syncdif <localDirectory,bucket>");
                        System.exit(-1);
                    }
                    noscmd2.syndiff(args[1], args[2]);
                    break;
                }
                case 20: {
                    if (args.length != 2) {
                        System.out.println("Error: missing  argument");
                        System.out.println("decodeip usage: noscmd -decodeip <requestid>");
                        System.exit(-1);
                    }
                    noscmd2.decodeRequestId(args[1]);
                    break;
                }
                case 21: {
                    if (args.length != 3 && args.length != 5) {
                        System.out.println("Error: missing  argument");
                        System.out.println("uploaddirectory usage: noscmd -uploaddirectory <localDirectory, bucket, [-replace false(default)|true]>");
                        System.exit(-1);
                    }
                    boolean replace = false;
                    if (args.length == 5 && "true".equalsIgnoreCase(args[4])) {
                        replace = true;
                    }
                    noscmd2.uploadDir(args[2], null, new File(args[1]), true, replace);
                    break;
                }
                case 22: {
                    if (args.length != 5 && args.length != 4) {
                        System.out.println("Error: missing  argument");
                        System.out.println("getobjects usage: noscmd -getobjects <bucket,prefix,directory [isCover]>");
                        System.exit(-1);
                    }
                    if (args.length < 5 || !args[4].equalsIgnoreCase("true")) {
                        noscmd2.getObjects(args[1], new File(args[3]), args[2], false);
                        break;
                    }
                    noscmd2.getObjects(args[1], new File(args[3]), args[2], true);
                }
            }
        }
        catch (ServiceException e) {
            log.error((Object)("The operation:" + command + " failed. caused:Request ID:" + e.getRequestId() + " Error code:" + e.getErrorCode() + " Message:" + e.getMessage()));
            System.out.println(-1);
            System.exit(-1);
        }
        catch (ClientException e) {
            log.error((Object)("The operation:" + command + " failed. caused:client error message:"), (Throwable)e);
            System.out.println(-1);
            System.exit(-1);
        }
        catch (Exception e) {
            log.error((Object)("The operation:" + command + " failed. caused:"), (Throwable)e);
            System.out.println(-1);
            System.exit(-1);
        }
        System.out.println(1);
    }

    public static String[] parseCommonParams(String[] args, noscmd noscmd2) {
        if (args == null || noscmd2 == null) {
            return args;
        }
        ArrayList<String> checkedArgs = new ArrayList<String>();
        checkedArgs.add(args[0]);
        for (int i = 1; i < args.length; ++i) {
            if ("-id".equalsIgnoreCase(args[i]) && i + 1 < args.length) {
                noscmd2.setLogID(args[i + 1]);
                ++i;
                continue;
            }
            if ("-seq".equalsIgnoreCase(args[i]) && i + 1 < args.length) {
                noscmd2.setLogSeq(args[i + 1]);
                ++i;
                continue;
            }
            checkedArgs.add(args[i]);
        }
        return checkedArgs.toArray(new String[checkedArgs.size()]);
    }

    private void setLogSeqParams(WebServiceRequest request) {
        if (this.logID != null) {
            request.setLogID(this.getLogID());
        }
        if (this.logSeq != null) {
            request.setLogSeq(this.getLogSeq());
        }
    }

    private void setAndIncrementLogSeqParams(WebServiceRequest request) {
        if (this.logID != null) {
            request.setLogID(this.getLogID());
        }
        if (this.logSeq != null) {
            request.setLogSeq(this.getAndIncrementLogSeq());
        }
    }

    public void createBucket(String bucketName, String location, boolean dedup, String acl) {
        CreateBucketRequest request = new CreateBucketRequest(bucketName);
        request.setCannedAcl(acl);
        request.setDeduplicate(dedup);
        request.setRegion(location);
        this.setLogSeqParams(request);
        this.nosClient.createBucket(request);
        log.info((Object)("BucketName:" + bucketName + " has been created finished."));
    }

    public void putFile(String bucketName, String key, File file, boolean isCover) throws Exception {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("Must provide a directory or file to upload");
        }
        if (file.isFile()) {
            if (key == null && (key = this.getObjectKey(file, null)) == null) {
                String dir = file.getAbsolutePath();
                log.error((Object)("getObjectKey for " + dir + " error."));
                throw new ServiceException("put " + dir + " error.");
            }
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, file);
            if (this.storageClass != null) {
                putObjectRequest.setStorageClass(this.storageClass);
            }
            if (isCover || !this.doesObjectExist(bucketName, key)) {
                log.info((Object)("Begin upload file:" + file.getName() + " to bucket:" + bucketName + " as key: " + key + ", please waiting..."));
                this.setAndIncrementLogSeqParams(putObjectRequest);
                Upload upload = this.tx.upload(putObjectRequest);
                upload.waitForUploadResult();
                this.tx.shutdownNow();
                log.info((Object)("File:" + file.getName() + " has been upload finished."));
            } else {
                log.warn((Object)("File:" + file.getName() + " is already exist"));
            }
        } else {
            this.uploadDir(bucketName, null, file, true, isCover);
        }
    }

    public void putStream(String bucketName, String key, String file) {
        try {
            PutObjectRequest putObjectRequest = null;
            if (file == null) {
                InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucketName, key);
                if (this.storageClass != null) {
                    request.setStorageClass(this.storageClass);
                }
                this.setAndIncrementLogSeqParams(request);
                String uploadId = this.nosClient.initiateMultipartUpload(request).getUploadId();
                ArrayList<PartETag> partETags = new ArrayList<PartETag>();
                int partNumber = 1;
                if (TransferManagerUPloadPartSize > Integer.MAX_VALUE) {
                    log.info((Object)"the TransferManagerUPloadPartSize size if too big ");
                }
                ByteBuffer nosBuffer = ByteBuffer.allocate((int)TransferManagerUPloadPartSize);
                DataInputStream input = new DataInputStream(System.in);
                byte[] tmpbuffer = new byte[0x100000];
                int length = -1;
                while ((length = input.read(tmpbuffer)) != -1) {
                    if (nosBuffer.remaining() >= length) {
                        nosBuffer.put(tmpbuffer, 0, length);
                        continue;
                    }
                    int nosBufferRemain = nosBuffer.remaining();
                    int tmpBufferUnread = length - nosBufferRemain;
                    nosBuffer.put(tmpbuffer, 0, nosBufferRemain);
                    this.uploadPart(nosBuffer, nosBuffer.capacity(), bucketName, key, uploadId, partNumber++, partETags);
                    nosBuffer.clear();
                    nosBuffer.put(tmpbuffer, nosBufferRemain, tmpBufferUnread);
                }
                this.uploadPart(nosBuffer, nosBuffer.position(), bucketName, key, uploadId, partNumber++, partETags);
                System.in.close();
                input.close();
                CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags);
                this.setAndIncrementLogSeqParams(completeRequest);
                this.nosClient.completeMultipartUpload(completeRequest);
                log.info((Object)("Upload to bucket:" + bucketName + " as key:" + key + " finished."));
                System.out.println(1);
                System.exit(1);
            } else {
                FileInputStream input = null;
                input = new FileInputStream(new File(file));
                putObjectRequest = new PutObjectRequest(bucketName, key, input, null);
                this.setLogSeqParams(putObjectRequest);
                log.info((Object)("Begin upload file:" + file + " to bucket:" + bucketName + ", please waiting..."));
                Upload upload = this.tx.upload(putObjectRequest);
                UploadResult result = upload.waitForUploadResult();
                log.info((Object)(result.getBucketName() + "/" + result.getKey()));
                this.tx.shutdownNow();
                log.info((Object)"File has been upload finished.");
                System.out.println(1);
                System.exit(1);
            }
        }
        catch (ServiceException e) {
            log.error((Object)("Failed.Error code:" + e.getErrorCode() + "Error type:" + (Object)((Object)e.getErrorType()) + "message:" + e.getMessage()));
            System.err.println(-1);
            System.exit(-1);
        }
        catch (ClientException e) {
            log.error((Object)("Failed.message:" + e.getMessage()));
            System.err.println(-1);
            System.exit(-1);
        }
        catch (Exception e) {
            log.error((Object)("Failed.message:" + e.getMessage()));
            System.err.println(-1);
            System.exit(-1);
        }
    }

    private void uploadPart(ByteBuffer bb, int length, String bucketName, String key, String uploadId, int partNumber, List<PartETag> partETags) {
        ByteArrayInputStream ret = new ByteArrayInputStream(bb.array());
        UploadPartRequest request = new UploadPartRequest().withBucketName(bucketName).withKey(key).withInputStream(ret).withPartSize(length).withUploadId(uploadId).withPartNumber(partNumber);
        this.setAndIncrementLogSeqParams(request);
        UploadPartResult result = this.nosClient.uploadPart(request);
        log.info((Object)result.getPartNumber());
        log.info((Object)result.getETag());
        partETags.add(new PartETag(result.getPartNumber(), result.getETag()));
    }

    public void getObject(String bucketName, String key, String fileStr) {
        try {
            GetObjectRequest request = new GetObjectRequest(bucketName, key);
            this.setLogSeqParams(request);
            NOSObject nosobj = this.nosClient.getObject(request);
            NOSObjectInputStream input = nosobj.getObjectContent();
            BufferedOutputStream outputStream = null;
            long expectLength = nosobj.getObjectMetadata().getContentLength();
            long actualLength = 0L;
            if (fileStr == null) {
                int bytesRead;
                byte[] buffer = new byte[0x100000];
                while ((bytesRead = ((InputStream)input).read(buffer)) != -1) {
                    System.out.write(buffer, 0, bytesRead);
                    actualLength += (long)bytesRead;
                }
                System.out.flush();
            } else {
                int bytesRead;
                log.info((Object)("Begin download file:" + key + " in bucket:" + bucketName + " , please wait..."));
                File file = new File(fileStr);
                if (!file.exists()) {
                    file.createNewFile();
                }
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buffer = new byte[0x100000];
                while ((bytesRead = ((InputStream)input).read(buffer)) > -1) {
                    ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                    actualLength += (long)bytesRead;
                }
                ((OutputStream)outputStream).close();
                log.info((Object)"Download file finished");
            }
            if (actualLength != expectLength) {
                log.fatal((Object)("Download failed . File:" + key + " in bucket:" + bucketName + " may be download partial."));
                System.err.println(-1);
                System.exit(-1);
            }
            if (input != null) {
                ((InputStream)input).close();
            }
            log.info((Object)("Finashed download file:" + key + " in bucket:" + bucketName));
        }
        catch (ServiceException e) {
            log.error((Object)("Failed.Error code:" + e.getErrorCode() + "Error type:" + (Object)((Object)e.getErrorType()) + "message:" + e.getMessage()));
            System.exit(-1);
        }
        catch (ClientException e) {
            log.error((Object)"Failed.message:", (Throwable)e);
            System.exit(-1);
        }
        catch (Exception e) {
            log.error((Object)"Failed.message:", (Throwable)e);
            System.exit(-1);
        }
    }

    public void deleteBucket(String bucketName) {
        this.nosClient.deleteBucket(bucketName);
        log.info((Object)("Bucket " + bucketName + " has been deleted."));
    }

    public void deleteObject(String bucketName, String key) {
        this.nosClient.deleteObject(bucketName, key);
        log.info((Object)("Object " + key + " in bucket " + bucketName + " has been deleted."));
        System.out.println(1);
    }

    public void listObjects(String bucketName, String prefix, List<String> keys) {
        ObjectListing objectListing;
        String marker = null;
        int size = 0;
        do {
            ListObjectsRequest request = new ListObjectsRequest();
            request.setPrefix(prefix);
            request.setBucketName(bucketName);
            request.setMarker(marker);
            request.setMaxKeys(100);
            objectListing = this.nosClient.listObjects(request);
            List<NOSObjectSummary> sum = objectListing.getObjectSummaries();
            if (sum.size() == 0) {
                log.info((Object)(bucketName + " is Empty."));
                System.out.println(-1);
                continue;
            }
            size += sum.size();
            for (NOSObjectSummary obj : sum) {
                if (keys != null) {
                    keys.add(obj.getKey());
                } else {
                    System.out.println("ObjectKey:" + obj.getKey().trim());
                    System.out.println("ObjectSize:" + obj.getSize());
                    System.out.println("LastModified:" + obj.getLastModified());
                    System.out.println("-----------------------------------------");
                }
                marker = obj.getKey();
            }
            request.setMarker(marker);
        } while (objectListing.isTruncated());
        if (keys == null) {
            System.out.println(size + " objects is listed");
        }
    }

    public void getObjects(String bucket, File directory, String prefix, boolean isCover) throws IOException {
        ArrayList<String> keys = new ArrayList<String>();
        this.listObjects(bucket, prefix, keys);
        int finishedDownload = 0;
        int failedDownload = 0;
        HashSet<String> failedFiles = new HashSet<String>();
        System.out.println("Begin to download,please wait...");
        for (String key : keys) {
            File file = new File(directory + File.separator + key);
            file.getParentFile().mkdirs();
            if (!isCover && (isCover || file.exists())) continue;
            file.createNewFile();
            try {
                GetObjectRequest request = new GetObjectRequest(bucket, key);
                this.setLogSeqParams(request);
                this.nosClient.getObject(request, file);
            }
            catch (Exception e) {
                ++failedDownload;
                failedFiles.add(key);
                continue;
            }
            ++finishedDownload;
        }
        System.out.println("-----------------------------");
        System.out.println("Finished download files number:" + finishedDownload);
        System.out.println("Failed download files number:" + failedDownload);
        if (failedFiles.size() != 0) {
            System.out.println("Failed download files:");
            for (String fail : failedFiles) {
                System.out.println(fail);
            }
        }
    }

    public void getBucketAcl(String bucketName) {
        CannedAccessControlList acl = this.nosClient.getBucketAcl(bucketName);
        System.out.println("bucket:" + bucketName + "\tacl:" + acl.toString());
    }

    public void listBucket() {
        List<Bucket> buckets = this.nosClient.listBuckets();
        if (buckets.size() == 0) {
            System.out.println(-1);
            log.info((Object)"You have not bucket.");
        } else {
            for (Bucket buc : buckets) {
                System.out.println("Bucket Name:" + buc.getName().trim());
            }
        }
    }

    public void lookup(String bucketName, String key) {
        if (key == null) {
            HeadBucketRequest request = new HeadBucketRequest(bucketName);
            this.setLogSeqParams(request);
            if (this.nosClient.doesBucketExist(request)) {
                System.out.println(1);
                System.exit(1);
            } else {
                System.out.println(-1);
                System.exit(-1);
            }
            return;
        }
        try {
            GetObjectMetadataRequest request = new GetObjectMetadataRequest(bucketName, key);
            this.setAndIncrementLogSeqParams(request);
            ObjectMetadata objectMetadata = this.nosClient.getObjectMetadata(request);
            System.out.println(objectMetadata.getContentLength());
            System.exit(1);
        }
        catch (ServiceException ase) {
            switch (ase.getStatusCode()) {
                case 403: {
                    throw ase;
                }
                case 404: {
                    ListMultipartUploadsRequest listRequest = new ListMultipartUploadsRequest(bucketName);
                    this.setAndIncrementLogSeqParams(listRequest);
                    MultipartUploadListing result = this.nosClient.listMultipartUploads(listRequest);
                    List<MultipartUpload> mulitUploads = result.getMultipartUploads();
                    for (MultipartUpload upload : mulitUploads) {
                        if (!key.equals(upload.getKey())) continue;
                        AbortMultipartUploadRequest abortRequest = new AbortMultipartUploadRequest(bucketName, key, upload.getUploadId());
                        this.setAndIncrementLogSeqParams(abortRequest);
                        this.nosClient.abortMultipartUpload(abortRequest);
                    }
                    System.out.println(-1);
                    System.exit(-1);
                    break;
                }
                default: {
                    throw ase;
                }
            }
        }
    }

    public void setBucketAcl(String bucketName, String acl) {
        SetBucketAclRequest setBucketAclRequest = new SetBucketAclRequest(bucketName, acl);
        this.nosClient.setBucketAcl(setBucketAclRequest);
        System.out.println("The acl of bucket:" + bucketName + " has changed to " + acl);
    }

    public void copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        log.info((Object)"The copy option is begining,please waiting...");
        this.nosClient.copyObject(sourceBucketName, sourceKey, destinationBucketName, destinationKey);
        System.out.println(1);
        log.info((Object)"Copy finished.");
    }

    public void moveObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        log.info((Object)"The move option is begining,please waiting...");
        this.nosClient.moveObject(sourceBucketName, sourceKey, destinationBucketName, destinationKey);
        System.out.println(1);
        log.info((Object)"Move finished.");
    }

    private void syndiff(String localDir, String bucket) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        this.localNotHave(localDir, bucket);
        this.nosNotHave(localDir, bucket);
        System.out.println("local exist But nos bucket not:");
        if (this.nosLessSet.size() == 0) {
            System.out.println("---");
        }
        for (String filenameString : this.nosLessSet) {
            System.out.println(filenameString);
        }
        System.out.println("local not exist But nos bucket exist:");
        if (this.localLessSet.size() == 0) {
            System.out.println("---");
        }
        for (String filenameString : this.localLessSet) {
            System.out.println(filenameString);
        }
    }

    private void syndelete(String localDir, String bucket) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        this.localNotHave(localDir, bucket);
        for (String fileNameString : this.localLessSet) {
            this.nosClient.deleteObject(bucket, fileNameString);
            System.out.println("file:" + fileNameString + " have delete finished.");
        }
    }

    private void syncget(String localDir, String bucket) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        this.localNotHave(localDir, bucket);
        for (String fileNameString : this.localLessSet) {
            File file = new File(localDir + File.separator + fileNameString);
            file.getParentFile().mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            System.out.println("file:" + fileNameString + " begin to download,please wait...");
            this.nosClient.getObject(new GetObjectRequest(bucket, fileNameString), file);
            System.out.println("file:" + fileNameString + " have download finished.");
        }
    }

    private void syncput(String localDir, String bucket) throws ServiceException, ClientException, InterruptedException, NoSuchAlgorithmException, FileNotFoundException, IOException {
        HashSet<String> failedFiles = new HashSet<String>();
        int finishedFileNum = 0;
        int failedFileNum = 0;
        this.nosNotHave(localDir, bucket);
        for (String fileNameString : this.nosLessSet) {
            File file = new File(localDir + File.separator + fileNameString);
            try {
                if (file.length() < 0x500000L) {
                    this.nosClient.putObject(bucket, fileNameString, file);
                } else {
                    Upload upload = this.tx.upload(bucket, fileNameString, file);
                    upload.waitForUploadResult();
                }
            }
            catch (ServiceException e) {
                log.error((Object)("File:" + fileNameString + " uploaded failed. caused:Request ID:" + e.getRequestId() + " Error code:" + e.getErrorCode() + " Message:" + e.getMessage()));
                failedFiles.add(fileNameString);
                ++failedFileNum;
                continue;
            }
            catch (ClientException e) {
                log.error((Object)("File:" + fileNameString + " uploaded failed. caused:client error message:" + e.getMessage()));
                failedFiles.add(fileNameString);
                ++failedFileNum;
                continue;
            }
            catch (Exception e) {
                log.error((Object)("File:" + fileNameString + " uploaded failed. caused:" + e.getMessage()));
                failedFiles.add(fileNameString);
                ++failedFileNum;
                continue;
            }
            ++finishedFileNum;
            System.out.println("file:" + fileNameString + " have upload finished.");
        }
        System.out.println("-----------------------------");
        System.out.println("Finished files number:" + finishedFileNum);
        System.out.println("Failed files number:" + failedFileNum);
        if (failedFiles.size() == 0) {
            System.out.println("All files in directory" + localDir + " have upload finished.");
        } else {
            System.out.println("Files upload failed:");
            for (String failedFile : failedFiles) {
                System.out.println(failedFile);
            }
        }
        this.tx.shutdownNow();
    }

    public void localNotHave(String localDir, String bucket) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        HashMap<String, String> nosEtags = new HashMap<String, String>();
        HashMap<String, String> nosFileSizes = new HashMap<String, String>();
        List<NOSObjectSummary> objectSummary = this.nosClient.listObjects(bucket).getObjectSummaries();
        for (NOSObjectSummary objsum : objectSummary) {
            nosEtags.put(objsum.getKey(), objsum.getETag());
            nosFileSizes.put(objsum.getKey(), objsum.getSize() + "");
        }
        HashMap<String, String> localFileSizes = new HashMap<String, String>();
        this.localFileSizes(localFileSizes, localDir, "");
        for (String nosKey : nosFileSizes.keySet()) {
            if (!localFileSizes.containsValue(nosFileSizes.get(nosKey))) {
                this.localLessSet.add(nosKey);
                continue;
            }
            boolean isSame = false;
            for (String localKeyString : localFileSizes.keySet()) {
                if (!((String)localFileSizes.get(localKeyString)).equals(nosFileSizes.get(nosKey))) continue;
                if (Long.parseLong((String)localFileSizes.get(localKeyString)) > 0x500000L) {
                    isSame = true;
                    break;
                }
                if (!((String)nosEtags.get(nosKey)).equalsIgnoreCase(Md5Utils.getHex(Md5Utils.computeMD5Hash(new FileInputStream(localDir + File.separator + localKeyString))))) continue;
                isSame = true;
                break;
            }
            if (isSame) continue;
            this.localLessSet.add(nosKey);
        }
    }

    private void localFileSizes(Map<String, String> localFileSizes, String localDir, String parent) {
        File dir;
        if (parent.equals("")) {
            this.localString = localDir;
        }
        if ((dir = new File(localDir)).isDirectory()) {
            String[] fileNames = dir.list();
            for (int i = 0; i < fileNames.length; ++i) {
                File file = new File(localDir + File.separator + parent + fileNames[i]);
                if (!file.isDirectory()) {
                    localFileSizes.put(parent + fileNames[i], file.length() + "");
                    continue;
                }
                this.localFileSizes(localFileSizes, file.getAbsolutePath(), file.getAbsolutePath().substring(this.localString.length() + 1) + File.separator);
            }
        } else {
            System.out.println("first parameter must be directory.");
            System.exit(-1);
        }
    }

    public void nosNotHave(String localDir, String bucket) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        HashSet<String> nosEtags = new HashSet<String>();
        HashSet<String> nosFileSizes = new HashSet<String>();
        List<NOSObjectSummary> objectSummary = this.nosClient.listObjects(bucket).getObjectSummaries();
        for (NOSObjectSummary objsum : objectSummary) {
            nosFileSizes.add(objsum.getSize() + "");
            if (objsum.getSize() > 0x500000L) continue;
            nosEtags.add(objsum.getETag().toLowerCase());
        }
        this.nosNotHave(localDir, nosFileSizes, nosEtags, "");
    }

    public void nosNotHave(String localDir, Set<String> nosFileSizes, Set<String> nosEtags, String parent) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        File dir;
        if (parent.equals("")) {
            this.localString = localDir;
        }
        if ((dir = new File(localDir)).isDirectory()) {
            String[] fileNames = dir.list();
            for (int i = 0; i < fileNames.length; ++i) {
                File file = new File(localDir + File.separator + fileNames[i]);
                if (!file.isDirectory()) {
                    if (file.length() > 0x500000L) {
                        if (nosFileSizes.contains(file.length() + "")) continue;
                        this.nosLessSet.add(parent + fileNames[i]);
                        continue;
                    }
                    if (nosFileSizes.contains(file.length() + "") && nosEtags.contains(Md5Utils.getHex(Md5Utils.computeMD5Hash(new FileInputStream(file))))) continue;
                    this.nosLessSet.add(parent + fileNames[i]);
                    continue;
                }
                this.nosNotHave(file.getAbsolutePath(), nosFileSizes, nosEtags, file.getAbsolutePath().substring(this.localString.length()) + File.separator);
            }
        } else {
            System.out.println("first parameter must be directory.");
            System.exit(-1);
        }
    }

    public String getObjectKey(File f, File directory) {
        if (f == null || f.isDirectory()) {
            log.warn((Object)"invalid parameter.");
            return null;
        }
        if (directory == null) {
            return f.getAbsolutePath();
        }
        if (directory.isFile()) {
            log.warn((Object)(directory.getAbsolutePath() + " should be directory."));
            return null;
        }
        return f.getAbsolutePath().substring(directory.getAbsolutePath().length() + 1).replaceAll("\\\\", "/");
    }

    public void uploadDir(String bucketName, String virtualDirectoryKeyPrefix, File directory, boolean includeSubdirectories, boolean iscover) throws ServiceException, ClientException, InterruptedException {
        HashSet<String> failedFiles = new HashSet<String>();
        int finishedFileNum = 0;
        int failedFileNum = 0;
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Must provide a directory to upload");
        }
        if (virtualDirectoryKeyPrefix == null || virtualDirectoryKeyPrefix.length() == 0) {
            virtualDirectoryKeyPrefix = null;
        } else if (!virtualDirectoryKeyPrefix.endsWith("/")) {
            virtualDirectoryKeyPrefix = virtualDirectoryKeyPrefix + "/";
        }
        LinkedList<File> files = new LinkedList<File>();
        this.listFiles(directory, files, includeSubdirectories);
        for (File f : files) {
            String key = this.getObjectKey(f, directory);
            try {
                String nosKey = key;
                if (virtualDirectoryKeyPrefix != null) {
                    nosKey = key.contains(virtualDirectoryKeyPrefix) ? key.replace(virtualDirectoryKeyPrefix, "") : virtualDirectoryKeyPrefix + key;
                }
                if (iscover || !this.doesObjectExist(bucketName, nosKey)) {
                    PutObjectRequest request = new PutObjectRequest(bucketName, nosKey, f);
                    if (this.storageClass != null) {
                        request.setStorageClass(this.storageClass);
                    }
                    Upload upload = this.tx.upload(request);
                    this.setLogSeqParams(request);
                    upload.waitForUploadResult();
                    ++finishedFileNum;
                    System.out.println("File:" + key + " upload finished");
                    continue;
                }
                ++finishedFileNum;
                System.out.println("File:" + key + " already exist");
            }
            catch (ServiceException e) {
                log.error((Object)("File:" + key + " uploaded failed. caused:Request ID:" + e.getRequestId() + " Error code:" + e.getErrorCode() + " Message:" + e.getMessage()));
                failedFiles.add(key);
                ++failedFileNum;
            }
            catch (ClientException e) {
                log.error((Object)("File:" + key + " uploaded failed. caused:client error message:" + e.getMessage()));
                failedFiles.add(key);
                ++failedFileNum;
            }
            catch (Exception e) {
                log.error((Object)("File:" + key + " uploaded failed. caused:" + e.getMessage()));
                failedFiles.add(key);
                ++failedFileNum;
            }
        }
        System.out.println("-----------------------------");
        System.out.println("Finished files number:" + finishedFileNum);
        System.out.println("Failed files number:" + failedFileNum);
        if (failedFiles.size() == 0) {
            System.out.println("All files in directory" + directory + " have upload finished.");
        } else {
            System.out.println("Files upload failed:");
            for (String failedFile : failedFiles) {
                System.out.println(failedFile);
            }
        }
        this.tx.shutdownNow();
    }

    public boolean doesObjectExist(String bucket, String object) {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(bucket, object);
        this.setAndIncrementLogSeqParams(request);
        try {
            this.nosClient.getObjectMetadata(request);
            return true;
        }
        catch (ServiceException ase) {
            switch (ase.getStatusCode()) {
                case 403: {
                    throw ase;
                }
                case 404: {
                    return false;
                }
            }
            throw ase;
        }
    }

    private void listFiles(File dir, List<File> results, boolean includeSubDirectories) {
        File[] found = dir.listFiles();
        if (found != null) {
            for (File f : found) {
                if (f.isDirectory()) {
                    if (!includeSubDirectories) continue;
                    this.listFiles(f, results, includeSubDirectories);
                    continue;
                }
                results.add(f);
            }
        }
    }

    public void decodeRequestId(String rid) throws DecoderException {
        byte[] data = Hex.decodeHex((char[])rid.toCharArray());
        ByteBuffer tbb = ByteBuffer.allocate(8);
        tbb.put(data, 6, 8);
        tbb.flip();
        ByteBuffer ibb = ByteBuffer.allocate(4);
        ibb.put(data, 4, 2);
        ibb.put(data, 14, 2);
        ibb.flip();
        System.out.println(this.ip2String(ibb.getInt()));
    }

    public String ip2String(int ip) {
        byte[] buf = this.i2b(ip);
        try {
            return InetAddress.getByAddress(buf).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "127.0.0.1";
        }
    }

    public byte[] i2b(int value) {
        byte[] bytes = new byte[4];
        int temp = value;
        bytes[3] = (byte)temp;
        bytes[2] = (byte)(temp >>= 8);
        bytes[1] = (byte)(temp >>= 8);
        bytes[0] = (byte)(temp >>= 8);
        return bytes;
    }

    public String getLogID() {
        return this.logID;
    }

    public void setLogID(String logID) {
        this.logID = logID;
    }

    public String getLogSeq() {
        return this.logSeq;
    }

    public String getAndIncrementLogSeq() {
        if (this.logSeq == null || this.logSeq.length() == 0) {
            return Long.toString(this.seqID.getAndIncrement());
        }
        return this.logSeq + "." + this.seqID.getAndIncrement();
    }

    public void setLogSeq(String logSeq) {
        this.logSeq = logSeq;
    }

    static {
        log = Logger.getLogger(noscmd.class);
        TransferManagerUPloadPartSize = 0x500000L;
        commands = new HashMap<String, Integer>();
        commands.put("-create", 1);
        commands.put("-putfile", 2);
        commands.put("-putstream", 3);
        commands.put("-getobject", 4);
        commands.put("-deleteobject", 5);
        commands.put("-deletebucket", 6);
        commands.put("-listobjects", 7);
        commands.put("-getbucketacl", 9);
        commands.put("-listbuckets", 10);
        commands.put("-lookup", 11);
        commands.put("-setbucketacl", 13);
        commands.put("-copyobject", 14);
        commands.put("-moveobject", 15);
        commands.put("-syncput", 16);
        commands.put("-syncget", 17);
        commands.put("-syncdel", 18);
        commands.put("-syncdif", 19);
        commands.put("-decodeip", 20);
        commands.put("-uploaddirectory", 21);
        commands.put("-getobjects", 22);
        createBucketcommands = new HashMap<String, Integer>();
        createBucketcommands.put("--location", 1);
        createBucketcommands.put("--dedup", 2);
        createBucketcommands.put("--acl", 3);
    }
}

