/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.tools;

import com.netease.cloud.auth.PropertiesCredentials;
import com.netease.cloud.services.nos.NosClient;
import com.netease.cloud.services.nos.model.ListObjectsRequest;
import com.netease.cloud.services.nos.model.NOSObjectSummary;
import com.netease.cloud.services.nos.model.ObjectListing;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.transfer.Download;
import com.netease.cloud.services.nos.transfer.TransferManager;
import com.netease.cloud.services.nos.transfer.Upload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SyncNOS {
    private static LinkedBlockingQueue<NOSObjectSummary> fetches = new LinkedBlockingQueue(15000);
    private static boolean end = false;
    private static int maxKeys = 1000;
    private static AtomicInteger count = new AtomicInteger(5);
    private static TransferManager srcTM;
    private static TransferManager destTM;

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String destBucketName;
        String srcBucketName;
        String destHost;
        Properties hostConf = new Properties();
        hostConf.load(new FileInputStream("conf/host.properties"));
        String srcHost = hostConf.getProperty("srcHost");
        if (srcHost == null) {
            System.err.println("config the src NOS hsot!");
            System.exit(-1);
        }
        if ((destHost = hostConf.getProperty("destHost")) == null) {
            System.err.println("config the dest NOS hsot!");
            System.exit(-1);
        }
        if ((srcBucketName = hostConf.getProperty("srcBucketName")) == null) {
            System.err.println("config the src bucket name.");
            System.exit(-1);
        }
        if ((destBucketName = hostConf.getProperty("destBucketName")) == null) {
            System.err.println("config the dest bucket name.");
            System.exit(-1);
        }
        try {
            maxKeys = Integer.valueOf(hostConf.getProperty("maxKeys"));
            System.out.println("change maxKeys to:" + maxKeys);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("sync src:" + srcHost + ",dest:" + destHost + ",srcBucket:" + srcBucketName + ",destBucket:" + destBucketName);
        PropertiesCredentials srcCread = new PropertiesCredentials(new FileInputStream("conf/srcCredentials.properties"));
        PropertiesCredentials destCread = new PropertiesCredentials(new FileInputStream("conf/destCredentials.properties"));
        NosClient src = new NosClient(srcCread);
        src.setEndpoint(srcHost);
        NosClient dest = new NosClient(destCread);
        dest.setEndpoint(destHost);
        srcTM = new TransferManager(src);
        destTM = new TransferManager(dest);
        ReaderThread readerThread = new ReaderThread(src, srcBucketName);
        readerThread.start();
        for (int i = 0; i < 5; ++i) {
            WriterThread writerThread = new WriterThread(src, dest, srcBucketName, destBucketName, i);
            writerThread.start();
        }
    }

    public static class WriterThread
    extends Thread {
        NosClient src;
        NosClient dest;
        String srcBucketName;
        String destBucketName;
        int seq;

        public WriterThread(NosClient src, NosClient dest, String srcBucketName, String destBucketName, int seq) {
            this.src = src;
            this.dest = dest;
            this.srcBucketName = srcBucketName;
            this.destBucketName = destBucketName;
            this.seq = seq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NOSObjectSummary os = null;
            String tmpFile = "tmp-" + Thread.currentThread().getId() + "-" + this.seq;
            File file = null;
            while (!end || fetches.size() > 0) {
                try {
                    os = (NOSObjectSummary)fetches.poll(5000L, TimeUnit.MILLISECONDS);
                    if (os == null) continue;
                    if (this.dest.doesObjectExist(this.destBucketName, os.getKey(), null)) {
                        System.out.println("key:" + os.getKey() + " already exist in bucket:" + this.destBucketName);
                        continue;
                    }
                    System.out.println("sync key:" + os.getKey());
                    file = new File(tmpFile);
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    Download download = srcTM.download(this.srcBucketName, os.getKey(), file);
                    download.waitForCompletion();
                    PutObjectRequest request = new PutObjectRequest(this.destBucketName, os.getKey(), file);
                    ObjectMetadata omd = new ObjectMetadata();
                    omd.setContentType(download.getObjectMetadata().getContentType());
                    request.setMetadata(omd);
                    Upload upload = destTM.upload(request);
                    upload.waitForCompletion();
                    System.out.println(os.getKey() + " synced!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (os == null) continue;
                    System.err.println("REDO:" + os.getKey() + " sycn failed!");
                    System.err.flush();
                }
                finally {
                    if (file == null) continue;
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            if (count.decrementAndGet() == 0) {
                srcTM.shutdownNow();
                destTM.shutdownNow();
            }
        }
    }

    public static class ReaderThread
    extends Thread {
        NosClient src;
        String srcBucketName;

        public ReaderThread(NosClient client, String srcBucketName) {
            this.src = client;
            this.srcBucketName = srcBucketName;
        }

        @Override
        public void run() {
            int count = 0;
            boolean hasNext = true;
            String nextMarker = null;
            while (hasNext) {
                ListObjectsRequest request = new ListObjectsRequest();
                request.setBucketName(this.srcBucketName);
                request.setMaxKeys(maxKeys);
                if (nextMarker != null) {
                    request.setMarker(nextMarker);
                }
                if (fetches.size() > 10000) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                ObjectListing ol = this.src.listObjects(request);
                hasNext = ol.isTruncated();
                nextMarker = ol.getNextMarker();
                for (NOSObjectSummary os : ol.getObjectSummaries()) {
                    fetches.offer(os);
                    ++count;
                }
            }
            end = true;
            System.out.println("totalsync:" + count);
        }
    }
}

