/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.WebServiceResponse;
import com.netease.cloud.http.HttpResponse;
import com.netease.cloud.services.nos.internal.AbstractNosResponseHandler;
import com.netease.cloud.services.nos.internal.ChecksumValidatingInputStream;
import com.netease.cloud.services.nos.internal.ServiceUtils;
import com.netease.cloud.services.nos.model.NOSObject;
import com.netease.cloud.services.nos.model.NOSObjectInputStream;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.util.BinaryUtils;

public class NosObjectResponseHandler
extends AbstractNosResponseHandler<NOSObject> {
    @Override
    public WebServiceResponse<NOSObject> handle(HttpResponse response) throws Exception {
        boolean responseContainsEntireObject;
        NOSObject object = new NOSObject();
        ObjectMetadata metadata = object.getObjectMetadata();
        this.populateObjectMetadata(response, metadata);
        boolean hasServerSideCalculatedChecksum = !ServiceUtils.isMultipartUploadETag(metadata.getETag());
        boolean bl = responseContainsEntireObject = response.getHeaders().get("Content-Range") == null;
        if (hasServerSideCalculatedChecksum && responseContainsEntireObject) {
            byte[] expectedChecksum = BinaryUtils.fromHex(metadata.getETag());
            object.setObjectContent(new NOSObjectInputStream(new ChecksumValidatingInputStream(response.getContent(), expectedChecksum, object.getBucketName() + "/" + object.getKey()), response.getHttpRequest()));
        } else {
            object.setObjectContent(new NOSObjectInputStream(response.getContent(), response.getHttpRequest()));
        }
        WebServiceResponse<NOSObject> awsResponse = this.parseResponseMetadata(response);
        awsResponse.setResult(object);
        return awsResponse;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return true;
    }
}

