/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos.internal;

import com.netease.cloud.WebServiceResponse;
import com.netease.cloud.http.HttpResponse;
import com.netease.cloud.http.HttpResponseHandler;
import com.netease.cloud.services.nos.NosResponseMetadata;
import com.netease.cloud.services.nos.internal.NosMetadataResponseHandler;
import com.netease.cloud.services.nos.internal.ObjectExpirationHeaderHandler;
import com.netease.cloud.services.nos.internal.ServiceUtils;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNosResponseHandler<T>
implements HttpResponseHandler<WebServiceResponse<T>> {
    private static final Logger log = LoggerFactory.getLogger(NosMetadataResponseHandler.class);
    private static final Set<String> ignoredHeaders = new HashSet<String>();

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    protected WebServiceResponse<T> parseResponseMetadata(HttpResponse response) {
        WebServiceResponse Response = new WebServiceResponse();
        String RequestId = response.getHeaders().get("x-nos-request-id");
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("REQUEST_ID", RequestId);
        Response.setResponseMetadata(new NosResponseMetadata(metadataMap));
        return Response;
    }

    protected void populateObjectMetadata(HttpResponse response, ObjectMetadata metadata) {
        for (Map.Entry<String, String> header : response.getHeaders().entrySet()) {
            String key = header.getKey();
            if (key.startsWith("x-nos-meta-")) {
                key = key.substring("x-nos-meta-".length());
                metadata.addUserMetadata(key, header.getValue());
                continue;
            }
            if (ignoredHeaders.contains(key)) continue;
            if (key.equals("Last-Modified")) {
                try {
                    metadata.setHeader(key, ServiceUtils.parseRfc822Date(header.getValue()));
                }
                catch (ParseException pe) {
                    log.warn("Unable to parse last modified date: " + header.getValue(), (Throwable)pe);
                }
                continue;
            }
            if (key.equals("Content-Length")) {
                try {
                    metadata.setHeader(key, Long.parseLong(header.getValue()));
                }
                catch (NumberFormatException nfe) {
                    log.warn("Unable to parse content length: " + header.getValue(), (Throwable)nfe);
                }
                continue;
            }
            if (key.equals("ETag")) {
                metadata.setHeader(key, ServiceUtils.removeQuotes(header.getValue()));
                continue;
            }
            if (key.equals("x-nos-expiration")) {
                new ObjectExpirationHeaderHandler<ObjectMetadata>().handle(metadata, response);
                continue;
            }
            metadata.setHeader(key, header.getValue());
        }
    }

    static {
        ignoredHeaders.add("Date");
        ignoredHeaders.add("x-nos-request-id");
    }
}

