/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos;

import com.netease.cloud.ClientConfiguration;
import com.netease.cloud.ClientException;
import com.netease.cloud.DefaultRequest;
import com.netease.cloud.HttpMethod;
import com.netease.cloud.Request;
import com.netease.cloud.ServiceException;
import com.netease.cloud.WebServiceClient;
import com.netease.cloud.WebServiceRequest;
import com.netease.cloud.WebServiceResponse;
import com.netease.cloud.auth.Credentials;
import com.netease.cloud.auth.CredentialsProvider;
import com.netease.cloud.auth.Signer;
import com.netease.cloud.handlers.HandlerChainFactory;
import com.netease.cloud.handlers.RequestHandler;
import com.netease.cloud.http.ExecutionContext;
import com.netease.cloud.http.HttpMethodName;
import com.netease.cloud.http.HttpResponseHandler;
import com.netease.cloud.internal.StaticCredentialsProvider;
import com.netease.cloud.services.nos.Nos;
import com.netease.cloud.services.nos.internal.BucketNameUtils;
import com.netease.cloud.services.nos.internal.Constants;
import com.netease.cloud.services.nos.internal.DeleteObjectsResponse;
import com.netease.cloud.services.nos.internal.HeaderHandler;
import com.netease.cloud.services.nos.internal.InputSubstream;
import com.netease.cloud.services.nos.internal.MD5DigestCalculatingInputStream;
import com.netease.cloud.services.nos.internal.Mimetypes;
import com.netease.cloud.services.nos.internal.NosAclHeaderResponseHnadler;
import com.netease.cloud.services.nos.internal.NosErrorResponseHandler;
import com.netease.cloud.services.nos.internal.NosMetadataResponseHandler;
import com.netease.cloud.services.nos.internal.NosObjectResponseHandler;
import com.netease.cloud.services.nos.internal.NosQueryStringSigner;
import com.netease.cloud.services.nos.internal.NosSigner;
import com.netease.cloud.services.nos.internal.NosStringSigner;
import com.netease.cloud.services.nos.internal.NosXmlResponseHandler;
import com.netease.cloud.services.nos.internal.ObjectExpirationHeaderHandler;
import com.netease.cloud.services.nos.internal.ProgressReportingInputStream;
import com.netease.cloud.services.nos.internal.RepeatableFileInputStream;
import com.netease.cloud.services.nos.internal.RepeatableInputStream;
import com.netease.cloud.services.nos.internal.ResponseHeaderHandlerChain;
import com.netease.cloud.services.nos.internal.ServiceUtils;
import com.netease.cloud.services.nos.internal.SimpleDataResponseHandler;
import com.netease.cloud.services.nos.internal.XmlWriter;
import com.netease.cloud.services.nos.model.AbortMultipartUploadRequest;
import com.netease.cloud.services.nos.model.Bucket;
import com.netease.cloud.services.nos.model.BucketLifecycleConfiguration;
import com.netease.cloud.services.nos.model.CannedAccessControlList;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadResult;
import com.netease.cloud.services.nos.model.CopyObjectRequest;
import com.netease.cloud.services.nos.model.CreateBucketRequest;
import com.netease.cloud.services.nos.model.DeduplicateRequest;
import com.netease.cloud.services.nos.model.DeduplicateResult;
import com.netease.cloud.services.nos.model.DeleteBucketLifecycleConfigurationRequest;
import com.netease.cloud.services.nos.model.DeleteBucketRequest;
import com.netease.cloud.services.nos.model.DeleteObjectRequest;
import com.netease.cloud.services.nos.model.DeleteObjectsRequest;
import com.netease.cloud.services.nos.model.DeleteObjectsResult;
import com.netease.cloud.services.nos.model.GeneratePresignedUrlRequest;
import com.netease.cloud.services.nos.model.GetBucketAclRequest;
import com.netease.cloud.services.nos.model.GetBucketDedupRequest;
import com.netease.cloud.services.nos.model.GetBucketDedupResult;
import com.netease.cloud.services.nos.model.GetBucketDefault404Request;
import com.netease.cloud.services.nos.model.GetBucketDefault404Result;
import com.netease.cloud.services.nos.model.GetBucketLifecycleConfigurationRequest;
import com.netease.cloud.services.nos.model.GetBucketLocationRequest;
import com.netease.cloud.services.nos.model.GetBucketStatsRequest;
import com.netease.cloud.services.nos.model.GetBucketStatsResult;
import com.netease.cloud.services.nos.model.GetImageMetaInfoRequest;
import com.netease.cloud.services.nos.model.GetImageMode;
import com.netease.cloud.services.nos.model.GetImageRequest;
import com.netease.cloud.services.nos.model.GetObjectMetadataRequest;
import com.netease.cloud.services.nos.model.GetObjectRequest;
import com.netease.cloud.services.nos.model.GetVideoMetaInfoRequest;
import com.netease.cloud.services.nos.model.HeadBucketRequest;
import com.netease.cloud.services.nos.model.ImageMetadata;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadRequest;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadResult;
import com.netease.cloud.services.nos.model.ListBucketsRequest;
import com.netease.cloud.services.nos.model.ListMultipartUploadsRequest;
import com.netease.cloud.services.nos.model.ListObjectsRequest;
import com.netease.cloud.services.nos.model.ListPartsRequest;
import com.netease.cloud.services.nos.model.MediaSaveAsRequest;
import com.netease.cloud.services.nos.model.MoveObjectRequest;
import com.netease.cloud.services.nos.model.MultiObjectDeleteException;
import com.netease.cloud.services.nos.model.MultipartUploadListing;
import com.netease.cloud.services.nos.model.NOSException;
import com.netease.cloud.services.nos.model.NOSObject;
import com.netease.cloud.services.nos.model.NOSObjectInputStream;
import com.netease.cloud.services.nos.model.ObjectListing;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.services.nos.model.PartETag;
import com.netease.cloud.services.nos.model.PartListing;
import com.netease.cloud.services.nos.model.ProgressEvent;
import com.netease.cloud.services.nos.model.ProgressListener;
import com.netease.cloud.services.nos.model.PutBucketDedupRequest;
import com.netease.cloud.services.nos.model.PutBucketDefault404Request;
import com.netease.cloud.services.nos.model.PutObjectMetaRequest;
import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.model.PutObjectResult;
import com.netease.cloud.services.nos.model.Region;
import com.netease.cloud.services.nos.model.SetBucketAclRequest;
import com.netease.cloud.services.nos.model.SetBucketLifecycleConfigurationRequest;
import com.netease.cloud.services.nos.model.UploadPartRequest;
import com.netease.cloud.services.nos.model.UploadPartResult;
import com.netease.cloud.services.nos.model.VideoFrameRequest;
import com.netease.cloud.services.nos.model.VideoMetadata;
import com.netease.cloud.services.nos.model.VideoTranscodingRequest;
import com.netease.cloud.services.nos.model.transform.Unmarshallers;
import com.netease.cloud.services.nos.model.transform.XmlResponsesSaxParser;
import com.netease.cloud.transform.Unmarshaller;
import com.netease.cloud.util.BinaryUtils;
import com.netease.cloud.util.DateUtils;
import com.netease.cloud.util.HttpUtils;
import com.netease.cloud.util.Md5Utils;
import com.netease.cloud.util.json.JSONException;
import com.netease.cloud.util.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NosClient
extends WebServiceClient
implements Nos {
    private static Logger log = LoggerFactory.getLogger(NosClient.class);
    private NosErrorResponseHandler errorResponseHandler = new NosErrorResponseHandler();
    private NosXmlResponseHandler<Void> voidResponseHandler = new NosXmlResponseHandler(null);
    private final BucketNameUtils bucketNameUtils = new BucketNameUtils();
    private CredentialsProvider CredentialsProvider;
    private Map<String, Map<String, String>> specialHeadersMap = new ConcurrentHashMap<String, Map<String, String>>();

    public NosClient() {
        this((Credentials)null);
    }

    public NosClient(Credentials Credentials2) {
        this(Credentials2, new ClientConfiguration());
    }

    public NosClient(Credentials Credentials2, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.CredentialsProvider = new StaticCredentialsProvider(Credentials2);
        this.init();
    }

    public NosClient(CredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public NosClient(CredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.CredentialsProvider = credentialsProvider;
        this.init();
    }

    private void init() {
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/netease/cloud/services/nos/request.handlers"));
    }

    @Override
    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws ClientException, ServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(listObjectsRequest.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        Request<ListObjectsRequest> request = this.createRequest(listObjectsRequest.getBucketName(), null, listObjectsRequest, HttpMethodName.GET);
        if (listObjectsRequest.getPrefix() != null) {
            request.addParameter("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getMarker() != null) {
            request.addParameter("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            request.addParameter("max-keys", listObjectsRequest.getMaxKeys().toString());
        }
        return this.invoke(request, new Unmarshallers.ListObjectsUnmarshaller(), listObjectsRequest.getBucketName(), null);
    }

    @Override
    public GetBucketStatsResult getBucketStats(String bucketName) throws ClientException, ServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when get bucket stats");
        Request<GetBucketStatsRequest> request = this.createRequest(bucketName, null, new GetBucketStatsRequest(), HttpMethodName.GET);
        request.addParameter("bucketstat", null);
        return this.invoke(request, new Unmarshallers.GetBucketStatsUnmarshaller(), bucketName, null);
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws ClientException, ServiceException {
        Request<ListBucketsRequest> request = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.ListBucketsUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets() throws ClientException, ServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public Bucket createBucket(String bucketName) throws ClientException, ServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    @Override
    public Bucket createBucket(String bucketName, Region region, boolean deduplicate) throws ClientException, ServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName, region, deduplicate));
    }

    @Override
    public Bucket createBucket(String bucketName, String region, boolean deduplicate) throws ClientException, ServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName, region, deduplicate));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String bucketName = createBucketRequest.getBucketName();
        String region = createBucketRequest.getRegion();
        boolean deduplicate = createBucketRequest.isDeduplicate();
        CannedAccessControlList acl = createBucketRequest.getCannedAcl();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when creating a bucket");
        if (bucketName != null) {
            bucketName = bucketName.trim();
        }
        this.bucketNameUtils.validateBucketName(bucketName);
        Request<CreateBucketRequest> request = this.createRequest(bucketName, null, createBucketRequest, HttpMethodName.PUT);
        if (acl != null) {
            request.addHeader("x-nos-acl", acl.toString());
        } else {
            request.addHeader("x-nos-acl", CannedAccessControlList.Private.toString());
        }
        XmlWriter xml = new XmlWriter();
        xml.start("CreateBucketConfiguration", "xmlns", "http://nos.netease.com//");
        if (region != null) {
            xml.start("LocationConstraint").value(region).end();
        }
        xml.start("ObjectDeduplicate").value(Boolean.toString(deduplicate)).end();
        xml.end();
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
        return new Bucket(bucketName);
    }

    @Override
    public CannedAccessControlList getBucketAcl(String bucketName) throws ClientException, ServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getBucketAcl(new GetBucketAclRequest(bucketName));
    }

    @Override
    public CannedAccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(getBucketAclRequest, "The getBucketAclRequest parameter must be specified when requesting a bucket's ACL");
        String bucketName = getBucketAclRequest.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's ACL");
        Request<GetBucketAclRequest> request = this.createRequest(bucketName, null, getBucketAclRequest, HttpMethodName.GET);
        request.addParameter("acl", null);
        return this.invoke(request, new NosAclHeaderResponseHnadler(), bucketName, null);
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws ClientException, ServiceException {
        String bucketName = setBucketAclRequest.getBucketName();
        CannedAccessControlList cannedAcl = setBucketAclRequest.getCannedAcl();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting a bucket's ACL");
        this.assertParameterNotNull((Object)cannedAcl, "The cannedAcl parameter must be specified when setting a bucket's ACL");
        Request<SetBucketAclRequest> request = this.createRequest(bucketName, null, setBucketAclRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        request.addHeader("x-nos-acl", cannedAcl.toString());
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws ClientException, ServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting a bucket's ACL");
        this.assertParameterNotNull((Object)acl, "The ACL parameter must be specified when setting a bucket's ACL");
        this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    @Override
    public GetBucketDedupResult getBucketDedup(String bucketName) throws ClientException, ServiceException {
        return this.getBucketDedup(new GetBucketDedupRequest(bucketName));
    }

    @Override
    public GetBucketDedupResult getBucketDedup(GetBucketDedupRequest getBucketDedupRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(getBucketDedupRequest, "The putBucketDedupRequest parameter must be specified when get bucket dedup");
        String bucketName = getBucketDedupRequest.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when get bucket dedup");
        Request<GetBucketDedupRequest> request = this.createRequest(bucketName, null, getBucketDedupRequest, HttpMethodName.GET);
        request.addParameter("deduplication", null);
        return this.invoke(request, new Unmarshallers.GetBucketDedupResultUnmarshaller(), bucketName, null);
    }

    @Override
    public void setBucketDedup(String bucketName, String dedupStatus) throws ClientException, ServiceException {
        this.setBucketDedup(new PutBucketDedupRequest(bucketName, dedupStatus));
    }

    @Override
    public void setBucketDedup(PutBucketDedupRequest putBucketDedupRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(putBucketDedupRequest, "The putBucketDedupRequest parameter must be specified when set bucket dedup");
        String bucketName = putBucketDedupRequest.getBucketName();
        String dedupStatus = putBucketDedupRequest.getDedupStatus();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when set bucket dedup");
        this.assertParameterNotNull(dedupStatus, "The dedupStatus name parameter must be specified when set bucket dedup");
        if (bucketName != null) {
            bucketName = bucketName.trim();
        }
        this.bucketNameUtils.validateBucketName(bucketName);
        Request<PutBucketDedupRequest> request = this.createRequest(bucketName, null, putBucketDedupRequest, HttpMethodName.PUT);
        XmlWriter xml = new XmlWriter();
        xml.start("DeduplicationConfiguration", "xmlns", "http://nos.netease.com//");
        xml.start("Status").value(dedupStatus).end();
        xml.end();
        request.addParameter("deduplication", null);
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    public GetBucketDefault404Result getBucketDefault404(String bucketName) throws ClientException, ServiceException {
        return this.getBucketDefault404(new GetBucketDefault404Request(bucketName));
    }

    public GetBucketDefault404Result getBucketDefault404(GetBucketDefault404Request getBucketDefault404Request) throws ClientException, ServiceException {
        this.assertParameterNotNull(getBucketDefault404Request, "The putBucketDedupRequest parameter must be specified when get bucket default404");
        String bucketName = getBucketDefault404Request.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when get bucket default404");
        Request<GetBucketDefault404Request> request = this.createRequest(bucketName, null, getBucketDefault404Request, HttpMethodName.GET);
        request.addParameter("default404", null);
        return this.invoke(request, new Unmarshallers.GetBucketDefault404Unmarshaller(), bucketName, null);
    }

    public void setBucketDefault404(String bucketName, String default404Object) throws ClientException, ServiceException {
        this.setBucketDefault404(new PutBucketDefault404Request(bucketName, default404Object));
    }

    public void setBucketDefault404(PutBucketDefault404Request putBucketDefault404Request) throws ClientException, ServiceException {
        this.assertParameterNotNull(putBucketDefault404Request, "The putBucketDefault404Request parameter must be specified when set bucket dedup");
        String bucketName = putBucketDefault404Request.getBucketName();
        String default404Object = putBucketDefault404Request.getDefault404Object();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when set bucket default404");
        if (bucketName != null) {
            bucketName = bucketName.trim();
        }
        this.bucketNameUtils.validateBucketName(bucketName);
        Request<PutBucketDefault404Request> request = this.createRequest(bucketName, null, putBucketDefault404Request, HttpMethodName.PUT);
        XmlWriter xml = new XmlWriter();
        xml.start("Default404Configuration", "xmlns", "http://nos.netease.com//");
        xml.start("Key").value(default404Object == null ? "" : default404Object).end();
        xml.end();
        request.addParameter("default404", null);
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public boolean isDeduplicate(DeduplicateRequest deduplicateRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(deduplicateRequest, "The DeduplicateRequest parameter must be specified");
        this.assertParameterNotNull(deduplicateRequest.getBucketName(), "The bucket name parameter must be specified");
        this.assertParameterNotNull(deduplicateRequest.getKey(), "The key parameter must be specified");
        this.assertParameterNotNull(deduplicateRequest.getMD5Digest(), "The MD5Digest parameter must be specified");
        Request<DeduplicateRequest> request = this.createRequest(deduplicateRequest.getBucketName(), deduplicateRequest.getKey(), deduplicateRequest, HttpMethodName.PUT);
        request.addHeader("x-nos-object-md5", deduplicateRequest.getMD5Digest());
        request.addParameter("deduplication", null);
        if (deduplicateRequest.getStorageClass() != null) {
            request.addHeader("x-nos-storage-class", deduplicateRequest.getStorageClass());
        }
        if (deduplicateRequest.getObjectMetadata() != null) {
            NosClient.populateRequestMetadata(request, deduplicateRequest.getObjectMetadata());
        }
        DeduplicateResult result = this.invoke(request, new Unmarshallers.DeduplicateResultUnmarshaller(), deduplicateRequest.getBucketName(), deduplicateRequest.getKey());
        return result.isObjectExist();
    }

    @Override
    public String getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(getBucketLocationRequest, "The request parameter must be specified when requesting a bucket's location");
        String bucketName = getBucketLocationRequest.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's location");
        Request<GetBucketLocationRequest> request = this.createRequest(bucketName, null, getBucketLocationRequest, HttpMethodName.GET);
        request.addParameter("location", null);
        return this.invoke(request, new Unmarshallers.BucketLocationUnmarshaller(), bucketName, null);
    }

    @Override
    public String getBucketLocation(String bucketName) throws ClientException, ServiceException {
        return this.getBucketLocation(new GetBucketLocationRequest(bucketName));
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws ClientException, ServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key));
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String key, String versionId) throws ClientException, ServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key, versionId));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(getObjectMetadataRequest, "The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        String bucketName = getObjectMetadataRequest.getBucketName();
        String key = getObjectMetadataRequest.getKey();
        String versionId = getObjectMetadataRequest.getVersionId();
        Date modifiedSinceConstraint = getObjectMetadataRequest.getModifiedSinceConstraint();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when requesting an object's metadata");
        this.assertParameterNotNull(key, "The key parameter must be specified when requesting an object's metadata");
        Request<GetObjectMetadataRequest> request = this.createRequest(bucketName, key, getObjectMetadataRequest, HttpMethodName.HEAD);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        if (modifiedSinceConstraint != null) {
            NosClient.addDateHeader(request, "If-Modified-Since", getObjectMetadataRequest.getModifiedSinceConstraint());
        }
        return this.invoke(request, new NosMetadataResponseHandler(), bucketName, key);
    }

    @Override
    public NOSObject getObject(String bucketName, String key) throws ClientException, ServiceException {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    @Override
    public boolean doesObjectExist(String bucketName, String key, String versionId) {
        try {
            this.assertParameterNotNull(bucketName, "The bucketName parameter must be specified .");
            this.assertParameterNotNull(key, "The key parameter must be specified .");
            this.getObjectMetadata(bucketName, key, versionId);
            return true;
        }
        catch (ServiceException ase) {
            switch (ase.getStatusCode()) {
                case 403: {
                    throw ase;
                }
                case 404: {
                    return false;
                }
            }
            throw ase;
        }
    }

    @Override
    public boolean doesBucketExist(String bucketName) {
        HeadBucketRequest headBucketRequest = new HeadBucketRequest(bucketName);
        return this.doesBucketExist(headBucketRequest);
    }

    public boolean doesBucketExist(HeadBucketRequest headBucketRequest) {
        try {
            this.assertParameterNotNull(headBucketRequest.getBucketName(), "The bucketName parameter must be specified .");
            Request<HeadBucketRequest> request = this.createRequest(headBucketRequest.getBucketName(), null, headBucketRequest, HttpMethodName.HEAD);
            this.invoke(request, this.voidResponseHandler, headBucketRequest.getBucketName(), null);
            return true;
        }
        catch (ServiceException e) {
            if (this.CredentialsProvider.getCredentials() == null) {
                throw e;
            }
            if ("InvalidAccessKeyId".equalsIgnoreCase(e.getErrorCode()) || "SignatureDoesNotMatch".equalsIgnoreCase(e.getErrorCode())) {
                throw e;
            }
            switch (e.getStatusCode()) {
                case 403: {
                    return true;
                }
                case 404: {
                    return false;
                }
            }
            throw e;
        }
    }

    @Override
    public NOSObject getObject(GetObjectRequest getObjectRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(getObjectRequest, "The GetObjectRequest parameter must be specified when requesting an object");
        this.assertParameterNotNull(getObjectRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object");
        this.assertParameterNotNull(getObjectRequest.getKey(), "The key parameter must be specified when requesting an object");
        Request<GetObjectRequest> request = this.createRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest, HttpMethodName.GET);
        if (getObjectRequest.getVersionId() != null) {
            request.addParameter("versionId", getObjectRequest.getVersionId());
        }
        if (getObjectRequest.getRange() != null) {
            long[] range = getObjectRequest.getRange();
            request.addHeader("Range", "bytes=" + Long.toString(range[0]) + "-" + Long.toString(range[1]));
        }
        NosClient.addDateHeader(request, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        ProgressListener progressListener = getObjectRequest.getProgressListener();
        try {
            NOSObject NOSObject2 = this.invoke(request, new NosObjectResponseHandler(), getObjectRequest.getBucketName(), getObjectRequest.getKey());
            NOSObject2.setBucketName(getObjectRequest.getBucketName());
            NOSObject2.setKey(getObjectRequest.getKey());
            if (progressListener != null) {
                NOSObjectInputStream input = NOSObject2.getObjectContent();
                ProgressReportingInputStream progressReportingInputStream = new ProgressReportingInputStream(input, progressListener);
                progressReportingInputStream.setFireCompletedEvent(true);
                input = new NOSObjectInputStream(progressReportingInputStream, input.getHttpRequest());
                NOSObject2.setObjectContent(input);
                this.fireProgressEvent(progressListener, 1);
            }
            return NOSObject2;
        }
        catch (NOSException ase) {
            if (ase.getStatusCode() == 412 || ase.getStatusCode() == 304) {
                this.fireProgressEvent(progressListener, 8);
                return null;
            }
            this.fireProgressEvent(progressListener, 4);
            throw ase;
        }
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File destinationFile) throws ClientException, ServiceException {
        this.assertParameterNotNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        NOSObject NOSObject2 = this.getObject(getObjectRequest);
        if (NOSObject2 == null) {
            return null;
        }
        ServiceUtils.downloadObjectToFile(NOSObject2, destinationFile);
        return NOSObject2.getObjectMetadata();
    }

    @Override
    public void deleteBucket(String bucketName) throws ClientException, ServiceException {
        this.deleteBucket(new DeleteBucketRequest(bucketName));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(deleteBucketRequest, "The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String bucketName = deleteBucketRequest.getBucketName();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when deleting a bucket");
        Request<DeleteBucketRequest> request = this.createRequest(bucketName, null, deleteBucketRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    public PutObjectResult putObject(String bucketName, File file) throws ClientException, ServiceException {
        return this.putObject(new PutObjectRequest(bucketName, file.getName(), file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, File file) throws ClientException, ServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws ClientException, ServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(putObjectRequest, "The PutObjectRequest parameter must be specified when uploading an object");
        String bucketName = putObjectRequest.getBucketName();
        String key = putObjectRequest.getKey();
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        InputStream input = putObjectRequest.getInputStream();
        ProgressListener progressListener = putObjectRequest.getProgressListener();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when uploading an object");
        if (putObjectRequest.getFile() != null) {
            File file = putObjectRequest.getFile();
            metadata.setContentLength(file.length());
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                byte[] md5Hash = ServiceUtils.computeMD5Hash(fileInputStream);
                metadata.setContentMD5(BinaryUtils.toHex(md5Hash));
            }
            catch (Exception e) {
                throw new ClientException("Unable to calculate MD5 hash: " + e.getMessage(), e);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            try {
                input = new RepeatableFileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new ClientException("Unable to find file to upload", fnfe);
            }
        }
        Request<PutObjectRequest> request = this.createRequest(bucketName, key, putObjectRequest, HttpMethodName.PUT);
        if (putObjectRequest.getCannedAcl() != null) {
            request.addHeader("x-nos-acl", putObjectRequest.getCannedAcl().toString());
        }
        if (putObjectRequest.getStorageClass() != null) {
            request.addHeader("x-nos-storage-class", putObjectRequest.getStorageClass());
        }
        if (key == null) {
            request.addParameter("uploadObject", null);
        }
        if (metadata.getRawMetadata().get("Content-Length") == null) {
            log.warn("No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
        }
        if (progressListener != null) {
            input = new ProgressReportingInputStream(input, progressListener);
            this.fireProgressEvent(progressListener, 1);
        }
        if (!input.markSupported()) {
            input = new RepeatableInputStream(input, 131072);
        }
        MD5DigestCalculatingInputStream md5DigestStream = null;
        if (metadata.getContentMD5() == null) {
            try {
                md5DigestStream = new MD5DigestCalculatingInputStream(input);
                input = md5DigestStream;
            }
            catch (NoSuchAlgorithmException e) {
                log.warn("No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)e);
            }
        }
        if (metadata.getContentType() == null) {
            metadata.setContentType("application/octet-stream");
        }
        NosClient.populateRequestMetadata(request, metadata);
        request.setContent(input);
        ObjectMetadata returnedMetadata = null;
        try {
            returnedMetadata = this.invoke(request, new NosMetadataResponseHandler(), bucketName, key);
        }
        catch (ClientException ace) {
            this.fireProgressEvent(progressListener, 4);
            throw ace;
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {
                log.warn("Unable to cleanly close input stream: " + e.getMessage(), (Throwable)e);
            }
        }
        String contentMd5 = metadata.getContentMD5();
        if (returnedMetadata != null && contentMd5 != null) {
            byte[] serverSideHash;
            byte[] clientSideHash;
            if (md5DigestStream != null) {
                try {
                    clientSideHash = Md5Utils.computeMD5Hash(md5DigestStream.getMd5Digest());
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!Arrays.equals(clientSideHash = contentMd5.getBytes(), serverSideHash = returnedMetadata.getETag().getBytes())) {
                this.fireProgressEvent(progressListener, 4);
                throw new ClientException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by  NOS.  You may need to delete the data stored in  NOS.");
            }
        }
        this.fireProgressEvent(progressListener, 2);
        PutObjectResult result = new PutObjectResult();
        result.setETag(returnedMetadata.getETag());
        result.setVersionId(returnedMetadata.getVersionId());
        result.setExpirationTime(returnedMetadata.getExpirationTime());
        result.setExpirationTimeRuleId(returnedMetadata.getExpirationTimeRuleId());
        result.setObjectName(HttpUtils.urlDecode(returnedMetadata.getObjectName(), true));
        try {
            String callbackRet = returnedMetadata.getCallbackRet();
            if (callbackRet != null) {
                JSONObject retJson = new JSONObject(new String(BinaryUtils.fromBase64(callbackRet)));
                int code = (Integer)retJson.get("Code");
                String message = (String)retJson.get("Message");
                if (code != 0) {
                    result.setCallbackRetCode(code);
                    result.setCallbackRetMessage(new String(BinaryUtils.fromBase64(message)));
                }
            }
        }
        catch (JSONException e) {
            throw new ClientException("Parse x-nos-callback-ret header failed");
        }
        return result;
    }

    @Override
    public void putObjectMeta(String bucketName, String key, ObjectMetadata metadata) throws ClientException, ServiceException {
        this.assertParameterNotNull(bucketName, "The source bucket name must be specified when putObjectMeta");
        this.assertParameterNotNull(key, "The source object key must be specified when putObjectMeta");
        this.assertParameterNotNull(metadata, "The metadata must be specified when putObjectMeta");
        PutObjectMetaRequest putObjectMetaRequest = new PutObjectMetaRequest();
        Request<PutObjectMetaRequest> request = this.createRequest(bucketName, key, putObjectMetaRequest, HttpMethodName.PUT);
        NosClient.populateRequestMetadata(request, metadata);
        request.addParameter("meta", null);
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public void copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws ClientException, ServiceException {
        this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public void copyObject(CopyObjectRequest copyObjectRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
        this.assertParameterNotNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
        String destinationKey = copyObjectRequest.getDestinationKey();
        String destinationBucketName = copyObjectRequest.getDestinationBucketName();
        Request<CopyObjectRequest> request = this.createRequest(destinationBucketName, destinationKey, copyObjectRequest, HttpMethodName.PUT);
        NosClient.populateRequestWithCopyObjectParameters(request, copyObjectRequest);
        request.getHeaders().remove("Content-Length");
        this.invoke(request, this.voidResponseHandler, destinationBucketName, destinationKey);
    }

    @Override
    public void moveObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws ClientException, ServiceException {
        this.moveObject(new MoveObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public void moveObject(MoveObjectRequest moveObjectRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(moveObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
        this.assertParameterNotNull(moveObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
        this.assertParameterNotNull(moveObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
        this.assertParameterNotNull(moveObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
        String destinationKey = moveObjectRequest.getDestinationKey();
        String destinationBucketName = moveObjectRequest.getDestinationBucketName();
        Request<MoveObjectRequest> request = this.createRequest(destinationBucketName, destinationKey, moveObjectRequest, HttpMethodName.PUT);
        String moveSourceHeader = "/" + ServiceUtils.urlEncode(moveObjectRequest.getSourceBucketName()) + "/" + ServiceUtils.urlEncode(moveObjectRequest.getSourceKey());
        if (moveObjectRequest.getSourceVersionId() != null) {
            moveSourceHeader = moveSourceHeader + "?versionId=" + moveObjectRequest.getSourceVersionId();
        }
        request.addHeader("x-nos-move-source", moveSourceHeader);
        this.invoke(request, this.voidResponseHandler, destinationBucketName, destinationKey);
    }

    public void mediaSaveAsObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey, String mediaOperation) {
        this.mediaSaveAsObject(new MediaSaveAsRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey, mediaOperation));
    }

    public void mediaSaveAsObject(MediaSaveAsRequest mediaSaveAsRequest) {
        this.assertParameterNotNull(mediaSaveAsRequest.getSourceBucketName(), "The source bucket name must be specified when mediaSaveas an object");
        this.assertParameterNotNull(mediaSaveAsRequest.getSourceKey(), "The source object key must be specified when mediaSaveas an object");
        this.assertParameterNotNull(mediaSaveAsRequest.getDestinationBucketName(), "The destination bucket name must be specified when mediaSaveas an object");
        this.assertParameterNotNull(mediaSaveAsRequest.getDestinationKey(), "The destination object key must be specified when mediaSaveas an object");
        String destinationKey = mediaSaveAsRequest.getDestinationKey();
        String destinationBucketName = mediaSaveAsRequest.getDestinationBucketName();
        Request<MediaSaveAsRequest> request = this.createRequest(destinationBucketName, destinationKey, mediaSaveAsRequest, HttpMethodName.PUT);
        String mediaOpSourceHeader = "/" + ServiceUtils.urlEncode(mediaSaveAsRequest.getSourceBucketName()) + "/" + ServiceUtils.urlEncode(mediaSaveAsRequest.getSourceKey());
        request.addHeader("x-nos-media-source", mediaOpSourceHeader);
        request.addHeader("x-nos-media-op", ServiceUtils.urlEncode(mediaSaveAsRequest.getMediaOperation()));
        this.invoke(request, this.voidResponseHandler, destinationBucketName, destinationKey);
    }

    @Override
    public void deleteObject(String bucketName, String key) throws ClientException, ServiceException {
        this.deleteObject(new DeleteObjectRequest(bucketName, key));
    }

    @Override
    public void deleteObject(String bucketName, String key, String versionId) throws ClientException, ServiceException {
        this.deleteObject(new DeleteObjectRequest(bucketName, key, versionId));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(deleteObjectRequest, "The delete object request must be specified when deleting an object");
        this.assertParameterNotNull(deleteObjectRequest.getBucketName(), "The bucket name must be specified when deleting an object");
        this.assertParameterNotNull(deleteObjectRequest.getKey(), "The key must be specified when deleting an object");
        String versionId = deleteObjectRequest.getVersionId();
        Request<DeleteObjectRequest> request = this.createRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey(), deleteObjectRequest, HttpMethodName.DELETE);
        request.addParameter("versionId", versionId);
        this.invoke(request, this.voidResponseHandler, deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey());
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        Request<DeleteObjectsRequest> request = this.createRequest(deleteObjectsRequest.getBucketName(), null, deleteObjectsRequest, HttpMethodName.POST);
        request.addParameter("delete", null);
        XmlWriter xml = new XmlWriter();
        xml.start("Delete");
        if (deleteObjectsRequest.getQuiet()) {
            xml.start("Quiet").value("true").end();
        } else {
            xml.start("Quiet").value("false").end();
        }
        for (DeleteObjectsRequest.KeyVersion keyVersion : deleteObjectsRequest.getKeys()) {
            xml.start("Object");
            xml.start("Key").value(keyVersion.getKey()).end();
            if (keyVersion.getVersion() != null) {
                xml.start("VersionId").value(keyVersion.getVersion()).end();
            }
            xml.end();
        }
        xml.end();
        byte[] content = xml.getBytes();
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = ServiceUtils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toHex(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new ClientException("Couldn't compute md5 sum", e);
        }
        DeleteObjectsResponse response = this.invoke(request, new Unmarshallers.DeleteObjectsResultUnmarshaller(), deleteObjectsRequest.getBucketName(), null);
        if (!response.getErrors().isEmpty()) {
            throw new MultiObjectDeleteException(response.getErrors(), response.getDeletedObjects());
        }
        return new DeleteObjectsResult(response.getDeletedObjects());
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws ClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, HttpMethod.GET);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethod method) throws ClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, method);
        request.setExpiration(expiration);
        return this.generatePresignedUrl(request);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest generatePresignedUrlRequest) throws ClientException {
        this.assertParameterNotNull(generatePresignedUrlRequest, "The request parameter must be specified when generating a pre-signed URL");
        String bucketName = generatePresignedUrlRequest.getBucketName();
        String key = generatePresignedUrlRequest.getKey();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when generating a pre-signed URL");
        this.assertParameterNotNull((Object)generatePresignedUrlRequest.getMethod(), "The HTTP method request parameter must be specified when generating a pre-signed URL");
        if (generatePresignedUrlRequest.getExpiration() == null) {
            generatePresignedUrlRequest.setExpiration(new Date(System.currentTimeMillis() + 900000L));
        }
        HttpMethodName httpMethod = HttpMethodName.valueOf(generatePresignedUrlRequest.getMethod().toString());
        Request<GeneratePresignedUrlRequest> request = this.createRequest(bucketName, key, generatePresignedUrlRequest, httpMethod);
        for (Map.Entry<String, String> entry : generatePresignedUrlRequest.getRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        this.presignRequest(request, generatePresignedUrlRequest.getMethod(), bucketName, key, generatePresignedUrlRequest.getExpiration(), null);
        if (generatePresignedUrlRequest.getDownload() != null) {
            String download = generatePresignedUrlRequest.getDownload();
            if (download.length() > 256) {
                throw new IllegalArgumentException("Download parameter should be less than 256 characters");
            }
            request.addParameter("download", download);
        }
        if (generatePresignedUrlRequest.getIfNotFound() != null) {
            String ifNotFound = generatePresignedUrlRequest.getIfNotFound();
            request.addParameter("ifNotFound", ifNotFound);
        }
        return ServiceUtils.convertRequestToUrl(request);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(abortMultipartUploadRequest, "The request parameter must be specified when aborting a multipart upload");
        this.assertParameterNotNull(abortMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when aborting a multipart upload");
        this.assertParameterNotNull(abortMultipartUploadRequest.getKey(), "The key parameter must be specified when aborting a multipart upload");
        this.assertParameterNotNull(abortMultipartUploadRequest.getUploadId(), "The upload ID parameter must be specified when aborting a multipart upload");
        String bucketName = abortMultipartUploadRequest.getBucketName();
        String key = abortMultipartUploadRequest.getKey();
        Request<AbortMultipartUploadRequest> request = this.createRequest(bucketName, key, abortMultipartUploadRequest, HttpMethodName.DELETE);
        request.addParameter("uploadId", abortMultipartUploadRequest.getUploadId());
        this.specialHeadersMap.remove(abortMultipartUploadRequest.getBucketName() + abortMultipartUploadRequest.getKey());
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(completeMultipartUploadRequest, "The request parameter must be specified when completing a multipart upload");
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String key = completeMultipartUploadRequest.getKey();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(key, "The key parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(uploadId, "The upload ID parameter must be specified when completing a multipart upload");
        this.assertParameterNotNull(completeMultipartUploadRequest.getPartETags(), "The part ETags parameter must be specified when completing a multipart upload");
        Request<CompleteMultipartUploadRequest> request = this.createRequest(bucketName, key, completeMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploadId", uploadId);
        if (this.specialHeadersMap.get(completeMultipartUploadRequest.getBucketName() + completeMultipartUploadRequest.getKey()) != null) {
            Map<String, String> headers = this.specialHeadersMap.get(completeMultipartUploadRequest.getBucketName() + completeMultipartUploadRequest.getKey());
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String k = entry.getKey();
                String value = entry.getValue();
                completeMultipartUploadRequest.addSpecialHeader(k, value);
            }
            this.specialHeadersMap.remove(completeMultipartUploadRequest.getBucketName() + completeMultipartUploadRequest.getKey());
        }
        List<PartETag> partETags = completeMultipartUploadRequest.getPartETags();
        XmlWriter xml = new XmlWriter();
        xml.start("CompleteMultipartUpload");
        if (partETags != null) {
            Collections.sort(partETags, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag o1, PartETag o2) {
                    return o1.getPartNumber() < o2.getPartNumber() ? -1 : (o1.getPartNumber() == o2.getPartNumber() ? 0 : 1);
                }
            });
            for (PartETag partEtag : partETags) {
                xml.start("Part");
                xml.start("PartNumber").value(Integer.toString(partEtag.getPartNumber())).end();
                xml.start("ETag").value(partEtag.getETag()).end();
                xml.end();
            }
        }
        xml.end();
        byte[] byArray = xml.getBytes();
        request.addHeader("Content-Type", "text/plain");
        request.addHeader("Content-Length", String.valueOf(byArray.length));
        if (completeMultipartUploadRequest.getxNosObjectMD5() != null) {
            request.addHeader("x-nos-object-md5", completeMultipartUploadRequest.getxNosObjectMD5());
        }
        request.setContent(new ByteArrayInputStream(byArray));
        ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler> responseHandler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler>(new Unmarshallers.CompleteMultipartUploadResultUnmarshaller(), new ObjectExpirationHeaderHandler());
        XmlResponsesSaxParser.CompleteMultipartUploadHandler handler = (XmlResponsesSaxParser.CompleteMultipartUploadHandler)this.invoke(request, responseHandler, bucketName, key);
        if (handler.getCompleteMultipartUploadResult() != null) {
            String versionId = responseHandler.getResponseHeaders().get("x-nos-version-id");
            try {
                String callbackRet = responseHandler.getResponseHeaders().get("x-nos-callback-ret");
                if (callbackRet != null) {
                    JSONObject retJson = new JSONObject(new String(BinaryUtils.fromBase64(callbackRet)));
                    int code = (Integer)retJson.get("Code");
                    String message = (String)retJson.get("Message");
                    if (code != 0) {
                        handler.getCompleteMultipartUploadResult().setCallbackRetCode(code);
                        handler.getCompleteMultipartUploadResult().setCallbackRetMessage(new String(BinaryUtils.fromBase64(message)));
                    }
                }
            }
            catch (JSONException e) {
                throw new ClientException("Parse x-nos-callback-ret header failed");
            }
            handler.getCompleteMultipartUploadResult().setVersionId(versionId);
            return handler.getCompleteMultipartUploadResult();
        }
        throw handler.getNOSException();
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws ClientException, ServiceException {
        String v;
        String k;
        this.assertParameterNotNull(initiateMultipartUploadRequest, "The request parameter must be specified when initiating a multipart upload");
        this.assertParameterNotNull(initiateMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when initiating a multipart upload");
        this.assertParameterNotNull(initiateMultipartUploadRequest.getKey(), "The key parameter must be specified when initiating a multipart upload");
        Request<InitiateMultipartUploadRequest> request = this.createRequest(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), initiateMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploads", null);
        if (initiateMultipartUploadRequest.getStorageClass() != null) {
            request.addHeader("x-nos-storage-class", initiateMultipartUploadRequest.getStorageClass().toString());
        }
        if (initiateMultipartUploadRequest.getCannedACL() != null) {
            request.addHeader("x-nos-acl", initiateMultipartUploadRequest.getCannedACL().toString());
        }
        if (initiateMultipartUploadRequest.objectMetadata != null) {
            NosClient.populateRequestMetadata(request, initiateMultipartUploadRequest.objectMetadata);
        }
        HashMap<String, String> userHeaders = new HashMap<String, String>();
        if (initiateMultipartUploadRequest.copyPrivateRequestParameters() != null) {
            for (Map.Entry<String, String> entry : initiateMultipartUploadRequest.copyPrivateRequestParameters().entrySet()) {
                k = entry.getKey();
                v = entry.getValue();
                if (!"Content-Type".equals(k) && !"Content-Encoding".equals(k) && !"Cache-Control".equals(k) && !"Content-Disposition".equals(k) && !"Content-Language".equals(k) && !"Expires".equals(k) && !k.contains("x-nos-meta")) continue;
                userHeaders.put(k, v);
            }
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            k = entry.getKey();
            v = entry.getValue();
            if (!"Content-Type".equals(k) && !"Content-Encoding".equals(k) && !"Cache-Control".equals(k) && !"Content-Disposition".equals(k) && !"Content-Language".equals(k) && !"Expires".equals(k) && !k.contains("x-nos-meta")) continue;
            userHeaders.put(k, v);
        }
        if (userHeaders.size() > 0) {
            this.specialHeadersMap.put(initiateMultipartUploadRequest.getBucketName() + initiateMultipartUploadRequest.getKey(), userHeaders);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        request.addHeader("Content-Length", "0");
        if (initiateMultipartUploadRequest.getMD5Digest() != null) {
            request.addHeader("Content-MD5", initiateMultipartUploadRequest.getMD5Digest());
        }
        ResponseHeaderHandlerChain<InitiateMultipartUploadResult> responseHandler = new ResponseHeaderHandlerChain<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller(), new HeaderHandler[0]);
        return (InitiateMultipartUploadResult)this.invoke(request, responseHandler, initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey());
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(listMultipartUploadsRequest, "The request parameter must be specified when listing multipart uploads");
        this.assertParameterNotNull(listMultipartUploadsRequest.getBucketName(), "The bucket name parameter must be specified when listing multipart uploads");
        Request<ListMultipartUploadsRequest> request = this.createRequest(listMultipartUploadsRequest.getBucketName(), null, listMultipartUploadsRequest, HttpMethodName.GET);
        request.addParameter("uploads", null);
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            request.addParameter("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if (listMultipartUploadsRequest.getMaxUploads() != null) {
            request.addParameter("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            request.addParameter("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            request.addParameter("prefix", listMultipartUploadsRequest.getPrefix());
        }
        return this.invoke(request, new Unmarshallers.ListMultipartUploadsResultUnmarshaller(), listMultipartUploadsRequest.getBucketName(), null);
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(listPartsRequest, "The request parameter must be specified when listing parts");
        this.assertParameterNotNull(listPartsRequest.getBucketName(), "The bucket name parameter must be specified when listing parts");
        this.assertParameterNotNull(listPartsRequest.getKey(), "The key parameter must be specified when listing parts");
        this.assertParameterNotNull(listPartsRequest.getUploadId(), "The upload ID parameter must be specified when listing parts");
        Request<ListPartsRequest> request = this.createRequest(listPartsRequest.getBucketName(), listPartsRequest.getKey(), listPartsRequest, HttpMethodName.GET);
        request.addParameter("uploadId", listPartsRequest.getUploadId());
        if (listPartsRequest.getMaxParts() != null) {
            request.addParameter("max-parts", listPartsRequest.getMaxParts().toString());
        }
        if (listPartsRequest.getPartNumberMarker() != null) {
            request.addParameter("part-number-marker", listPartsRequest.getPartNumberMarker().toString());
        }
        return this.invoke(request, new Unmarshallers.ListPartsResultUnmarshaller(), listPartsRequest.getBucketName(), listPartsRequest.getKey());
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws ClientException, ServiceException {
        ProgressListener progressListener;
        this.assertParameterNotNull(uploadPartRequest, "The request parameter must be specified when uploading a part");
        String bucketName = uploadPartRequest.getBucketName();
        String key = uploadPartRequest.getKey();
        String uploadId = uploadPartRequest.getUploadId();
        int partNumber = uploadPartRequest.getPartNumber();
        long partSize = uploadPartRequest.getPartSize();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when uploading a part");
        this.assertParameterNotNull(key, "The key parameter must be specified when uploading a part");
        this.assertParameterNotNull(uploadId, "The upload ID parameter must be specified when uploading a part");
        this.assertParameterNotNull(partNumber, "The part number parameter must be specified when uploading a part");
        this.assertParameterNotNull(partSize, "The part size parameter must be specified when uploading a part");
        Request<UploadPartRequest> request = this.createRequest(bucketName, key, uploadPartRequest, HttpMethodName.PUT);
        request.addParameter("uploadId", uploadId);
        request.addParameter("partNumber", Integer.toString(partNumber));
        if (uploadPartRequest.getMd5Digest() != null) {
            request.addHeader("Content-MD5", uploadPartRequest.getMd5Digest());
        }
        request.addHeader("Content-Length", Long.toString(partSize));
        InputStream inputStream = null;
        if (uploadPartRequest.getInputStream() != null) {
            inputStream = uploadPartRequest.getInputStream();
        } else if (uploadPartRequest.getFile() != null) {
            try {
                inputStream = new InputSubstream(new RepeatableFileInputStream(uploadPartRequest.getFile()), uploadPartRequest.getFileOffset(), partSize, true);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("The specified file doesn't exist", e);
            }
        } else {
            throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
        }
        MD5DigestCalculatingInputStream md5DigestStream = null;
        if (uploadPartRequest.getMd5Digest() == null) {
            try {
                md5DigestStream = new MD5DigestCalculatingInputStream(inputStream);
                inputStream = md5DigestStream;
            }
            catch (NoSuchAlgorithmException e) {
                log.warn("No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)e);
            }
        }
        if ((progressListener = uploadPartRequest.getProgressListener()) != null) {
            inputStream = new ProgressReportingInputStream(inputStream, progressListener);
            this.fireProgressEvent(progressListener, 1024);
        }
        try {
            byte[] serverSideHash;
            String contentMd5;
            byte[] clientSideHash;
            request.setContent(inputStream);
            ObjectMetadata metadata = this.invoke(request, new NosMetadataResponseHandler(), bucketName, key);
            if (metadata != null && md5DigestStream != null && !Arrays.equals(clientSideHash = BinaryUtils.fromBase64(contentMd5 = BinaryUtils.toBase64(md5DigestStream.getMd5Digest())), serverSideHash = BinaryUtils.fromHex(metadata.getETag()))) {
                this.fireProgressEvent(progressListener, 4);
                throw new ClientException("Unable to verify integrity of data upload.  Client calculated content hash didn't match hash calculated by NOS.  You may need to delete the data stored in  NOS.");
            }
            this.fireProgressEvent(progressListener, 2048);
            UploadPartResult result = new UploadPartResult();
            result.setETag(metadata.getETag());
            result.setPartNumber(partNumber);
            UploadPartResult uploadPartResult = result;
            return uploadPartResult;
        }
        catch (ClientException ace) {
            this.fireProgressEvent(progressListener, 4096);
            throw ace;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void fireProgressEvent(ProgressListener listener, int eventType) {
        if (listener == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0);
        event.setEventCode(eventType);
        listener.progressChanged(event);
    }

    protected <T> void presignRequest(Request<T> request, HttpMethod methodName, String bucketName, String key, Date expiration, String subResource) {
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                requestHandler.beforeRequest(request);
            }
        }
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? ServiceUtils.urlEncode(key) : "") + (subResource != null ? "?" + subResource : "");
        Credentials credentials = this.CredentialsProvider.getCredentials();
        WebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        new NosQueryStringSigner(methodName.toString(), resourcePath, expiration).sign(request, credentials);
        if (request.getHeaders().containsKey("x-nos-security-token")) {
            String value = request.getHeaders().get("x-nos-security-token");
            request.addParameter("x-nos-security-token", value);
            request.getHeaders().remove("x-nos-security-token");
        }
    }

    private URI convertToPathStyleEndpoint() {
        try {
            return new URI(this.endpoint.getScheme() + "://" + this.endpoint.getAuthority() + Constants.PROJECT_NAME);
        }
        catch (URISyntaxException e) {
            throw new ClientException("Can't turn bucket name into a URI: " + e.getMessage(), e);
        }
    }

    protected static void populateRequestMetadata(Request<?> request, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                if (entry.getValue() == null) continue;
                request.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                request.addHeader("x-nos-meta-" + key, value);
            }
        }
    }

    private static void populateRequestWithCopyObjectParameters(Request<?> request, CopyObjectRequest copyObjectRequest) {
        ObjectMetadata newObjectMetadata;
        String copySourceHeader = "/" + ServiceUtils.urlEncode(copyObjectRequest.getSourceBucketName()) + "/" + ServiceUtils.urlEncode(copyObjectRequest.getSourceKey());
        if (copyObjectRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyObjectRequest.getSourceVersionId();
        }
        request.addHeader("x-nos-copy-source", copySourceHeader);
        if (copyObjectRequest.getCannedAccessControlList() != null) {
            request.addHeader("x-nos-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            request.addHeader("x-nos-storage-class", copyObjectRequest.getStorageClass());
        }
        if ((newObjectMetadata = copyObjectRequest.getNewObjectMetadata()) != null) {
            NosClient.populateRequestMetadata(request, newObjectMetadata);
        }
    }

    private static void addDateHeader(Request<?> request, String header, Date value) {
        if (value != null) {
            request.addHeader(header, ServiceUtils.formatRfc822Date(value));
        }
    }

    protected <X extends WebServiceRequest> Request<X> createRequest(String bucketName, String key, X originalRequest, HttpMethodName httpMethod) {
        if (this.endpoint == null) {
            throw new ClientException("Please set the endpoint, the default endpoint is no longer supported in the new version SDK.");
        }
        DefaultRequest request = new DefaultRequest(originalRequest, Constants.NOS_SERVICE_NAME);
        request.setHttpMethod(httpMethod);
        if (this.clientConfiguration.getIsSubdomain() == Boolean.TRUE.booleanValue()) {
            if (this.bucketNameUtils.isDNSBucketName(bucketName)) {
                request.setEndpoint(this.convertToVirtualHostEndpoint(bucketName));
                request.setResourcePath(ServiceUtils.urlEncode(key));
            } else {
                request.setEndpoint(this.endpoint);
                if (bucketName != null) {
                    request.setResourcePath(bucketName + "/" + (key != null ? ServiceUtils.urlEncode(key) : ""));
                }
            }
        } else {
            try {
                request.setEndpoint(new URI(this.endpoint.getScheme() + "://" + this.endpoint.getAuthority()));
            }
            catch (URISyntaxException e) {
                throw new ClientException("Can't turn project name into a URI: " + e.getMessage(), e);
            }
            if (bucketName != null) {
                request.setResourcePath(bucketName + "/" + (key != null ? ServiceUtils.urlEncode(key) : ""));
            }
        }
        if (originalRequest.needSetLogInfo()) {
            request.addParameter("logid", originalRequest.getLogID());
            request.addParameter("logseq", originalRequest.getLogSeq());
        }
        return request;
    }

    private URI convertToVirtualHostEndpoint(String bucketName) {
        try {
            return new URI(this.endpoint.getScheme() + "://" + bucketName + "." + this.endpoint.getAuthority());
        }
        catch (URISyntaxException e) {
            throw new ClientException("Can't turn bucket name into a URI: " + e.getMessage(), e);
        }
    }

    private <X, Y extends WebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, InputStream> unmarshaller, String bucketName, String key) {
        return this.invoke(request, new NosXmlResponseHandler<X>(unmarshaller), bucketName, key);
    }

    private <X, Y extends WebServiceRequest> InputStream invoke(Request<Y> request, String bucketName, String key) {
        return this.invoke(request, new SimpleDataResponseHandler(), bucketName, key);
    }

    private <X, Y extends WebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<WebServiceResponse<X>> responseHandler, String bucket, String key) {
        if (request.getOriginalRequest().copyPrivateRequestParameters() != null) {
            for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (request.getHeaders().get("Content-Type") == null) {
            request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        }
        Credentials credentials = this.CredentialsProvider.getCredentials();
        WebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.createSigner(request, bucket, key));
        executionContext.setCredentials(credentials);
        executionContext.setToken(originalRequest.getToken());
        return (X)this.client.execute(request, responseHandler, this.errorResponseHandler, executionContext);
    }

    protected Signer createSigner(Request<?> request, String bucketName, String key) {
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? ServiceUtils.urlEncode(key) : "");
        return new NosSigner(request.getHttpMethod().toString(), resourcePath);
    }

    @Override
    public ImageMetadata getImageInfo(String bucketName, String key) throws ClientException, ServiceException {
        return this.getImageInfo(new GetImageMetaInfoRequest(bucketName, key));
    }

    private ImageMetadata getImageInfo(GetImageMetaInfoRequest getImageMetaInfoRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(getImageMetaInfoRequest, "The GetImageMetaInfoRequest parameter must be specified");
        this.assertParameterNotNull(getImageMetaInfoRequest.getBucketName(), "The bucket name parameter must be specified");
        this.assertParameterNotNull(getImageMetaInfoRequest.getKey(), "The key name parameter must be specified");
        Request<GetImageMetaInfoRequest> request = this.createRequest(getImageMetaInfoRequest.getBucketName(), getImageMetaInfoRequest.getKey(), getImageMetaInfoRequest, HttpMethodName.GET);
        request.addParameter("imageInfo", "");
        return this.invoke(request, new Unmarshallers.GetImageMetaInfoUnmarshaller(), getImageMetaInfoRequest.getBucketName(), getImageMetaInfoRequest.getKey());
    }

    @Override
    public InputStream getImage(String bucketName, String key) throws ClientException, ServiceException {
        return this.getImage(new GetImageRequest(bucketName, key));
    }

    @Override
    public InputStream getImage(GetImageRequest getImageRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(getImageRequest, "The GetImageRequest  parameter must be specified");
        this.assertParameterNotNull(getImageRequest.getBucketName(), "The bucket name parameter must be specified");
        this.assertParameterNotNull(getImageRequest.getKey(), "The key parameter must be specified");
        Request<GetImageRequest> request = this.createRequest(getImageRequest.getBucketName(), getImageRequest.getKey(), getImageRequest, HttpMethodName.GET);
        request.addParameter("imageView", "");
        String modeString = GetImageMode.XMODE == getImageRequest.getMode() ? "x" : (GetImageMode.YMODE == getImageRequest.getMode() ? "y" : (GetImageMode.ZMODE == getImageRequest.getMode() ? "z" : (GetImageMode.WMODE == getImageRequest.getMode() ? "w" : null)));
        if (-1 != getImageRequest.getResizeX() || -1 != getImageRequest.getResizeY()) {
            if (modeString != null) {
                request.addParameter("thumbnail", getImageRequest.getResizeX() + modeString + getImageRequest.getResizeY());
            } else {
                throw new IllegalArgumentException("the 'mode' param shoud be assigned");
            }
        }
        if (-1 != getImageRequest.getPixel()) {
            request.addParameter("pixel", Integer.toString(getImageRequest.getPixel()));
        }
        if (getImageRequest.CheckCropParam().booleanValue()) {
            request.addParameter("crop", getImageRequest.getCropX() + "_" + getImageRequest.getCropY() + "_" + getImageRequest.getCropWidth() + "_" + getImageRequest.getCropHeight());
        }
        if (-1 != getImageRequest.getQuality()) {
            request.addParameter("quality", Integer.toString(getImageRequest.getQuality()));
        }
        if (null != getImageRequest.getType()) {
            request.addParameter("type", getImageRequest.getType());
        }
        String code = null;
        if (null != getImageRequest.getWaterMark()) {
            try {
                code = new String(Base64.encodeBase64((byte[])getImageRequest.getWaterMark().getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("UnsupportedEncodingException");
            }
            request.addParameter("watermark", code);
        }
        if (-1 != getImageRequest.getAxis()) {
            request.addParameter("axis", Integer.toString(getImageRequest.getAxis()));
        }
        if (-1 != getImageRequest.getRotation()) {
            request.addParameter("rotate", Integer.toString(getImageRequest.getRotation()));
        }
        if (-1 != getImageRequest.getInterlace()) {
            request.addParameter("interlace", Integer.toString(getImageRequest.getInterlace()));
        }
        return this.invoke(request, getImageRequest.getBucketName(), getImageRequest.getKey());
    }

    @Override
    public InputStream videoFrame(String bucketName, String key) throws ClientException, ServiceException {
        return this.videoFrame(new VideoFrameRequest(bucketName, key));
    }

    @Override
    public InputStream videoFrame(VideoFrameRequest videoFrameRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(videoFrameRequest, "The ResizeImageRequest parameter must be specified");
        this.assertParameterNotNull(videoFrameRequest.getBucketName(), "The bucket name parameter must be specified");
        this.assertParameterNotNull(videoFrameRequest.getKey(), "The key parameter must be specified");
        Request<VideoFrameRequest> request = this.createRequest(videoFrameRequest.getBucketName(), videoFrameRequest.getKey(), videoFrameRequest, HttpMethodName.GET);
        request.addParameter("vframe", "1");
        if (-1L != videoFrameRequest.getOffet()) {
            request.addParameter("offset", Long.toString(videoFrameRequest.getOffet()));
        }
        if (-1 != videoFrameRequest.getResizeX() && -1 != videoFrameRequest.getResizeY()) {
            if (videoFrameRequest.getResizeX() <= 0 && videoFrameRequest.getResizeY() <= 0) {
                throw new IllegalArgumentException("Invaild resize parameter");
            }
            request.addParameter("resize", videoFrameRequest.getResizeX() + "x" + videoFrameRequest.getResizeY());
        }
        if (null != videoFrameRequest.getDefaultCorp()) {
            if (Boolean.TRUE.equals(videoFrameRequest.getDefaultCorp())) {
                request.addParameter("corp", "");
            } else {
                if (videoFrameRequest.getLeft() >= videoFrameRequest.getRight() || videoFrameRequest.getTop() >= videoFrameRequest.getBottom()) {
                    throw new IllegalArgumentException("Invaild crop range");
                }
                request.addParameter("corp", videoFrameRequest.getLeft() + "_" + videoFrameRequest.getTop() + "_" + videoFrameRequest.getRight() + "_" + videoFrameRequest.getBottom());
            }
        }
        return this.invoke(request, videoFrameRequest.getBucketName(), videoFrameRequest.getKey());
    }

    @Override
    public VideoMetadata getVideoMetaInfo(String bucketName, String key) throws ClientException, ServiceException {
        return this.getVideoMetaInfo(new GetVideoMetaInfoRequest(bucketName, key));
    }

    private VideoMetadata getVideoMetaInfo(GetVideoMetaInfoRequest getVideoMetaInfoRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(getVideoMetaInfoRequest.getBucketName(), "The bucket name parameter must be specified");
        this.assertParameterNotNull(getVideoMetaInfoRequest.getKey(), "The key parameter must be specified");
        Request<GetVideoMetaInfoRequest> request = this.createRequest(getVideoMetaInfoRequest.getBucketName(), getVideoMetaInfoRequest.getKey(), getVideoMetaInfoRequest, HttpMethodName.GET);
        request.addParameter("vinfo", "");
        return this.invoke(request, new Unmarshallers.GetVideoMetaInfoUnmarshaller(), getVideoMetaInfoRequest.getBucketName(), getVideoMetaInfoRequest.getKey());
    }

    @Override
    public void VideoTranscoding(VideoTranscodingRequest videoTranscodingRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(videoTranscodingRequest.getBucketName(), "The bucket name parameter must be specified");
        this.assertParameterNotNull(videoTranscodingRequest.getKey(), "The key parameter must be specified");
        this.assertParameterNotNull(videoTranscodingRequest.getType(), "The type parameter must be specified");
        this.assertParameterNotNull(videoTranscodingRequest.getCallBackURL(), "The callBackURL parameter must be specified");
        Request<VideoTranscodingRequest> request = this.createRequest(videoTranscodingRequest.getBucketName(), videoTranscodingRequest.getKey(), videoTranscodingRequest, HttpMethodName.POST);
        request.addParameter("type", videoTranscodingRequest.getType());
        if (videoTranscodingRequest.getResolutionX() != -1 && videoTranscodingRequest.getResolutionY() != -1) {
            request.addParameter("resolution", videoTranscodingRequest.getResolutionX() + "x" + videoTranscodingRequest.getResolutionY());
        }
        if (videoTranscodingRequest.getFps() != -1) {
            request.addParameter("fps", videoTranscodingRequest.getFps() + "");
        }
        if (videoTranscodingRequest.getVCodec() != null) {
            request.addParameter("vcodec", videoTranscodingRequest.getVCodec());
        }
        if (videoTranscodingRequest.getACodec() != null) {
            request.addParameter("acodec", videoTranscodingRequest.getACodec());
        }
        if (videoTranscodingRequest.getOffset() != -1) {
            request.addParameter("offset", videoTranscodingRequest.getOffset() + "");
        }
        if (videoTranscodingRequest.getLength() != -1) {
            request.addParameter("length", videoTranscodingRequest.getLength() + "");
        }
        if (!videoTranscodingRequest.getDefaultCrop().booleanValue()) {
            if (videoTranscodingRequest.checkCropParam().booleanValue()) {
                request.addParameter("crop", videoTranscodingRequest.genCropString());
            } else {
                throw new IllegalArgumentException("Invaild crop range");
            }
        }
        if (videoTranscodingRequest.getSegtime() != -1) {
            request.addParameter("segtime", videoTranscodingRequest.getSegtime() + "");
        }
        request.addHeader("x-nos-codec-source", "/" + videoTranscodingRequest.getBucketName() + "/" + videoTranscodingRequest.getKey());
        request.addHeader("x-nos-callbackurl", videoTranscodingRequest.getCallBackURL());
        this.invoke(request, this.voidResponseHandler, videoTranscodingRequest.getBucketName(), videoTranscodingRequest.getKey());
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) throws ClientException, ServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name must be specifed when retrieving the bucket lifecycle configuration.");
        Request<GetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, new GetBucketLifecycleConfigurationRequest(), HttpMethodName.GET);
        request.addParameter("lifecycle", null);
        return this.invoke(request, new Unmarshallers.BucketLifecycleConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public void setBucketLifecycleConfiguration(String bucketName, BucketLifecycleConfiguration bucketLifecycleConfiguration) throws ClientException, ServiceException {
        this.setBucketLifecycleConfiguration(new SetBucketLifecycleConfigurationRequest(bucketName, bucketLifecycleConfiguration));
    }

    @Override
    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest) throws ClientException, ServiceException {
        this.assertParameterNotNull(setBucketLifecycleConfigurationRequest, "The set bucket lifecycle configuration request object must be specified.");
        String bucketName = setBucketLifecycleConfigurationRequest.getBucketName();
        BucketLifecycleConfiguration bucketLifecycleConfiguration = setBucketLifecycleConfigurationRequest.getLifecycleConfiguration();
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when setting bucket lifecycle configuration.");
        this.assertParameterNotNull(bucketLifecycleConfiguration, "The lifecycle configuration parameter must be specified when setting bucket lifecycle configuration.");
        this.assertParameterNotNull(bucketLifecycleConfiguration.getRules(), "bucketLifecycleConfiguration.getRules() is null, The rules must be specified when setting bucket lifecycle configuration.");
        Request<SetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, setBucketLifecycleConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("lifecycle", null);
        XmlWriter xml = new XmlWriter();
        xml.start("LifecycleConfiguration");
        for (BucketLifecycleConfiguration.Rule rule : bucketLifecycleConfiguration.getRules()) {
            xml.start("Rule");
            if (rule.getId() != null) {
                xml.start("ID").value(rule.getId()).end();
            }
            if (rule.getPrefix() != null) {
                xml.start("Prefix").value(rule.getPrefix()).end();
            }
            if (rule.getStatus() != null) {
                xml.start("Status").value(rule.getStatus()).end();
            }
            xml.start("Expiration");
            if (rule.getExpirationInDays() != null) {
                xml.start("Days").value(Integer.toString(rule.getExpirationInDays())).end();
            }
            if (rule.getExpirationDate() != null) {
                xml.start("Date").value(new DateUtils().formatIso8601DateUTC(rule.getExpirationDate())).end();
            }
            xml.end();
            xml.end();
        }
        xml.end();
        byte[] xmlByte = xml.getBytes();
        request.addHeader("Content-Length", String.valueOf(xmlByte.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(xmlByte));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(xmlByte);
            request.addHeader("Content-MD5", Md5Utils.getHex(md5));
        }
        catch (Exception e) {
            throw new ClientException("Couldn't compute md5 sum", e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketLifecycleConfiguration(String bucketName) throws ClientException, ServiceException {
        this.assertParameterNotNull(bucketName, "The bucket name parameter must be specified when deleting bucket lifecycle configuration.");
        Request<DeleteBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, new DeleteBucketLifecycleConfigurationRequest(), HttpMethodName.DELETE);
        request.addParameter("lifecycle", null);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    public String signString(String stringToSign) {
        Credentials credentials = this.CredentialsProvider.getCredentials();
        return new NosStringSigner().sign(stringToSign, credentials);
    }

    public boolean validateStringSignature(String stringToSign, String signature) {
        Credentials credentials = this.CredentialsProvider.getCredentials();
        String signatueLocal = new NosStringSigner().sign(stringToSign, credentials);
        return signatueLocal.equals(signature);
    }

    public static void main(String[] args) {
        XmlWriter xml = new XmlWriter();
        xml.start("Default404Configuration", "xmlns", "http://nos.netease.com//");
        xml.start("Key").value("hello").end();
        xml.end();
        System.out.println(xml.toString());
    }
}

