/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.services.nos;

import com.netease.cloud.ClientConfiguration;
import com.netease.cloud.ClientException;
import com.netease.cloud.auth.CredentialsProvider;
import com.netease.cloud.internal.NOSDirect;
import com.netease.cloud.internal.crypto.CryptoConfiguration;
import com.netease.cloud.internal.crypto.CryptoModuleDispatcher;
import com.netease.cloud.internal.crypto.EncryptionMaterialsProvider;
import com.netease.cloud.internal.crypto.NOSCryptoModule;
import com.netease.cloud.services.nos.NosClient;
import com.netease.cloud.services.nos.model.AbortMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadRequest;
import com.netease.cloud.services.nos.model.CompleteMultipartUploadResult;
import com.netease.cloud.services.nos.model.DeleteObjectRequest;
import com.netease.cloud.services.nos.model.EncryptedInitiateMultipartUploadRequest;
import com.netease.cloud.services.nos.model.GetObjectRequest;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadRequest;
import com.netease.cloud.services.nos.model.InitiateMultipartUploadResult;
import com.netease.cloud.services.nos.model.NOSObject;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.services.nos.model.PutObjectRequest;
import com.netease.cloud.services.nos.model.PutObjectResult;
import com.netease.cloud.services.nos.model.UploadPartRequest;
import com.netease.cloud.services.nos.model.UploadPartResult;
import java.io.File;

public class NOSEncryptionClient
extends NosClient {
    private final NOSCryptoModule crypto;

    public NOSEncryptionClient(CredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig) {
        super(credentialsProvider.getCredentials(), clientConfig);
        this.assertParameterNotNull(kekMaterialsProvider, "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(cryptoConfig, "CryptoConfiguration parameter must not be null.");
        this.crypto = new CryptoModuleDispatcher(new NOSDirectImpl(), credentialsProvider, kekMaterialsProvider, cryptoConfig);
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest req) {
        return this.crypto.putObjectSecurely(req);
    }

    @Override
    public NOSObject getObject(GetObjectRequest req) {
        return this.crypto.getObjectSecurely(req);
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest req, File dest) {
        return this.crypto.getObjectSecurely(req, dest);
    }

    @Override
    public void deleteObject(DeleteObjectRequest req) {
        super.deleteObject(req);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest req) {
        return this.crypto.completeMultipartUploadSecurely(req);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest req) {
        boolean isCreateEncryptionMaterial = true;
        if (req instanceof EncryptedInitiateMultipartUploadRequest) {
            EncryptedInitiateMultipartUploadRequest cryptoReq = (EncryptedInitiateMultipartUploadRequest)req;
            isCreateEncryptionMaterial = cryptoReq.isCreateEncryptionMaterial();
        }
        return isCreateEncryptionMaterial ? this.crypto.initiateMultipartUploadSecurely(req) : super.initiateMultipartUpload(req);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws ClientException {
        return this.crypto.uploadPartSecurely(uploadPartRequest);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest req) {
        this.crypto.abortMultipartUploadSecurely(req);
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    private final class NOSDirectImpl
    extends NOSDirect {
        private NOSDirectImpl() {
        }

        @Override
        public PutObjectResult putObject(PutObjectRequest req) {
            return NOSEncryptionClient.super.putObject(req);
        }

        @Override
        public NOSObject getObject(GetObjectRequest req) {
            return NOSEncryptionClient.super.getObject(req);
        }

        @Override
        public ObjectMetadata getObject(GetObjectRequest req, File dest) {
            return NOSEncryptionClient.super.getObject(req, dest);
        }

        @Override
        public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest req) {
            return NOSEncryptionClient.super.completeMultipartUpload(req);
        }

        @Override
        public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest req) {
            return NOSEncryptionClient.super.initiateMultipartUpload(req);
        }

        @Override
        public UploadPartResult uploadPart(UploadPartRequest req) throws ClientException {
            return NOSEncryptionClient.super.uploadPart(req);
        }

        @Override
        public void abortMultipartUpload(AbortMultipartUploadRequest req) {
            NOSEncryptionClient.super.abortMultipartUpload(req);
        }
    }
}

