/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.internal.crypto;

import com.netease.cloud.ClientException;
import com.netease.cloud.WebServiceRequest;
import com.netease.cloud.internal.crypto.CipherLite;
import com.netease.cloud.internal.crypto.ContentCryptoScheme;
import com.netease.cloud.internal.crypto.CryptoMode;
import com.netease.cloud.internal.crypto.EncryptionMaterials;
import com.netease.cloud.internal.crypto.EncryptionMaterialsAccessor;
import com.netease.cloud.internal.crypto.NOSCryptoScheme;
import com.netease.cloud.internal.crypto.NOSKeyWrapScheme;
import com.netease.cloud.internal.crypto.SecuredCEK;
import com.netease.cloud.services.nos.model.MaterialsDescriptionProvider;
import com.netease.cloud.services.nos.model.ObjectMetadata;
import com.netease.cloud.util.Base64;
import com.netease.cloud.util.Jackson;
import com.netease.cloud.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;

    ContentCryptoMaterial(Map<String, String> kekMaterialsDescription, byte[] encryptedCEK, String keyWrappingAlgorithm, CipherLite cipherLite) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
        this.encryptedCEK = (byte[])encryptedCEK.clone();
        this.kekMaterialsDescription = kekMaterialsDescription;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata metadata, CryptoMode mode) {
        return this.toObjectMetadata(metadata);
    }

    private ObjectMetadata toObjectMetadata(ObjectMetadata metadata) {
        String keyWrapAlgo;
        byte[] encryptedCEK = this.getEncryptedCEK();
        metadata.addUserMetadata("x-nos-meta-key-v2", Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        metadata.addUserMetadata("x-nos-meta-iv", Base64.encodeAsString(iv));
        metadata.addUserMetadata("x-nos-meta-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        metadata.addUserMetadata("x-nos-meta-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            metadata.addUserMetadata("x-nos-meta-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            metadata.addUserMetadata("x-nos-meta-wrap-alg", keyWrapAlgo);
        }
        return metadata;
    }

    String toJsonString() {
        String keyWrapAlgo;
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] encryptedCEK = this.getEncryptedCEK();
        map.put("x-nos-meta-key-v2", Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        map.put("x-nos-meta-iv", Base64.encodeAsString(iv));
        map.put("x-nos-meta-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        map.put("x-nos-meta-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            map.put("x-nos-meta-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            map.put("x-nos-meta-wrap-alg", keyWrapAlgo);
        }
        return Jackson.toJsonString(map);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> kekMaterialDesc = this.getKEKMaterialsDescription();
        if (kekMaterialDesc == null) {
            kekMaterialDesc = Collections.emptyMap();
        }
        return Jackson.toJsonString(kekMaterialDesc);
    }

    private static Map<String, String> matdescFromJson(String json) {
        Map map = Jackson.fromJsonString(json, Map.class);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, Provider securityProvider, ContentCryptoScheme contentCryptoScheme) {
        Key kek;
        if (materials.getKeyPair() != null ? (kek = materials.getKeyPair().getPrivate()) == null : (kek = materials.getSymmetricKey()) == null) {
            throw new ClientException("Key encrypting key not available");
        }
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = securityProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, securityProvider);
                cipher.init(4, kek);
                return (SecretKey)cipher.unwrap(cekSecured, keyWrapAlgo, 3);
            }
            Cipher cipher = securityProvider != null ? Cipher.getInstance(kek.getAlgorithm(), securityProvider) : Cipher.getInstance(kek.getAlgorithm());
            cipher.init(2, kek);
            byte[] decryptedSymmetricKeyBytes = cipher.doFinal(cekSecured);
            return new SecretKeySpec(decryptedSymmetricKeyBytes, "AES");
        }
        catch (Exception e) {
            throw new ClientException("Unable to decrypt symmetric key from object metadata", e);
        }
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, boolean keyWrapExpected) {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, null, keyWrapExpected);
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, boolean keyWrapExpected) {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, range, keyWrapExpected);
    }

    private static ContentCryptoMaterial fromObjectMetadata0(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, boolean keyWrapExpected) {
        EncryptionMaterials materials;
        Map<String, String> userMeta = metadata.getUserMetadata();
        String b64key = userMeta.get("x-nos-meta-key-v2");
        if (b64key == null && (b64key = userMeta.get("x-nos-meta-key")) == null) {
            throw new ClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv = Base64.decode(userMeta.get("x-nos-meta-iv"));
        if (cekWrapped == null || iv == null) {
            throw new ClientException("Content encrypting key or IV not found.");
        }
        String matdescStr = userMeta.get("x-nos-meta-matdesc");
        String keyWrapAlgo = userMeta.get("x-nos-meta-wrap-alg");
        Map<String, String> core = ContentCryptoMaterial.matdescFromJson(matdescStr);
        EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(core);
        if (materials == null) {
            throw new ClientException("Unable to retrieve the client encryption materials");
        }
        String cekAlgo = userMeta.get("x-nos-meta-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = userMeta.get("x-nos-meta-tag-len")))) {
                throw new ClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        if (keyWrapExpected && keyWrapAlgo == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider, contentCryptoScheme);
        return new ContentCryptoMaterial(core, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider));
    }

    private static ClientException newKeyWrapException() {
        return new ClientException("Missing key-wrap for the content-encrypting-key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StringUtils.UTF8));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }

    ContentCryptoMaterial recreate(Map<String, String> newKEKMatDesc, EncryptionMaterialsAccessor accessor, NOSCryptoScheme targetScheme, Provider p, WebServiceRequest req) {
        if (newKEKMatDesc.equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        EncryptionMaterials origKEK = accessor.getEncryptionMaterials(this.kekMaterialsDescription);
        if (origKEK == null) {
            throw new ClientException("Unable to retrieve the origin encryption materials");
        }
        EncryptionMaterials newKEK = accessor.getEncryptionMaterials(newKEKMatDesc);
        if (newKEK == null) {
            throw new ClientException("No material available with the description " + newKEKMatDesc + " from the encryption material provider");
        }
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p, this.getContentCryptoScheme());
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p, req);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    ContentCryptoMaterial recreate(EncryptionMaterials newKEK, EncryptionMaterialsAccessor accessor, NOSCryptoScheme targetScheme, Provider p, WebServiceRequest req) {
        if (newKEK.getMaterialsDescription().equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        EncryptionMaterials origKEK = accessor.getEncryptionMaterials(this.kekMaterialsDescription);
        if (origKEK == null) {
            throw new ClientException("Unable to retrieve the origin encryption materials");
        }
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p, this.getContentCryptoScheme());
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p, req);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, NOSCryptoScheme targetScheme, Provider provider, WebServiceRequest req) {
        return ContentCryptoMaterial.doCreate(cek, iv, kekMaterials, contentCryptoScheme, targetScheme, provider, req);
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, NOSCryptoScheme scheme, Provider provider, WebServiceRequest req) {
        return ContentCryptoMaterial.doCreate(cek, iv, kekMaterials, scheme.getContentCryptoScheme(), scheme, provider, req);
    }

    private static ContentCryptoMaterial doCreate(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, NOSCryptoScheme targetNOSCryptoScheme, Provider provider, WebServiceRequest req) {
        SecuredCEK cekSecured = ContentCryptoMaterial.secureCEK(cek, kekMaterials, targetNOSCryptoScheme.getKeyWrapScheme(), targetNOSCryptoScheme.getSecureRandom(), provider, req);
        return ContentCryptoMaterial.wrap(cek, iv, contentCryptoScheme, provider, cekSecured);
    }

    public static ContentCryptoMaterial wrap(SecretKey cek, byte[] iv, ContentCryptoScheme contentCryptoScheme, Provider provider, SecuredCEK cekSecured) {
        return new ContentCryptoMaterial(cekSecured.getMaterialDescription(), cekSecured.getEncrypted(), cekSecured.getKeyWrapAlgorithm(), contentCryptoScheme.createCipherLite(cek, iv, 1, provider));
    }

    private static SecuredCEK secureCEK(SecretKey cek, EncryptionMaterials materials, NOSKeyWrapScheme kwScheme, SecureRandom srand, Provider p, WebServiceRequest req) {
        Map<String, String> matdesc = materials.getMaterialsDescription();
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        String keyWrapAlgo = kwScheme.getKeyWrapAlgorithm(kek);
        try {
            Cipher cipher = p == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, p);
            cipher.init(3, kek, srand);
            return new SecuredCEK(cipher.wrap(cek), keyWrapAlgo, matdesc);
        }
        catch (Exception e) {
            throw new ClientException("Unable to encrypt symmetric key", e);
        }
    }

    static Map<String, String> mergeMaterialDescriptions(EncryptionMaterials materials, WebServiceRequest req) {
        MaterialsDescriptionProvider mdp;
        Map<String, String> matdesc_req;
        Map<String, String> matdesc = materials.getMaterialsDescription();
        if (req instanceof MaterialsDescriptionProvider && (matdesc_req = (mdp = (MaterialsDescriptionProvider)((Object)req)).getMaterialsDescription()) != null) {
            matdesc = new TreeMap<String, String>(matdesc);
            matdesc.putAll(matdesc_req);
        }
        return matdesc;
    }
}

