/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.http;

import com.netease.cloud.ResponseMetadata;
import com.netease.cloud.WebServiceResponse;
import com.netease.cloud.http.HttpResponse;
import com.netease.cloud.http.HttpResponseHandler;
import com.netease.cloud.transform.StaxUnmarshallerContext;
import com.netease.cloud.transform.Unmarshaller;
import com.netease.cloud.transform.VoidStaxUnmarshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxResponseHandler<T>
implements HttpResponseHandler<WebServiceResponse<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private static final Logger log = LoggerFactory.getLogger((String)"com.netease.cloud.request");
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebServiceResponse<T> handle(HttpResponse response) throws Exception {
        log.trace("Parsing service response XML");
        InputStream content = response.getContent();
        if (content == null) {
            content = new ByteArrayInputStream("<eof/>".getBytes());
        }
        XMLEventReader eventReader = xmlInputFactory.createXMLEventReader(content);
        try {
            WebServiceResponse<T> Response = new WebServiceResponse<T>();
            StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, response.getHeaders());
            unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "REQUEST_ID");
            unmarshallerContext.registerMetadataExpression("requestId", 2, "REQUEST_ID");
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            Response.setResult(result);
            Map<String, String> metadata = unmarshallerContext.getMetadata();
            Response.setResponseMetadata(new ResponseMetadata(metadata));
            log.trace("Done parsing service response");
            WebServiceResponse<T> webServiceResponse = Response;
            return webServiceResponse;
        }
        finally {
            try {
                eventReader.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

