/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodReleaseInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(HttpMethodReleaseInputStream.class);
    private InputStream inputStream = null;
    private HttpEntityEnclosingRequest httpRequest = null;
    private boolean alreadyReleased = false;
    private boolean underlyingStreamConsumed = false;

    public HttpMethodReleaseInputStream(HttpEntityEnclosingRequest httpMethod) {
        this.httpRequest = httpMethod;
        try {
            this.inputStream = httpMethod.getEntity().getContent();
        }
        catch (IOException e) {
            if (log.isWarnEnabled()) {
                log.warn("Unable to obtain HttpMethod's response data stream", (Throwable)e);
            }
            try {
                httpMethod.getEntity().getContent().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = new ByteArrayInputStream(new byte[0]);
        }
    }

    public HttpEntityEnclosingRequest getHttpRequest() {
        return this.httpRequest;
    }

    protected void releaseConnection() throws IOException {
        if (!this.alreadyReleased) {
            if (!this.underlyingStreamConsumed && this.httpRequest instanceof AbortableHttpRequest) {
                AbortableHttpRequest abortableHttpRequest = (AbortableHttpRequest)this.httpRequest;
                abortableHttpRequest.abort();
            }
            this.inputStream.close();
            this.alreadyReleased = true;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int read = this.inputStream.read();
            if (read == -1) {
                this.underlyingStreamConsumed = true;
                if (!this.alreadyReleased) {
                    this.releaseConnection();
                    if (log.isDebugEnabled()) {
                        log.debug("Released HttpMethod as its response data stream is fully consumed");
                    }
                }
            }
            return read;
        }
        catch (IOException e) {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug("Released HttpMethod as its response data stream threw an exception", (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.inputStream.read(b, off, len);
            if (read == -1) {
                this.underlyingStreamConsumed = true;
                if (!this.alreadyReleased) {
                    this.releaseConnection();
                    if (log.isDebugEnabled()) {
                        log.debug("Released HttpMethod as its response data stream is fully consumed");
                    }
                }
            }
            return read;
        }
        catch (IOException e) {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug("Released HttpMethod as its response data stream threw an exception", (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug("Released HttpMethod as its response data stream threw an exception", (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.alreadyReleased) {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug("Released HttpMethod as its response data stream is closed");
            }
        }
        this.inputStream.close();
    }

    protected void finalize() throws Throwable {
        if (!this.alreadyReleased) {
            if (log.isWarnEnabled()) {
                log.warn("Attempting to release HttpMethod in finalize() as its response data stream has gone out of scope. This attempt will not always succeed and cannot be relied upon! Please ensure S3 response data streams are always fully consumed or closed to avoid HTTP connection starvation.");
            }
            this.releaseConnection();
            if (log.isWarnEnabled()) {
                log.warn("Successfully released HttpMethod in finalize(). You were lucky this time... Please ensure S3 response data streams are always fully consumed or closed.");
            }
        }
        super.finalize();
    }
}

