/*
 * Decompiled with CFR 0.152.
 */
package com.netease.cloud.handlers;

import com.netease.cloud.ClientException;
import com.netease.cloud.handlers.RequestHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class HandlerChainFactory {
    public List<RequestHandler> newRequestHandlerChain(String resource) {
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        try {
            String requestHandlerClassName;
            InputStream input = this.getClass().getResourceAsStream(resource);
            if (input == null) {
                return handlers;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((requestHandlerClassName = reader.readLine()) != null) {
                if ((requestHandlerClassName = requestHandlerClassName.trim()).equals("")) continue;
                Class<?> requestHandlerClass = this.getClass().getClassLoader().loadClass(requestHandlerClassName);
                Object requestHandlerObject = requestHandlerClass.newInstance();
                if (requestHandlerObject instanceof RequestHandler) {
                    handlers.add((RequestHandler)requestHandlerObject);
                    continue;
                }
                throw new ClientException("Unable to instantiate request handler chain for client.  Listed request handler ('" + requestHandlerClassName + "') does not implement the RequestHandler interface.");
            }
        }
        catch (Exception e) {
            throw new ClientException("Unable to instantiate request handler chain for client: " + e.getMessage(), e);
        }
        return handlers;
    }
}

